/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Ruppert;
import java.io.Serializable;

class Initializer
implements Serializable {
    private static final long serialVersionUID = 1L;

    Initializer() {
    }

    public static final Ruppert init(double x0, double y0, double x1, double y1, int xnum, int ynum) {
        return Initializer.init(x0, y0, x1, y1, xnum, ynum, new double[0], new int[0]);
    }

    public static final Ruppert init(double x0, double y0, double x1, double y1, int xnum, int ynum, double[] h, int[] ref) {
        int i;
        if (xnum < 1 || ynum < 1) {
            throw new IllegalArgumentException("arguments(s) corrupt");
        }
        double[][] p = new double[1 + h.length / 3][];
        p[0] = new double[4 * (xnum + ynum)];
        int c = 0;
        double xplus = (x1 - x0) / (double)xnum;
        double yplus = (y1 - y0) / (double)ynum;
        for (i = 0; i < xnum; ++i) {
            p[0][c++] = x0 + xplus * (double)i;
            p[0][c++] = y0;
        }
        for (i = 0; i < ynum; ++i) {
            p[0][c++] = x1;
            p[0][c++] = y0 + yplus * (double)i;
        }
        for (i = 0; i < xnum; ++i) {
            p[0][c++] = x1 - xplus * (double)i;
            p[0][c++] = y1;
        }
        for (i = 0; i < ynum; ++i) {
            p[0][c++] = x0;
            p[0][c++] = y1 - yplus * (double)i;
        }
        for (i = 0; i < h.length / 3; ++i) {
            double pplus = Math.PI * 2 / (double)ref[i];
            c = 0;
            p[i + 1] = new double[2 * ref[i]];
            for (int j = 0; j < ref[i]; ++j) {
                p[i + 1][c++] = h[3 * i + 2] * Math.cos(pplus * (double)j) + h[3 * i];
                p[i + 1][c++] = h[3 * i + 2] * Math.sin(pplus * (double)j) + h[3 * i + 1];
            }
        }
        return new Ruppert(p);
    }
}

