/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.util;

public final class Arrays {
    private Arrays() {
    }

    public static final double[] size(double[] target, int size) {
        return target.length == size ? target : new double[size];
    }

    public static final double[] resize(double[] target, int size) {
        if (target.length == size) {
            return target;
        }
        double[] newTarget = new double[size];
        System.arraycopy(target, 0, newTarget, 0, Math.min(size, target.length));
        return newTarget;
    }

    public static final double[] unrole(double[] target, double[] values, int numOfTimes) {
        int length = values.length * numOfTimes;
        if (target.length != values.length * numOfTimes) {
            target = new double[length];
        }
        System.arraycopy(values, 0, target, 0, values.length);
        int i = values.length;
        while (2 * i < length) {
            System.arraycopy(target, 0, target, i, i);
            i *= 2;
        }
        System.arraycopy(target, 0, target, i, length - i);
        return target;
    }

    public static final double[] concat(double[] target, double[] con, double[] cat) {
        if (target.length != con.length + cat.length) {
            target = new double[con.length + cat.length];
        }
        System.arraycopy(con, 0, target, 0, con.length);
        System.arraycopy(cat, 0, target, con.length, cat.length);
        return target;
    }

    public static final void fill(double[] target, double value) {
        Arrays.fill(target, 0, target.length, value);
    }

    public static final void fill(double[] target, int position, int length, double value) {
        if (length < 1) {
            return;
        }
        target[position + 0] = value;
        if (length < 2) {
            return;
        }
        target[position + 1] = value;
        if (length < 3) {
            return;
        }
        target[position + 2] = value;
        if (length < 4) {
            return;
        }
        target[position + 3] = value;
        if (length < 5) {
            return;
        }
        target[position + 4] = value;
        int i = 5;
        while (2 * i < length) {
            System.arraycopy(target, position, target, position + i, i);
            i *= 2;
        }
        System.arraycopy(target, position, target, position + i, length - i);
    }

    public static final double getMin(double[] target) {
        return Arrays.getMin(target, 0, target.length);
    }

    public static final double getMin(double[] target, int position, int length) {
        double min = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (!(min > target[i])) continue;
            min = target[i];
        }
        return min;
    }

    public static final double getMax(double[] target) {
        return Arrays.getMax(target, 0, target.length);
    }

    public static final double getMax(double[] target, int position, int length) {
        double max = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (!(max > target[i])) continue;
            max = target[i];
        }
        return max;
    }

    public static final float[] size(float[] target, int size) {
        return target.length == size ? target : new float[size];
    }

    public static final float[] resize(float[] target, int size) {
        if (target.length == size) {
            return target;
        }
        float[] newTarget = new float[size];
        System.arraycopy(target, 0, newTarget, 0, Math.min(size, target.length));
        return newTarget;
    }

    public static final float[] unrole(float[] target, float[] values, int numOfTimes) {
        int length = values.length * numOfTimes;
        if (target.length != values.length * numOfTimes) {
            target = new float[length];
        }
        System.arraycopy(values, 0, target, 0, values.length);
        int i = values.length;
        while (2 * i < length) {
            System.arraycopy(target, 0, target, i, i);
            i *= 2;
        }
        System.arraycopy(target, 0, target, i, length - i);
        return target;
    }

    public static final float[] concat(float[] target, float[] con, float[] cat) {
        if (target.length != con.length + cat.length) {
            target = new float[con.length + cat.length];
        }
        System.arraycopy(con, 0, target, 0, con.length);
        System.arraycopy(cat, 0, target, con.length, cat.length);
        return target;
    }

    public static final void fill(float[] target, float value) {
        Arrays.fill(target, 0, target.length, value);
    }

    public static final void fill(float[] target, int position, int length, float value) {
        if (length < 1) {
            return;
        }
        target[position + 0] = value;
        if (length < 2) {
            return;
        }
        target[position + 1] = value;
        if (length < 3) {
            return;
        }
        target[position + 2] = value;
        if (length < 4) {
            return;
        }
        target[position + 3] = value;
        if (length < 5) {
            return;
        }
        target[position + 4] = value;
        int i = 5;
        while (2 * i < length) {
            System.arraycopy(target, position, target, position + i, i);
            i *= 2;
        }
        System.arraycopy(target, position, target, position + i, length - i);
    }

    public static final float getMin(float[] target) {
        return Arrays.getMin(target, 0, target.length);
    }

    public static final float getMin(float[] target, int position, int length) {
        float min = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (!(min > target[i])) continue;
            min = target[i];
        }
        return min;
    }

    public static final float getMax(float[] target) {
        return Arrays.getMax(target, 0, target.length);
    }

    public static final float getMax(float[] target, int position, int length) {
        float max = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (!(max > target[i])) continue;
            max = target[i];
        }
        return max;
    }

    public static final int[] size(int[] target, int size) {
        return target.length == size ? target : new int[size];
    }

    public static final int[] resize(int[] target, int size) {
        if (target.length == size) {
            return target;
        }
        int[] newTarget = new int[size];
        System.arraycopy(target, 0, newTarget, 0, Math.min(size, target.length));
        return newTarget;
    }

    public static final int[] unrole(int[] target, int[] values, int numOfTimes) {
        int length = values.length * numOfTimes;
        if (target.length != values.length * numOfTimes) {
            target = new int[length];
        }
        System.arraycopy(values, 0, target, 0, values.length);
        int i = values.length;
        while (2 * i < length) {
            System.arraycopy(target, 0, target, i, i);
            i *= 2;
        }
        System.arraycopy(target, 0, target, i, length - i);
        return target;
    }

    public static final int[] concat(int[] target, int[] con, int[] cat) {
        if (target.length != con.length + cat.length) {
            target = new int[con.length + cat.length];
        }
        System.arraycopy(con, 0, target, 0, con.length);
        System.arraycopy(cat, 0, target, con.length, cat.length);
        return target;
    }

    public static final void fill(int[] target, int value) {
        Arrays.fill(target, 0, target.length, value);
    }

    public static final void fill(int[] target, int position, int length, int value) {
        if (length < 1) {
            return;
        }
        target[position + 0] = value;
        if (length < 2) {
            return;
        }
        target[position + 1] = value;
        if (length < 3) {
            return;
        }
        target[position + 2] = value;
        if (length < 4) {
            return;
        }
        target[position + 3] = value;
        if (length < 5) {
            return;
        }
        target[position + 4] = value;
        int i = 5;
        while (2 * i < length) {
            System.arraycopy(target, position, target, position + i, i);
            i *= 2;
        }
        System.arraycopy(target, position, target, position + i, length - i);
    }

    public static final int getMin(int[] target) {
        return Arrays.getMin(target, 0, target.length);
    }

    public static final int getMin(int[] target, int position, int length) {
        int min = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (min <= target[i]) continue;
            min = target[i];
        }
        return min;
    }

    public static final int getMax(int[] target) {
        return Arrays.getMax(target, 0, target.length);
    }

    public static final int getMax(int[] target, int position, int length) {
        int max = target[position];
        for (int i = 0; i < position + length; ++i) {
            if (max <= target[i]) continue;
            max = target[i];
        }
        return max;
    }
}

