
package edu.jhu.ece.iacl.processcontrol;

import java.io.*;
import java.util.*;

import javax.swing.JOptionPane;

import org.ggf.drmaa.*;

public class DispatchController {

	private static Session session;
	
	private static ArrayList<ProcessController> jobList = new ArrayList<ProcessController>();

	//Returns DRMAA Session object
	public static Session getDRMAASession()
	{
		return session; 
	}

	//Returns List of Jobs Created
	public static ArrayList getJobList()
	{
		return jobList;
	}

	//Initialize a DRMAA Session
	//Returns whether a session is successfully initialized 
	public boolean initDRMAASession()
	{
		boolean success;
		try{
		SessionFactory factory = SessionFactory.getFactory();
			session = factory.getSession();
			session.init("");
			success = true; 
			System.out.println("Session has been initialized");
		}catch(AlreadyActiveSessionException e)
		{
			success = true;
		}
		catch(DrmaaException e)
		{
			System.out.println("Exception" + e);
			success = false;
			System.out.println("Session has not been initialized due to Exception:" + e);
		} catch(LinkageError e) {
			System.out.println("UnsatisfiedLinkError" + e);
			success = false;
			System.out.println("Session has not been initialized due to Exception:" + e);	
		}
		return success;    
	}

	public boolean restoreDRMAASession(File SessionIDFile)
	{
		boolean success;
		SessionFactory factory = SessionFactory.getFactory();
		this.session = factory.getSession();
		try{
			BufferedReader inputfile = new BufferedReader(new FileReader(SessionIDFile));
			session.init(inputfile.readLine());
			inputfile.close();
			success = true;
		} catch (Exception e)
		{
			System.out.println("Exception" + e);
			success = false;
		}	
		return success;
	}

	public boolean saveDRMAASession(File SessionIDFile) {

		boolean success; 	
		try{
			FileWriter fstream = new FileWriter(SessionIDFile);
			BufferedWriter out = new BufferedWriter(fstream);
			if(session.getContact()==null)
			{
				System.out.println("There is no active Session Running");
				success = false;
			}
			else 
			{
				out.write(session.getContact());
				out.close();
				System.out.println("Session is saved to: " + SessionIDFile.toString());
				success = true;
			}	    
		}catch(Exception e)
		{
			System.out.println("Exception" + e);
			success = false;
		}	
		return success;
	}

	/**
	 * @param Path
	 * @param WorkingDir
	 * @param OutPath
	 * @param ErrPath
	 * @param SpecificationreateJob(SGE, jre +" "+ "-Xmx" + (runParams.getMaxHeap()) + "m "+ "-classpath " + "\"" + classpath + "\"" + " edu.jhu.ece.iacl.pipeline.PipeRunner" + " " + "\"" + pipeFile.getAbsolutePath() + "\"" + " " + "\"" + runParams.getInputDirectory().getAbsolutePath() + "\"" + " " + layout.getFileLocation().getParent());
		} else {
	 * @return
	 */
	public ProcessController createJob(boolean SGE, List<String> Command)
	{
		//if there is a DRMAA session, return a ProcessControllerDRMAA
		//if there is no DRMAA session, return a ProcessControllerNative
		 
		ProcessController p;
		if (SGE)
		{   
			p = new ProcessControllerDRMAA();
			if(!p.Setup(Command)) 
			{
				JOptionPane.showMessageDialog(null, "DRMAA Failed");
				System.err.println("Error when creating DRMAA Job, Please check Envoirnment Variable settings, Switch to Native");
			}
		}		
		else
		{
			p = new ProcessControllerNative(Command);			
		}
		jobList.add(p);
		return p;
	}



	public ArrayList<ProcessController> listAllJobs() {
		jobList.size();
		for(int i=0; i<=jobList.size()-1; i++)
		{
			System.out.println("Job ID: " + jobList.get(i).toString());
			System.out.println("Status: " + jobList.get(i).getStatus());
		}
		return jobList;
	}


	public void closeSession(boolean terminateAllActiveJobs)
	{
		int JobCreated = jobList.size();
		if(terminateAllActiveJobs)
		{
			try{
				for(int i=0; i<=JobCreated-1; i++)
				{
					session.control(jobList.get(i).toString(), session.TERMINATE);
				}
				System.out.println("All job are terminated");
				session.exit();
			}catch(DrmaaException e)
			{
				System.out.println("Jobs Cannot be Termianted because Exception:" + e);
			}
		}
		else 
			try{
				session.synchronize(Collections.singletonList(Session.JOB_IDS_SESSION_ALL),
						Session.TIMEOUT_WAIT_FOREVER, true);
				System.out.println("ALL jobs are finished");
				session.exit();
				
			}catch(DrmaaException e)
			{
				System.out.println("Exception" + e);
			}
	}


}
