/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package database;

import java.io.Serializable;
import java.util.ArrayList;


/**
 * Represents a row in a database table
 * @author rbanalagay
 */
public class DatabaseEntry implements Serializable{
 
    private String[] tableInputs;
    private String machineID;
    private boolean isUseGrid = false;
    private int cpuTime;
    private int memUsed;
    private static final long serialVersionUID = 42L; 
    
    
    public static DatabaseEntry getCopy(DatabaseEntry entryToCopy)
    {
        String[] inputCopy = new String[entryToCopy.tableInputs.length];
        System.arraycopy(entryToCopy.tableInputs,
                0, inputCopy, 0, inputCopy.length);
        
        DatabaseEntry copy = new DatabaseEntry();
        copy.tableInputs = inputCopy;
        copy.machineID = entryToCopy.machineID;
        copy.isUseGrid = entryToCopy.isUseGrid;
        copy.cpuTime = entryToCopy.cpuTime;
        copy.memUsed = entryToCopy.memUsed;
        
        return copy;
    }
    private DatabaseEntry(){}
    public DatabaseEntry(String[] tableInputs, String machineID,
            String isUseGrid, int cpuTime, int memUsed)
    {   
        ArrayList<String> stringInputs = new ArrayList<String>();
        for(String s: tableInputs)
        {
            if(s.contains(";"))
            {
                String[] matRows = s.split(";");
                
                String aRow = matRows[0];
                String[] matCols = aRow.split(" ");
                int rows = matRows.length;
                int cols = matCols.length;
                stringInputs.add(rows+","+cols);
                //System.out.println(rows+","+cols);
            }
            else
            {
                stringInputs.add(s);
            } 
        }
        this.machineID = machineID;
        this.isUseGrid = (isUseGrid.equalsIgnoreCase("TRUE"));        
        
        stringInputs.add(getMachineName());
        this.tableInputs = 
                stringInputs.toArray(new String[stringInputs.size()]);
        this.cpuTime = cpuTime;
        this.memUsed = memUsed;      
    }
    
    private String getMachineName()
    {
        return isUseGrid ? machineID+"TRUE" : machineID+"FALSE";
    }
    public String getOutputMachineName()
    {
        return isUseGrid ? "Grid" : machineID;
    }
    private static class DummyHolder
    {
        ArrayList<String> inputHolder = new ArrayList<String>();
        public void addValue(String s)
        {
            inputHolder.add(s);
        }
        public String[] getFinalizedArray()
        {
            return inputHolder.toArray(new String[inputHolder.size()]);
        }
    }
    public static void alignInputs(DatabaseEntry[] entrySet)
    {
        int maxEntryLength = 0;
        
        //Find the maximum length of the input array
        for(DatabaseEntry currentEntry : entrySet)
        {
            if(currentEntry.tableInputs.length>maxEntryLength)
            {
                maxEntryLength = currentEntry.tableInputs.length;
            }
        }
        
        //Create an array of arraylists
        DummyHolder[] replacements = new DummyHolder[entrySet.length];
        for(int x=0; x<replacements.length; x++)
        {
            replacements[x] = new DummyHolder();
        }
        
        //Iterate over the input array
        for(int x=0; x<maxEntryLength; x++)
        {
            //figure out the max length a particular element
            //subdivides into
            int maxCurrentInputLength = 0;
            for(DatabaseEntry currentEntry: entrySet)
            {
                //If the input element exists
                if(x<currentEntry.tableInputs.length)
                {
                    int tempLength = 
                            currentEntry.tableInputs[x].split(",").length;
                    if(tempLength>maxCurrentInputLength)
                        maxCurrentInputLength = tempLength;
                }
            }
            //For each database entry, add the subdivided element parts. If
            //there are too few, pad the array with nulls
            int count = 0;
            for(DatabaseEntry currentEntry: entrySet)
            {
                //Check if input even exists
                int temp = 0;
                if(x<currentEntry.tableInputs.length)
                {
                    String[] subInputs = currentEntry.tableInputs[x].split(",");
                    for(String s : subInputs)
                    {
                        replacements[count].addValue(s);
                        temp++;
                    }
                }
                for(int i=temp; i<maxCurrentInputLength; i++)
                {
                    replacements[count].addValue("0.0");
                }
                count++;
            }
        }
        
        int count = 0;
        for(DatabaseEntry currentEntry : entrySet)
        {
            currentEntry.tableInputs = replacements[count].getFinalizedArray();
            count++;
        }
    }
    
    public static void alignUniqueOnly(DatabaseEntry[] entrySet)
    {
        ArrayList<Integer> uniqueIndexes = new ArrayList<Integer>();
        for(int x=0; x<entrySet[0].tableInputs.length; x++)
        {
            String prevString = entrySet[0].tableInputs[x];
            for(DatabaseEntry currentEntry: entrySet)
            {
                if(!currentEntry.tableInputs[x].equalsIgnoreCase(prevString))
                {
                    uniqueIndexes.add(x);
                    break;
                }
            }
        }
        
        for(DatabaseEntry currentEntry: entrySet)
        {
            String[] replacement = new String[uniqueIndexes.size()];
            int count = 0;
            for(Integer i : uniqueIndexes)
            {
                replacement[count] = currentEntry.tableInputs[i];
                count++;
            }
            currentEntry.tableInputs = replacement;  
        }
        System.out.println("Unique:"+uniqueIndexes.size());
    }
    
    
    private static long toLong(byte[] data) 
    {
        if (data == null || data.length != 8) return 0x0;
        // ----------
        return (long)(
                // (Below) convert to longs before shift because digits
                //         are lost with ints beyond the 32-bit limit
                (long)(0xff & data[0]) << 56  |
                (long)(0xff & data[1]) << 48  |
                (long)(0xff & data[2]) << 40  |
                (long)(0xff & data[3]) << 32  |
                (long)(0xff & data[4]) << 24  |
                (long)(0xff & data[5]) << 16  |
                (long)(0xff & data[6]) << 8   |
                (long)(0xff & data[7]) << 0
                );
    }
    public double getCPUTime()
    {
        return ((double)cpuTime);
    }
    public double getMemUsed()
    {
        return ((double)memUsed);
    }
    
    public String[] getTableInputs()
    {
        return tableInputs;
    }
}
