package edu.masi.hyperadvisor.kernels;

/**
 * This class can be used to quickly get a Gaussian kernel for a set of data points.
 * Designed to be called from the KNN class when building the kernel density.
 * This form can be extended or replicated elsewhere for other kernels.
 * @author covingkj
 *
 */
public class GaussianKernel {
	
	/**
	 * Creates a simple gaussian curve given a mean, std, and where on the x-axis the curve will reside.
	 * @param mean	the mean of some set
	 * @param std	the standard deviation of some set
	 * @param min	the minimum value the curve should represent
	 * @param max	the maximum value the curve should represent
	 * @return		an array representing the resulting curve
	 */
	public static double [] getKernel(float mean, float std, int min, int max){
		double [] res = new double[max-min];
		
		for(int i = min; i < max; i++){
			res[i - min] = 	(1/Math.sqrt( std * 2 * Math.PI ))*
						Math.pow( Math.E, (-Math.pow(i-mean,2)) / (2*std) );
		}
		
		return res;
	}
}
