package edu.masi.hyperadvisor.util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * The log class writes error messages to a file in the home directory of the server.
 * This is important when calling the Hyperadvisor through Axis2, 
 * since these error messages are not preserved after execution.
 * @author covingkj
 *
 */
public class Log {
	private static String logLocation = System.getProperty("user.home") + "/hypervisor_log2.txt";
	private static File log = new File(logLocation);
	
	/**
	 * Default constructor. 
	 * Initializes the path to the log file. 
	 */
	protected Log(){}
	
	/**
	 * Prepends a timestamp to the incoming message.
	 * Safely appends the message to the log file.
	 * @param message	contains the log message to be written to file.
	 */
	@SuppressWarnings("deprecation")
	public static void writeToLog(String message){
		message =  new java.sql.Timestamp(System.currentTimeMillis()).toGMTString() + "\t" + message + "\n";
		try {
			FileWriter fstream  = new FileWriter(log, true);
			BufferedWriter out = new BufferedWriter(fstream);
			out.append(message);
			out.flush();
			out.close();
		} catch (IOException e) { }
	}
	public static void writeToLog(String message,String filename){
		message =  new java.sql.Timestamp(System.currentTimeMillis()).toGMTString() + "\t" + message + "\n";
		try {
			String ll = System.getProperty("user.home") + "/"+filename;
		    File l = new File(ll);
			FileWriter fstream  = new FileWriter(l, true);
			BufferedWriter out = new BufferedWriter(fstream);
			out.append(message);
			out.flush();
			out.close();
		} catch (IOException e) { }
	}
}
