package hypervisortrainer;


import cart.CART;
import cart.Node;
import database.DatabaseEntry;
import database.HypervisorDatabase;
import database.SplittingRule;
import database.SplittingRuleComparator;
import database.VectorSet;
import util.OutputType;
import util.ResultStatistic;
//import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HypervisorTrainer {
    
    public static final String OUTPUT_TRAINING_DIR = 
        System.getProperty("user.home")+"/trainingFiles/";

    private static HypervisorDatabase database;
    private static final int NUM_THREADS = 20;
    //private static Gson gson = new Gson();
    private static final int MIN_DATA_SIZE = 20;
	
	
    private static class TreeTrainer implements Runnable
    {
        VectorSet vectors;
        String title;
        OutputType type;
        public TreeTrainer(VectorSet vectors, 
            String title, OutputType type)
        {
            this.vectors = vectors;
            this.title = title;
            this.type = type;
        }
        
        @Override
        public void run() {
        	CART currentTree = null;
        	if(type.equals(OutputType.CPU_TYPE))
        		currentTree = new CART(title,vectors, type,(int)Math.sqrt(vectors.getNumVectors()),4);
        	else
        		currentTree = new CART(title,vectors,type,(int)Math.sqrt(vectors.getNumVectors()),2);	

            String t = title;
            title += (type.equals(OutputType.CPU_TYPE)) ? 
                    "_CPUTIME" : "_MEMUSED";
            writeTreeToFile(currentTree, title);
        }

        private void writeTreeToFile(CART tree, String title)
        {
            //String gsonString = gson.toJson(tree);
            try{
               // FileWriter fstream = 
              //          new FileWriter(OUTPUT_TRAINING_DIR
              //          +title+".txt");
             //   BufferedWriter out = new BufferedWriter(fstream);
             //   out.write(gsonString);
             //   out.close();    
                //System.out.println(title+".txt written");
                
                
                FileOutputStream f_out = new 
                        FileOutputStream(OUTPUT_TRAINING_DIR
                        +title+".obj");

                // Write object with ObjectOutputStream
                ObjectOutputStream obj_out = new
                        ObjectOutputStream (f_out);
                obj_out.writeObject (tree);
                obj_out.close();
            }
            catch(IOException e)
            {
                e.printStackTrace();
            }
        }        
  
        
    }
    
    public static void main(String[] args)
    {
        try
        {
            database = HypervisorDatabase.getHypervisorDBInstance();
            ExecutorService executor = 
                    Executors.newFixedThreadPool(NUM_THREADS);
            String[] algorithms = database.getAvailableAlgorithmNames();

            for(String currentAlgorithm : algorithms)
            {
                String simpleAlgName = currentAlgorithm
                        .substring(currentAlgorithm.lastIndexOf(".")+1);
                VectorSet tableVectors = 
                        database.getTableEntries(currentAlgorithm);
                
                if(tableVectors!=null && tableVectors.getNumVectors()>
                        (MIN_DATA_SIZE))
                {  
                    Runnable worker = null;
                    worker = new TreeTrainer(tableVectors,
                    		simpleAlgName, OutputType.CPU_TYPE);
                    executor.submit(worker);
                    
                    Runnable worker2 = null;
                    worker2 = new TreeTrainer(VectorSet.
                    		getCopy(tableVectors),
                    		simpleAlgName,OutputType.MEM_TYPE);

                  
                    executor.submit(worker2);
                }
            }
           
            executor.shutdown();
            while(!executor.isTerminated()){}

            
        }
        catch(Exception e)
        {
            System.out.println("Database Error");
            e.printStackTrace();
        }
        
    }    
    
    
    private static void writeFile(String valToWrite, String filename)
    {
        try
        {
            FileWriter fstream = 
                    new FileWriter(OUTPUT_TRAINING_DIR
                    +filename);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(valToWrite);
            out.flush();
            fstream.flush();
            out.close();  
            fstream.close();
        }
        catch(IOException e){e.printStackTrace();}
    }
}
