#!/bin/sh

# Create Hudson job on remote server
# Please customize the username, password, URL if needed
#
# Usage:
#   <cd into the directory containing this script>
#   ./create_job.sh <hudson-job-name-desired> <path-to-config-xml-file>
# Example:
#   ./create_job.sh testjobname ~/.hudson/job/haha/config.xml
#

TEST_CASE_FILE=TestCase.properties
CONTACT_INFO_FILE=ContactInfo.txt
CONFIG_FILE=config.xml
MY_PATH=/share/hudson/tests/default
OUTPUT_COUNT=0
INPUT_COUNT=0

#Generate an empty job_test.out
touch $1/job_test.out
touch $1/finish.txt

# Parse file: TEST_CASE_FILE
while read str_line
do
	case $str_line in
		"Context name:"* )
			CONTEXT_NAME=`echo $str_line | cut -d":" -f2`
			;;
		"~"* )
			read str_line
			MODULE_NAME=$str_line
			#./print $MODULE_NAME
			;;
		"Out Param:"* )
			OUTPUT_LIST[$OUTPUT_COUNT]=`echo $str_line | cut -d"/" -f2`			
			read str_line
			TYPE_LIST[$OUTPUT_COUNT]=$str_line
			read str_line
			THRESHOLD_LIST[$OUTPUT_COUNT]=$str_line
			OUTPUT_COUNT=$(($OUTPUT_COUNT + 1))
			;;
		"-"* )
			INPUT_OPTION_LIST[$INPUT_COUNT]=`echo $str_line | cut -d"-" -f2 | cut -d" " -f1`
			INPUT_PARAM_LIST[$INPUT_COUNT]=`echo $str_line | cut -d" " -f2`
			#echo ${INPUT_OPTION_LIST[$INPUT_COUNT]}
			#echo ${INPUT_PARAM_LIST[$INPUT_COUNT]}
			INPUT_COUNT=$(($INPUT_COUNT + 1))
			;;
	esac
done < $1/$TEST_CASE_FILE

# Get Email
while read str_line
do
	case $str_line in
		"Contact E-mail:"* )
			EMAIL_NAME=`echo $str_line | cut -d" " -f3`
			#./print $EMAIL_NAME
			;;
	esac
done < $1/$CONTACT_INFO_FILE

# amand the config.xml
COUNT=`expr $OUTPUT_COUNT - 1`

sed "/Context name/d" $MY_PATH/$CONFIG_FILE > $1/x0.tmp
sed "/Module name/d" $1/x0.tmp > $1/x.tmp
CONTEXT_ROW="&lt;tr&gt;&lt;td&gt;Context name&lt;/td&gt;&lt;th colspan=&quot;2&quot;&gt;$CONTEXT_NAME&lt;/th&gt;&lt;/tr&gt;&#xd;"
MODULE_ROW="&lt;tr&gt;&lt;td&gt;Module name&lt;/td&gt;&lt;th colspan=&quot;2&quot;&gt;$MODULE_NAME&lt;/th&gt;&lt;/tr&gt;&#xd;"
sed "/table border/a$CONTEXT_ROW" $1/x.tmp > $1/y0.tmp
sed "/Context name/a$MODULE_ROW" $1/y0.tmp > $1/y.tmp
sed "/Test Type/d" $1/y.tmp > $1/z.tmp
sed "/&gt;Threshold&lt;/d" $1/z.tmp > $1/t.tmp
sed "/&gt;Output/d" $1/t.tmp > $1/$COUNT.tmp

while [ $COUNT -ge 0 ]
do
	OUTPUT_ROW="&lt;tr&gt;&lt;th rowspan=&quot;3&quot;&gt;Output$((COUNT + 1))&lt;/th&gt;&lt;td&gt;File Name&lt;/td&gt;&lt;td&gt;${OUTPUT_LIST[$COUNT]}&lt;/td&gt;&lt;/tr&gt;&#xd;"
	TEST_TYPE_ROW="&lt;tr&gt;&lt;td&gt;Test Type&lt;/td&gt;&lt;td&gt;${TYPE_LIST[$COUNT]}&lt;/td&gt;&lt;/tr&gt;&#xd;"
	#THRESHOLD_ROW="&lt;tr&gt;&lt;td&gt;Threshold&lt;/td&gt;&lt;td&gt;${THRESHOLD_LIST[$COUNT]}&lt;/td&gt;&lt;/tr&gt;"
	THRESHOLD_ROW="&lt;tr&gt;&lt;td&gt;Threshold&lt;/td&gt;&lt;td&gt;${THRESHOLD_LIST[$COUNT]}&lt;/td&gt;&lt;/tr&gt;&#xd;"
	OLD_COUNT=$COUNT
	COUNT=$(($COUNT - 1))
	sed  -e "/E-mail/a$OUTPUT_ROW" -e "/E-mail/a$TEST_TYPE_ROW" -e "/E-mail/a$THRESHOLD_ROW" $1/$OLD_COUNT.tmp > $1/$COUNT.tmp

done

#add input para
OLD_COUNT=$(($INPUT_COUNT - 1))
cp -f $1/$COUNT.tmp $1/A$OLD_COUNT.tmp
INPUT_ROW="&lt;tr&gt;&lt;th rowspan=&quot;$INPUT_COUNT&quot;&gt;Input&lt;/th&gt;&lt;td&gt;${INPUT_OPTION_LIST[0]}&lt;/td&gt;&lt;td&gt;${INPUT_PARAM_LIST[0]}&lt;/td&gt;&lt;/tr&gt;&#xd;"
COUNT=$(($INPUT_COUNT - 1))
while [ $COUNT -ge 1 ]
do
	INPUT_ITEM_ROW="&lt;tr&gt;&lt;td&gt;${INPUT_OPTION_LIST[$COUNT]}&lt;/td&gt;&lt;td&gt;${INPUT_PARAM_LIST[$COUNT]}&lt;/td&gt;&lt;/tr&gt;&#xd;"
	OLD_COUNT=$COUNT
	COUNT=$(($COUNT - 1))
	sed "/E-mail/a$INPUT_ITEM_ROW" $1/A$OLD_COUNT.tmp > $1/A$COUNT.tmp
done
sed "/E-mail/a$INPUT_ROW" $1/A$COUNT.tmp > $1/AX.tmp

# amand E-mail
sed "/E-mail/{s#[0-9A-Za-z_-]*@[0-9A-Za-z_-]*\(\.[0-9A-Za-z_-]*\)\{1,2\}#$EMAIL_NAME#;}" $1/AX.tmp > $1/w.tmp

sed "/<hudson.tasks.Shell>/{n;s#rm#rm $1/job_test.out#;}" $1/w.tmp>$1/a0.tmp
RMLINE="rm $1/finish.txt"
QSUB_LINE="qsub $1/myJob.pbs"
CAT_LINE="cat $1/myJob.pbs"
WHILE_LINE="while [ ! -f $1/finish.txt ]"
DO="do"
SLEEP_LINE="sleep 120"
DONE="done"
CAT2_LINE="cat $1/job_test.out"
sed "/rm /a$RMLINE" $1/a0.tmp > $1/a10.tmp
sed "/finish.txt/a$QSUB_LINE" $1/a10.tmp > $1/a11.tmp
sed "/qsub/a$CAT_LINE" $1/a11.tmp > $1/a2.tmp
sed "/cat /a$WHILE_LINE" $1/a2.tmp > $1/a3.tmp
sed "/while/a$DO" $1/a3.tmp > $1/a30.tmp
sed "/do/a$SLEEP_LINE" $1/a30.tmp > $1/a31.tmp
sed "/sleep /a$DONE" $1/a31.tmp > $1/a32.tmp
sed "/done/a$CAT2_LINE" $1/a32.tmp > $1/a.tmp

# copy and clean
cp -f $1/a.tmp $1/$CONFIG_FILE > /dev/null
rm -f $1/*.tmp



sed "/#$ -o.*/{s#\/.*#$1/job_test.out#;}" /share/hudson/tests/default/myJob.pbs>$1/1.tmp

sed "/-e .*/{s#\/.*/test.err#$1/test.err#;}" $1/1.tmp>$1/2.tmp

sed "/-f .*/{s#-f .*/test.auth#-f $1/test.auth#;}" $1/2.tmp>$1/3.tmp

sed "/-Dpath.*\"/{s#-Dpath.*#-Dpath=\"-Dpath=$1\"#;}" $1/3.tmp>$1/4.tmp
sed "/touch .*/{s#touch myJob.pbs#touch $1/finish.txt#;}" $1/4.tmp>$1/myJob.pbs

rm -f $1/*.tmp


curl --user ubuntu64:ubuntu64 -X POST "http://masi.vuse.vanderbilt.edu/hudson/createItem?name=JistTest-$2" --data-binary "@$1/config.xml" -H "Content-Type: text/xml"

