package test;

import java.util.LinkedList;

public class SurfaceCompareSingleton {


	private static SurfaceCompareSingleton instance = null;
	
	private static double surThreshold;
	private static double surThresholdMax;
	
	private static LinkedList<TestcaseStrings> 	tcs;
	private static LinkedList<String> 			directory;
	private static LinkedList<String> 			datadir;
	private static LinkedList<String> 			userdir;
	private static LinkedList<String> 			jredir;
	private static LinkedList<String> 			classpath;
	private static LinkedList<String> 			extdirs;
	
	private static LinkedList<String> fileName;
	private static LinkedList<Double> threshold;

	protected SurfaceCompareSingleton () {
		// we wouldn't want anyone touching this now would we
	}

	public static SurfaceCompareSingleton getInstance () {
		if (instance == null) {
			// initialize vectors here
			tcs 		= new LinkedList<TestcaseStrings>();
			directory   = new LinkedList<String>();
			datadir     = new LinkedList<String>();
			userdir     = new LinkedList<String>();
			jredir      = new LinkedList<String>();
			classpath 	= new LinkedList<String>();
			extdirs 	= new LinkedList<String>();
			instance 	= new SurfaceCompareSingleton();
			
			threshold = new LinkedList<Double>();
			fileName = new LinkedList<String>();
		}

		return instance;
	}

	public void set_data (	TestcaseStrings t, 
							String dir, String ddir, String udir,
							String jdir, String cp, String ed) {
		tcs.offer 		(t);
		directory.offer (dir);
		datadir.offer 	(ddir);
		userdir.offer 	(udir);
		jredir.offer 	(jdir);
		classpath.offer (cp);
		extdirs.offer   (ed);
	}
	
	public void set_fileName ( String name)
	{
		fileName.offer (name);

	}
	
	
	public void set_threshold ( double th) {
		threshold.offer(th);

}

	
	
	// get methods	
	public TestcaseStrings get_tcs () {
		return tcs.poll();
	}

	public String get_directory () {
		return directory.poll();
	}

	public String get_datadir () {
		return datadir.poll();
	}
	
	public String get_userdir () {
		return userdir.poll();
	}
	public String get_jredir () {
		return jredir.poll();
	}
	public String get_classpath () {
		return classpath.poll();
	}
	public String get_extdirs () {
		return extdirs.poll();
	}
	
	
	public double get_threshold(){
		return threshold.poll();
	}
	
	public String get_FileName()
	{
		return fileName.poll();
	}

}
