                                         
package test;

import java.io.*;
import java.util.*;

import java.util.concurrent.Executors;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ExecutorCompletionService;

import javax.vecmath.Point3f;

import org.junit.Test;
import junit.framework.TestCase;

import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.io.*;


public class SurfaceCompareTest extends TestCase{
	
	private String fileName;
	private String fileNameDiff;
	
	public SurfaceCompareTest(String name){
		super (name);
	}
	
	
	
	
	private ImageData getTemplateFromSurface(EmbeddedSurface surf, int padamount){
        Point3f[] pts = surf.getVertexCopy();

        Point3f minpt = new Point3f(pts[0].x, pts[0].y, pts[0].z);
        Point3f maxpt = new Point3f(pts[0].x, pts[0].y, pts[0].z);

        for(int i=1; i<pts.length; i++){
            //min x
            if(pts[i].getX() < minpt.getX()){
                minpt.setX(pts[i].getX());
            }
            //min y
            if(pts[i].getY() < minpt.getY()){
                minpt.setY(pts[i].getY());
            }
            //min z
            if(pts[i].getZ() < minpt.getZ()){
                minpt.setZ(pts[i].getZ());
            }

            //max x
            if(pts[i].getX() > maxpt.getX()){
                maxpt.setX(pts[i].getX());
            }
            //max y
            if(pts[i].getY() > maxpt.getY()){
                maxpt.setY(pts[i].getY());
            }
            //max z
            if(pts[i].getZ() > maxpt.getZ()){
                maxpt.setZ(pts[i].getZ());
            }

        }

        ImageData templateImg = new ImageDataFloat( (int)Math.ceil(maxpt.getX()) + padamount,
                (int)Math.ceil(maxpt.getY())+ padamount, (int)Math.ceil(maxpt.getZ()) + padamount);

        return templateImg;
    }
	
	private Boolean test_surfaceDiff (String path){
		
		SurfaceCompareSingleton scs = SurfaceCompareSingleton.getInstance();
		Double surThreshold = scs.get_threshold();
		
		fileNameDiff = scs.get_FileName();
		
		String ad_surf = path + "/output/" + fileNameDiff;
		String ed_surf = path + "/temp/" + fileNameDiff;
		
		File ed_dir = null, ad_dir = null;

		try {
			ed_dir = new File(path + "/surTestconvert_ed");
			ad_dir = new File(path + "/surTestconvert_ad");
			ed_dir.mkdir();
			ad_dir.mkdir();
		} catch (Exception e) {
			System.err.println("no file");
		}
		
		
		SurfaceReaderWriter surReader = new SurfaceReaderWriter();
		EmbeddedSurface sur1 = surReader.read(new File(ad_surf));
		EmbeddedSurface sur2 = surReader.read(new File(ed_surf));

		
		ImageData sur1_temp = getTemplateFromSurface(sur1, 10);
		//ImageData sur2_temp = getTemplateFromSurface(sur2, 10);
		
		ImageDataReaderWriter vo = new ImageDataReaderWriter();
		
		int surFile = fileNameDiff.lastIndexOf(".");
		String volumeName= fileNameDiff.substring(0, surFile);
		String tempName = volumeName + "_temp.nii";

		File keep = new File (path + "/surTestconvert_ad/" + tempName);
		//File keep1 = new File ("/share/hudson/tests/rand/surTestconvert_ed/wm_temp.nii");
		vo.getInstance().write(sur1_temp, keep);
		//vo.getInstance().write(sur2_temp, keep1);
	

		String[] p_ad = {"edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter", "-inTemplate", path + "/surTestconvert_ad/" + tempName, "-inSurface", ad_surf, "-xDir", path + "/surTestconvert_ad"};
		
		edu.jhu.ece.iacl.jist.cli.run.main(p_ad) ;
		
		String[] p_ed = {"edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter", "-inTemplate", path + "/surTestconvert_ad/" + tempName, "-inSurface", ed_surf, "-xDir", path + "/surTestconvert_ed"};
		edu.jhu.ece.iacl.jist.cli.run.main(p_ed) ;
		
		///////////////////////////////
		File fexp = null;
		File fact = null;
//		int surFile = fileNameDiff.lastIndexOf(".");
//		String volumeName= fileNameDiff.substring(0, surFile);
		fexp = new File(path + "/" + "surTestconvert_ad" + "/" + volumeName + "_volmask" + ".xml");
		fact = new File(path + "/" + "surTestconvert_ed" + "/" + volumeName + "_volmask" + ".xml");
		
		ImageData act_data = ImageDataReaderWriter.getInstance().read(fact);
		
		ImageData exp_data = ImageDataReaderWriter.getInstance().read(fexp);
		
		try{
			System.out.println("Actual_data dimensions:");
			System.out.println("\tRows: " + act_data.getRows());
			System.out.println("\tCols: " + act_data.getCols());
			System.out.println("\tSlices: " + act_data.getSlices());
			
			System.out.println("Expected_data dimensions:");
			System.out.println("\tRows: " + exp_data.getRows());
			System.out.println("\tCols: " + exp_data.getCols());
			System.out.println("\tSlices: " + exp_data.getSlices());
		} catch (Error err){
			System.out.println("Error message: " + err.getMessage());
		} catch (Exception err){
			System.out.println("Exception message: " + err.getMessage());
		}
		
		if (act_data.getRows() != exp_data.getRows() || act_data.getCols() != exp_data.getCols() || act_data.getSlices() != exp_data.getSlices())
		{
			System.err.println("Error - dimension don not match");
			assert(false);
		}
		
		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test("difference");
		
		tob.set_tv(surThreshold);

		Boolean test_result = tob.run(act_data, exp_data);

		return test_result;
		
	}
	
private Boolean test_surface (String path){
		
		SurfaceCompareSingleton scs = SurfaceCompareSingleton.getInstance();
		Double surThreshold = scs.get_threshold();
		fileName = scs.get_FileName();
		String ad_surf = path + "/output/" + fileName;
		String ed_surf = path + "/temp/" + fileName;
		
		File ed_dir = null, ad_dir = null;

		try {
			ed_dir = new File(path + "/surTestconvert_ed");
			ad_dir = new File(path + "/surTestconvert_ad");
			ed_dir.mkdir();
			ad_dir.mkdir();
		} catch (Exception e) {
			System.err.println("no file");
		}
		
		SurfaceReaderWriter surReader = new SurfaceReaderWriter();
		EmbeddedSurface sur1 = surReader.read(new File(ad_surf));
		EmbeddedSurface sur2 = surReader.read(new File(ed_surf));

		
		ImageData sur1_temp = getTemplateFromSurface(sur1, 10);
		//ImageData sur2_temp = getTemplateFromSurface(sur2, 10);
		
		ImageDataReaderWriter vo = new ImageDataReaderWriter();
		
		int surFile = fileName.lastIndexOf(".");
		String volumeName= fileName.substring(0, surFile);
		String tempName = volumeName + "_temp.nii";

		File keep = new File (path + "/surTestconvert_ad/" + tempName);
		//File keep1 = new File ("/share/hudson/tests/rand/surTestconvert_ed/wm_temp.nii");
		vo.getInstance().write(sur1_temp, keep);
		//vo.getInstance().write(sur2_temp, keep1);
	

		String[] p_ad = {"edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter", "-inTemplate", path +"/surTestconvert_ad/" + tempName, "-inSurface", ad_surf, "-xDir", path + "/surTestconvert_ad"};
		//int i = -1;
		edu.jhu.ece.iacl.jist.cli.run.main(p_ad) ;
		
		String[] p_ed = {"edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter", "-inTemplate", path + "/surTestconvert_ad/" + tempName, "-inSurface", ed_surf, "-xDir", path + "/surTestconvert_ed"};
		//int j = -1;
		edu.jhu.ece.iacl.jist.cli.run.main(p_ed) ;
		
		//compare the volume
		File fexp = null;
		File fact = null;
//		int surFile = fileName.lastIndexOf(".");
//		String volumeName= fileName.substring(0, surFile);
		fexp = new File(path + "/" + "surTestconvert_ad" + "/" + volumeName + "_volmask" + ".xml");
		fact = new File(path + "/" + "surTestconvert_ed" + "/" + volumeName + "_volmask" + ".xml");
		
		ImageData act_data = ImageDataReaderWriter.getInstance().read(fact);
		
		ImageData exp_data = ImageDataReaderWriter.getInstance().read(fexp);
		
		try{
			System.out.println("Actual_data dimensions:");
			System.out.println("\tRows: " + act_data.getRows());
			System.out.println("\tCols: " + act_data.getCols());
			System.out.println("\tSlices: " + act_data.getSlices());
			
			System.out.println("Expected_data dimensions:");
			System.out.println("\tRows: " + exp_data.getRows());
			System.out.println("\tCols: " + exp_data.getCols());
			System.out.println("\tSlices: " + exp_data.getSlices());
		} catch (Error err){
			System.out.println("Error message: " + err.getMessage());
		} catch (Exception err){
			System.out.println("Exception message: " + err.getMessage());
		}
		
		if (act_data.getRows() != exp_data.getRows() || act_data.getCols() != exp_data.getCols() || act_data.getSlices() != exp_data.getSlices())
		{
			System.err.println("Error - dimension don not match");
			assert(false);
		}
		
		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test("strict");
		
		tob.set_tv(surThreshold);

		Boolean test_result = tob.run(act_data, exp_data);

		return test_result;
		
	}
	
	@Test
	public void testSurfaceDiff () {
		
		runTest getpath = new runTest();
		String path1 = getpath.getPath();
		Boolean res = test_surfaceDiff(path1);
		assert(res);
		System.out.println("SurfaceCompare: test the maximum difference for voxels successfully!");

	}
	
	@Test
	public void testSurface () {
		
		runTest getpath = new runTest();
		String path1 = getpath.getPath();
		Boolean res = test_surface(path1);
		assert(res);
		System.out.println("SurfaceCompare: test the number of different voxels successfully!");

	}

}