package test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.framework.TestFailure;

//import org.junit.Test;


import static junit.framework.Assert.*;
/**
 * parse the TestCase.properties in the zip file to run the run.java from parameters in the file
 * @author lb
 *
 */

public class runTest extends TestSuite {
	

	static String path = System.getProperty("path") ;// this path can be run from the cli (-Dpath=path)
	//static String path = "/share/hudson/tests/exp-0000-DD";
	//static String path = "C:\\Users\\lb\\test1";
	String pathCase = path + File.separator + "TestCase.properties";
	public Properties read(String pathCase) throws Exception{
		Properties properties = new Properties() ;
		properties.load(new FileInputStream(pathCase)) ;																										
		return properties ;
	}
	
	public String getPath(){
		String test = path;
		return test;
	}
	
//	public String[] getParameters() throws Exception{
//		String line;
//		String[] params=null;
//		try {
//			File file = new File (pathCase);
//			BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
//			List<String> list = new ArrayList<String>() ;
//			
//			while ((line = in.readLine()) != null){
//				if (line.startsWith("edu") || line.startsWith("-")){
//
//				line = line.trim();
//				if(line.contains(" ") == false){
//					list.add(line) ;
//				}else{
//					int index  = line.indexOf(" ") ;
//					list.add(line.substring(0, index) ) ;
//					list.add(line.substring(index )) ;
//					
//				}
//				//System.out.println(line);
//			}
////				else 
////				{
////					String testcase = line.trim();
////					System.out.println(testcase);
////				}
//		}
//			int size = list.size() ;
//			params = new String[size] ;
//			Boolean flag = false;
//			for(int i=0; i < size; i++){
//				String tmp = list.get(i).trim();
//				//if (tmp.startsWith("-")||tmp.startsWith("edu")){
//				if (flag)
//				{
//					tmp = new File(path, tmp).toString();
//					flag = false;
//				}
//				//params[i] = list.get(i).trim() ;
//				else if (tmp.startsWith("-inInput")||tmp.startsWith("-xDir"))
//					{flag = true;}
//				params[i] = tmp ;
//		//	}
//			}
//			
//			//params = (String[]) list.toArray() ;
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return params;
//	}
	

	/**
	 * Casting from properties to an array of strings. With the understanding that testReadPropertyFile has passed
	 */


		
	public static Test suite () {
		
		TestSuite suite = new TestSuite();
		
		FileParse fp = new FileParse();
		try {
			fp.Parse(path);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
//		String classpath = null, extdirs, mpvdir, userdir, sharedir, testdir, homedir, jredir, datadir;
//		
//		Properties props = System.getProperties();
//		
//		classpath 		= props.getProperty("java.class.path", null) + ";" + 
//				  props.getProperty("myclasspath", null);
//        extdirs 		= props.getProperty("java.ext.dirs", null);
//        homedir			= props.getProperty("user.home", null);
//        userdir 		= props.getProperty("user.dir", null) + "/src/test"; 
//        mpvdir 			= "/home/likewise-open/VANDERBILT/lib12/mipav";
//        datadir = userdir + "/datadir";
//		
////        	System.out.println(classpath);
////        	System.out.println(extdirs);
////        	System.out.println(userdir);
////        	System.out.println(homedir);
////        	System.out.println(mpvdir);
//        
//        jredir = mpvdir + "/jre/bin/java";
//        String directory = path + "/surTest";
//		
		
		FilePara fileParam = fp.getFileParam();
		
		String[] p = null;
		p = fileParam.getParams();
//		for (int i = 0; i < p.length; i++){
//			System.out.println(p[i]);
//		}
		
		edu.jhu.ece.iacl.jist.cli.run.main(p);
		VolumeCompareSigleton test = VolumeCompareSigleton.getInstance();

		for(OutPara item : fileParam.getOutParaList())
		{
			TestcaseStrings tcs = new TestcaseStrings();
			int i = -1;
			if (item.getType().equals("FileExistence"))
			{

				    suite.addTest(new FileExistence("testFiles"));
				   
			}
			else if (item.getType().equals("Volume (Set the maximum number of different voxels)")){
				
				VolumeCompareSigleton voex = VolumeCompareSigleton.getInstance();
				voex.set_fileName(item.getPath());
				voex.set_threshold(item.getThreshold());
				suite.addTest(new VolumeTest("testVolume"));
			}
			
			else if (item.getType().equals("Volume (Set the maximum difference for voxels)")){
				
				VolumeCompareSigleton voexDiff = VolumeCompareSigleton.getInstance();
				voexDiff.set_fileName(item.getPath());
				voexDiff.set_threshold(item.getThreshold());
				suite.addTest(new VolumeTest("testVolumeDiff"));

			}
				
			
			else if (item.getType().equals("Surface (Set the maximum number of different voxels)")){
				SurfaceCompareSingleton sur = SurfaceCompareSingleton.getInstance();
				sur.set_fileName(item.getPath());
				sur.set_threshold(item.getThreshold());
				suite.addTest(new SurfaceCompareTest("testSurface"));
				
			}
			
			else if (item.getType().equals("Surface (Set the maximum difference for voxels)")){
				SurfaceCompareSingleton sur = SurfaceCompareSingleton.getInstance();
				sur.set_fileName(item.getPath());
				sur.set_threshold(item.getThreshold());
				suite.addTest(new SurfaceCompareTest("testSurfaceDiff"));
				
			}
			
			else if (item.getType().equals("None")){
				VolumeCompareSigleton noneTest = VolumeCompareSigleton.getInstance();
				noneTest.set_fileName(item.getPath());
			suite.addTest(new VolumeTest("testnone"));
			}
		}
	
		
		
		return suite;
	}
	
}
