package edu.jhu.ece.iacl.jist.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.JOptionPane;
import javax.vecmath.Point3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import edu.jhu.ece.iacl.jist.utility.JistLogger;






// TODO: Auto-generated Javadoc
/**
 * The Class VertexFloatDxReaderWriter.
 */
public class VertexFloatXmlReaderWriter extends FileReaderWriter<Point3f[]>{
	 protected FileExtensionFilter extensionFilter;
	public void setExtensionFilter(FileExtensionFilter extensionFilter) {
		this.extensionFilter = extensionFilter;
	}
	public FileExtensionFilter getExtensionFilter() {
		return extensionFilter;
	}
	/** The Constant readerWriter. */
	protected static final VertexFloatDxReaderWriter readerWriter=new VertexFloatDxReaderWriter();
	
	/**
	 * Gets the single instance of VertexFloatDxReaderWriter.
	 * 
	 * @return single instance of VertexFloatDxReaderWriter
	 */
	public static VertexFloatDxReaderWriter getInstance(){
		return readerWriter;
	}
	
	/**
	 * Instantiates a new vertex float dx reader writer.
	 */
	public VertexFloatXmlReaderWriter(){
		super(new FileExtensionFilter(new String[]{"xml"}));
	}
	
	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.io.FileReaderWriter#readObject(java.io.File)
	 */
	protected Point3f[] readObject(File f) {
		
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		Point3f[] points=null;
		try{
			DocumentBuilder db=dbf.newDocumentBuilder();
			Document dom= db.parse(f.getAbsolutePath());
			Element docEle = dom.getDocumentElement();
			if(docEle.getTagName().compareTo("VOI") == 0) {
				if (docEle.getElementsByTagName("Curve-type")==null || docEle.getElementsByTagName("Curve-type").getLength() ==0)
					throw new Exception("Not a valid VOI file (Curve Type Tag Missing)");
				if (docEle.getElementsByTagName("Color")==null || docEle.getElementsByTagName("Color").getLength()==0)
					throw new Exception("Not a valid VOI file (Color Tag missing)");
				NodeList pt = docEle.getElementsByTagName("Pt");
				points = new Point3f[pt.getLength()];
				for (int i=0; i<pt.getLength(); i++){
					String[] coords = pt.item(i).getFirstChild().getNodeValue().split(",");
					try {
						Point3f p=new Point3f();
						p.x=Float.parseFloat(coords[0]);
						p.y=Float.parseFloat(coords[1]);
						p.z=Float.parseFloat(coords[2]);
						points[i]=p;
						JistLogger.logOutput(JistLogger.INFO, "jist.io"+"\t"+i+")"+p);
					} catch(NumberFormatException e){
						JistLogger.logError(JistLogger.SEVERE, getClass().getCanonicalName()+"CANNOT FORMAT VERTS");
						JistLogger.logError(JistLogger.SEVERE, getClass().getCanonicalName()+"CANNOT FORMAT VERTS");
						return null;
					}
				}
			}else
				throw new Exception("Not a valid VOI file (VOI Tag missing)");
		}
		catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Unable to open file. Reason : " +   e.getMessage());
		}
		
		
		
		/*BufferedReader in;
		StringBuffer buff = new StringBuffer();
		try {
			// Create input stream from file
			in = new BufferedReader(new InputStreamReader(
					new FileInputStream(f)));
			
			String str;
			// Read file as string
			while ((str = in.readLine()) != null) {
				buff.append(str+"\n");
			}
		} catch (Exception e) {
			System.err.println(getClass().getCanonicalName()+"Error occured while reading parameter file:\n"+e.getMessage());
			e.printStackTrace();
			return null;
		}
		
		Pattern header=Pattern.compile("<Thickness>1</Thickness>");
		Matcher m=header.matcher(buff);
		int vertexCount=0;
		Point3f[] points;
		if(m.find()){
			String trimmedPoints = buff.substring(m.end(),buff.length()).replace("<Contour>\n","").replace("</Contour>\n", "").replace("</Pt>", ",").replace("</VOI>\n","").replace("\t", "");
			vertexCount = (trimmedPoints.split("<Pt>")).length-1;
			points=new Point3f[vertexCount];
			String[] strs=trimmedPoints.replace("<Pt>", "").split(",",vertexCount*3+2);
		
			for(int i=0;i<vertexCount;i++){
				try {
					Point3f p=new Point3f();
					p.x=Float.parseFloat(strs[3*i]);
					p.y=Float.parseFloat(strs[3*i+1]);
					p.z=Float.parseFloat(strs[3*i+2]);
					points[i]=p;
				} catch(NumberFormatException e){
					return null;
				}
			}
		} else {
			return null;
		}*/
		return points;
	}
	
	protected ArrayList<Point3f> readObjectToList(File f) {
		Point3f[] points_array = readObject(f);
		ArrayList<Point3f> points_list = new ArrayList<Point3f>(points_array.length);
		for (int i=0; i<points_array.length; i++)
			points_list.add(points_array[i]);
		return points_list;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.io.FileReaderWriter#writeObject(java.lang.Object, java.io.File)
	 */
	@Override
	protected File writeObject(Point3f[] results, File f) {
			try {
				BufferedWriter stream=new BufferedWriter(new FileWriter(f));
				stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" +
									   "<!-- MIPAV VOI file -->\r\n"+
									    "<VOI xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n"+
									    "<Unique-ID>0</Unique-ID>\r\n"+
									    "<Curve-type>3</Curve-type>\r\n"+
									    "<Color>255,0,0,255</Color>\r\n"+
									    "<Thickness>1</Thickness>)\r\n");
				for (int i = 0; i < results.length; i++) {
					Point3f p = results[i];
					stream.write("<Contour>\r\n"+
								  "\t<Pt>"+String.format("%f,%f,%f", p.x, p.y, p.z)+"</Pt>\r\n"
								  +"</Contour>\r\n");
				}
				stream.write("</VOI>\r\n");
				stream.close();
				return f;
			}	
			catch (IOException e) {
				System.err.println(getClass().getCanonicalName()+e.getMessage());
			}
			return null;
			
	}
	protected File writeObjectfromList(ArrayList<Point3f> results, File f) {
		return writeObject((Point3f[])results.toArray(), f);
	}

}
