/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.graph;

import java.awt.Color;

import javax.swing.ImageIcon;

import org.jgraph.graph.GraphConstants;

import edu.jhu.ece.iacl.jist.pipeline.PipeModule;
import edu.jhu.ece.iacl.jist.pipeline.PipeNote;
import edu.jhu.ece.iacl.jist.pipeline.gui.resources.PlaceHolder;
import edu.jhu.ece.iacl.jist.pipeline.tree.DraggableNode;

/**
 * Factory for creating note modules.
 * 
 * @author Andrew Asman
 */
public class PipeNoteFactory extends PipeModuleFactory {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Source graph cell.
	 * 
	 * @author Andrew Asman
	 */
	public static class NoteCell extends PipeModuleCell {
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		/**
		 * Instantiates a new note cell.
		 * 
		 * @param name
		 *            the name
		 * @param pipe
		 *            the pipe
		 */
		public NoteCell(String name, PipeModule pipe) {
			super(name, pipe);
			PipeCellViewFactory.setViewClass(this.getAttributes(), PipeNoteView.class.getCanonicalName());
			GraphConstants.setGradientColor(this.getAttributes(), Color.yellow.brighter());
		}

		/* (non-Javadoc)
		 * @see org.jgraph.graph.DefaultGraphCell#clone()
		 */
		public PipeModuleCell clone() {
			PipeNoteFactory factory = 
				new PipeNoteFactory(pipe.getLabel(), "", pipe.getClass());
			NoteCell cell = factory.createGraphCell();
			PipeModule pipeClone=cell.getPipeModule();
			((PipeNote)pipe).getInputParams().getInputView().update();
			((PipeNote)pipeClone).getInputParams().importParameter(pipe.getInputParams());
			((PipeNote)pipeClone).getInputParams().getInputView().update();
			return cell;
		}
	}

	/**
	 * Source tree node.
	 * 
	 * @author Blake Lucas (bclucas@jhu.edu)
	 */
	public static class NoteNode extends DraggableNode {
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		/**
		 * Instantiates a new note node.
		 * 
		 * @param factory
		 *            the factory
		 */
		public NoteNode(PipeModuleFactory factory) {
			super(factory);
			this.icon=new ImageIcon(PlaceHolder.class.getResource("post-it-note-small.jpg"));

		}
	}

	/**
	 * Instantiates a new pipe note factory.
	 * 
	 * @param name
	 *            the name
	 * @param c
	 *            the c
	 */
	@SuppressWarnings("rawtypes")
	public PipeNoteFactory(String name, String description, Class c) {
		super(name, description, c);
	}

	/**
	 * Create graph cell for note.
	 * 
	 * @return the pipe module cell
	 */
	public NoteCell createGraphCell() {
		PipeNote p = createPipe();
		return p.createModuleCell();
	}

	/**
	 * Crete pipe module for note.
	 * 
	 * @return the pipe module
	 */
	public PipeNote createPipe() {
		try {
			PipeNote note = (PipeNote) c.newInstance();
			return note;
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Create tree node for note.
	 * 
	 * @return the draggable node
	 */
	public DraggableNode createTreeNode() {
		return new NoteNode(this);
	}
}
