/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.graph;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

import edu.jhu.ece.iacl.jist.pipeline.gui.resources.PlaceHolder;

/**
 * Cell view renderer for sources.
 * 
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class PipeNoteView extends VertexView {
	
	private static final long serialVersionUID = 1L;

	/**
	 * The Class ActivityRenderer.
	 */
	public static class ActivityRenderer extends VertexRenderer {
		
		private static final long serialVersionUID = 1L;

		/* (non-Javadoc)
		 * @see org.jgraph.graph.VertexRenderer#paint(java.awt.Graphics)
		 */
		public void paint(Graphics g) {
			int b = borderWidth;
			Graphics2D g2 = (Graphics2D) g;
			
			// turn on anti-aliasing and bilinear interpolation
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
								RenderingHints.VALUE_ANTIALIAS_ON);
			g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
								RenderingHints.VALUE_INTERPOLATION_BILINEAR);
			Dimension d = getSize();
			boolean tmp = selected;
			g.setColor(this.getBackground());
			
			// the size settings for this note
			int x = b / 2;
			int y = b / 2;
			int width = d.width - (int) (b * 1.5);
			int height = d.height - (int) (b * 1.5);
			
			if (super.isOpaque()) {
				try {
					BufferedImage image = ImageIO.read(PlaceHolder.class.getResource("post-it-note.jpg"));
					double ratio = (double)image.getWidth() / (double)image.getHeight();
					int w2 = width, h2 = height, x2 = x, y2 = y;
					if (width > height) {
						w2 = (int)(ratio * height);
						x2 = (width - w2) / 2;
					} else {
						h2 = (int)(width / ratio);
						y2 = (height - h2) / 2;
					}
					
					g.drawImage(image, x2, y2, w2, h2, null);
				} catch (IOException e) {
					g.setColor(super.getBackground());
					if ((gradientColor != null) && !preview) {
						setOpaque(false);
						g2.setPaint(new GradientPaint(0, 0, getBackground(), getWidth(), getHeight(), gradientColor, true));
					}
					g.fillRect(x, y, width, height);
				}
			}
			try {
				setBorder(null);
				setOpaque(false);
				selected = false;
				super.paint(g);
			} finally {
				selected = tmp;
			}
			//if (bordercolor != null) {
			//	g.setColor(bordercolor);
			//	g2.setStroke(new BasicStroke(b));
			//	g.drawRect(x, y, width, height);
			//}
			if (selected) {
				g2.setStroke(GraphConstants.SELECTION_STROKE);
				g.setColor(highlightColor);
				g.drawRect(x, y, width, height);
			}
		}
	}

	/** The renderer. */
	public static transient ActivityRenderer renderer = new ActivityRenderer();

	/**
	 * Instantiates a new pipe source view.
	 */
	public PipeNoteView() {
		super();
	}

	/**
	 * Instantiates a new pipe source view.
	 * 
	 * @param cell
	 *            the cell
	 */
	public PipeNoteView(Object cell) {
		super(cell);
	}

	/* (non-Javadoc)
	 * @see org.jgraph.graph.VertexView#getRenderer()
	 */
	public CellViewRenderer getRenderer() {
		return renderer;
	}
}
