package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ScrollPaneConstants;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.jcraft.jsch.JSchException;

import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout.RunParameters;
import edu.jhu.ece.iacl.jist.pipeline.gui.resources.PlaceHolder;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.jistcloud.JistAwsEC2;
import edu.vanderbilt.masi.jistcloud.JistAwsInitConfig;
import edu.vanderbilt.masi.jistcloud.JistAwsReInitConfig;
import edu.vanderbilt.masi.jistcloud.JistAwsS3;
import edu.vanderbilt.masi.jistcloud.JistAwsUtil;
import edu.vanderbilt.masi.jistcloud.MyUtils;

/**
 * AWS EC2 control panel. It can initialize multiple instances Stop instances
 * Re-start instances Terminate instances
 * 
 * @author Shunxing Bao 2015 summer
 */
public class AwsEC2DashboardPanel extends JPanel implements ActionListener {
	/**
     * 
     */
	private static final long serialVersionUID = 1L;
	// DEFAULT REGION VALUE
	private String REGION_OREGON = "US West (Oregon)";
	private String REGION_NCALIFORNIA = "US West (N. California)";
	private String REGION_NVIRGINIA = "US East (N. Virginia)";
	private String REGION_IRELAND = "EU (Ireland)";
	private String REGION_FRANKFURT = "EU (Frankfurt)";
	private String REGION_SINGAPORE = "Asia Pacific (Singapore)";
	private String REGION_SYDNEY = "Asia Pacific (Sydney)";
	private String REGION_TOKYO = "Asia Pacific (Tokyo)";
	private String REGION_SAOPAULO = "South America (Sao Paulo)";

	// DEFAULT EC2 ENDPOINT VALUE
	private String ENDPOINT_OREGON = "ec2.us-west-2.amazonaws.com";
	private String ENDPOINT_NCALIFORNIA = "ec2.us-west-1.amazonaws.com";
	private String ENDPOINT_NVIRGINIA = "ec2.us-east-1.amazonaws.com";
	private String ENDPOINT_IRELAND = "ec2.eu-west-1.amazonaws.com";
	private String ENDPOINT_FRANKFURT = "ec2.eu-central-1.amazonaws.com";
	private String ENDPOINT_SINGAPORE = "ec2.ap-southeast-1.amazonaws.com";
	private String ENDPOINT_SYDNEY = "ec2.ap-southeast-2.amazonaws.com";
	private String ENDPOINT_TOKYO = "ec2.ap-northeast-1.amazonaws.com";
	private String ENDPOINT_SAOPAULO = "ec2.sa-east-1.amazonaws.com";

	// DEFAULT S3 ENDPOINT VALUE
	private String ENDPOINT_OREGON_S3 = "s3-us-west-2.amazonaws.com";
	private String ENDPOINT_NCALIFORNIA_S3 = "s3-us-west-1.amazonaws.com";
	private String ENDPOINT_NVIRGINIA_S3 = "s3.amazonaws.com ";
	private String ENDPOINT_IRELAND_S3 = "s3-eu-west-1.amazonaws.com";
	private String ENDPOINT_FRANKFURT_S3 = "s3.eu-central-1.amazonaws.com";
	private String ENDPOINT_SINGAPORE_S3 = "s3-ap-southeast-1.amazonaws.com";
	private String ENDPOINT_SYDNEY_S3 = "s3-ap-southeast-2.amazonaws.com";
	private String ENDPOINT_TOKYO_S3 = "s3-ap-northeast-1.amazonaws.com";
	private String ENDPOINT_SAOPAULO_S3 = "s3-sa-east-1.amazonaws.com";

	// DEFAULT JIST AWS PREFERENCE FILE PATH
	private String JIST_AWS_PREFERENCES = "/JistAwsEc2"
			+ "/JISTAWSEC2.preferences";
	private String EC2_USER = "ec2-user";
	private String UBUNTU_USER = "ubuntu";

	/** The layout. */
	private PipeLayout layout;
	private JistAwsEC2 jistAwsEC2;
	private JistAwsS3 jistAwsS3;
	private RunParameters params;
	private String str_keyPairFolder;// .pem
	// private Set<String> selectedIdAndStatus = new HashSet<String>();
	private List<String> selectedInstanceId = new ArrayList<String>();
	private DefaultListModel<AwsEC2CheckListItem> model = new DefaultListModel<AwsEC2CheckListItem>();

	/**
	 * GUI SECTION
	 */
	JButton awsEc2StopButton, awsEc2StartButton, awsEc2TerminateButton,
			awsEc2RefreshButton, awsEc2StopRefreshButton;
	JButton awsEc2InitButton, awsEc2StartAllButton, awsEc2StopAllButton,
			awsEc2TerminateAllButton;
	// CREDENTIAL
	private JTextField tf_accessKeyID;
	private JPasswordField pwf_secretAccessKey;
	// REGION
	private JComboBox<String> cb_Region;
	// CHECK CREDENTIAL
	private JButton b_checkCredentialValid;
	// S3 BUCKETNAME
	private JRadioButton[] rb_ifCreateS3Bucket;
	private JComboBox<String> cb_S3Bucket;
	private JButton b_AllS3Bucket;
	private JTextField tf_s3NewBucket;
	private JButton b_createS3Bucket;
	// KEY PAIR SECTION
	private JRadioButton[] rb_ifCreateKeyPair;
	private JTextField tf_oldKeyPairPath;
	private JButton b_selectKeyPair;
	private JTextField tf_newKeyPairName;
	private JButton b_createKeyPair;
	// SECURITY GROUP SECTION
	private JRadioButton[] rb_ifCreateSecurityGroup;
	private JComboBox<String> cb_SecurityGroup;
	private JButton b_AllSecurityGroup;
	private JTextField tf_newSecurityGroup;
	private JTextField tf_SecurityGDescription;
	private JButton b_createSecurityGroup;
	// AMAZON INSTANCE OPERATION SECTION
	private JComboBox<String> cb_AMI;
	private JComboBox<String> cb_AMIType;
	private JSpinner sp_numberOfInstances;
	// AMAZON INSTANCE STATUS SECTION
	private JTextArea awsEC2Status;
	private JList<AwsEC2CheckListItem> l_instanceStatus;

	private JButton b_install;
	public static Integer totalNumOfMachine = 0;
	public static double numOfCompleteInstall = 0.0;

	/**
	 * Constructor.
	 * 
	 * @param layout
	 *            layout
	 * @throws BadLocationException
	 */
	public AwsEC2DashboardPanel(PipeLayout layout) throws BadLocationException {
		super();
		createPane();
		this.layout = layout;

		init(layout);
	}

	/**
	 * Show dialog.
	 * 
	 * @param comp
	 *            the comp
	 * @param layout
	 *            the layout
	 * @return true, if successful
	 * @throws BadLocationException
	 */

	public static boolean showDialog(Component comp, PipeLayout layout)
			throws BadLocationException {
		System.out.println(layout.getTitle());
		System.out.println(layout.getFileLocation().getAbsolutePath());

		AwsEC2DashboardPanel panel = new AwsEC2DashboardPanel(layout);

		// while (true) {
		// Object[] options = { "Done", "Cancel" };
		Object[] options = { "Done" };
		int n = JOptionPane.showOptionDialog(comp, panel, "Cloud Dashboard ["
				+ layout.getTitle() + "]", JOptionPane.OK_CANCEL_OPTION,
				JOptionPane.PLAIN_MESSAGE, null, options, options[0]);
		System.out.println("");
		// save configs
		if (n == 0) {
			JistLogger.logOutput(JistLogger.INFO,
					"> To save experiment-specific configs...");
			panel.saveConfigs();
			
		} else {
			return true;
		}

		return true;
	}

	// Save configs for experimentserverURL
	/**
	 * Show current configuration.
	 * 
	 */
	private void saveConfigs() {
		awsEC2AutoRefresh.stop();
		if (layout == null) {
			return;
		}

		Properties prop = new Properties();
		try {
			prop.setProperty("accessKeyId", tf_accessKeyID.getText());
			prop.setProperty("secretAccessKey", pwf_secretAccessKey.getText());
			prop.setProperty("region", jistAwsEC2.getRegion());

			// System.out.println(jistAwsEC2.getCurrentInstances().size());
			// if (jistAwsEC2.getCurrentInstances().size() > 0) {
			if (!awsEc2InitButton.isEnabled() && !this.b_install.isEnabled()
					&& this.awsEc2TerminateAllButton.isEnabled()) {
				prop.setProperty("regionS3", jistAwsS3.getS3Region());
				prop.setProperty("bucket", jistAwsS3.getS3Bucket());
				if (rb_ifCreateS3Bucket[1].isSelected()) {
					prop.setProperty("ifCreateBucket", "no");
				}
				if (rb_ifCreateS3Bucket[0].isSelected()) {
					prop.setProperty("ifCreateBucket", "yes");
				}

				prop.setProperty("keyPairPath",
						jistAwsEC2.getKeyPairAbsolutePath());
				prop.setProperty("keyPairName", jistAwsEC2.getKeyPairName());
				if (rb_ifCreateKeyPair[1].isSelected()) {
					prop.setProperty("ifCreateKeyPair", "no");
				}
				if (rb_ifCreateKeyPair[0].isSelected()) {
					prop.setProperty("ifCreateKeyPair", "yes");
				}

				if (rb_ifCreateSecurityGroup[1].isSelected()) {
					prop.setProperty("ifCreateSG", "no");
					prop.setProperty("securityGroup",
							jistAwsEC2.getSecurityGroupName());
				}
				if (rb_ifCreateSecurityGroup[0].isSelected()) {
					prop.setProperty("ifCreateSG", "yes");
					prop.setProperty("securityGroup",
							jistAwsEC2.getSecurityGroupName());
					prop.setProperty("securityGroupDescription",
							tf_SecurityGDescription.getText());
				}
				prop.setProperty("AMI", jistAwsEC2.getImageId());
				prop.setProperty("AMIType", jistAwsEC2.getInstanceType());
				prop.setProperty("MachineNumer",
						String.valueOf(jistAwsEC2.getMaxInstanceNum()));

				String tmpAllCurrentInstanceId = "";

				for (String curInstanceId : jistAwsEC2.getCurrentInstancesId()) {
					tmpAllCurrentInstanceId = tmpAllCurrentInstanceId
							+ curInstanceId + ":";
				}

				prop.setProperty("AllCurrentInstanceId",
						tmpAllCurrentInstanceId);
				System.out.println(tmpAllCurrentInstanceId);

				String tmpAllRunningCurrentInstanceId = "";
				jistAwsEC2.getRunningInstancesId();
				for (String curRunningInstanceId : jistAwsEC2
						.getCurRunningInstancesId()) {
					tmpAllRunningCurrentInstanceId = tmpAllRunningCurrentInstanceId
							+ curRunningInstanceId + ":";
				}

				prop.setProperty("AllCurrentRunningInstanceId",
						tmpAllRunningCurrentInstanceId);
				// System.out.println(tmpAllRunningCurrentInstanceId+"woca");

				// installMipavJist();

			} else {
				prop.remove("bucket");
				prop.remove("ifCreateBucket");
				prop.remove("keyPairPath");
				prop.remove("keyPairName");
				prop.remove("ifCreateKeyPair");
				prop.remove("ifCreateSG");
				prop.remove("securityGroup");
				prop.remove("securityGroupDescription");
				prop.remove("AMI");
				prop.remove("AMIType");
				prop.remove("MachineNumer");
				prop.remove("AllCurrentInstanceId");
				prop.remove("AllCurrentRunningInstanceId");

			}

			FileOutputStream fos = new FileOutputStream(
					MyUtils.getPropertiesPath(layout));
			prop.store(fos, null);

			OutputStream output = new FileOutputStream(System.getProperties()
					.getProperty("user.home") + JIST_AWS_PREFERENCES);
			prop.store(output, null);
			awsEC2AutoRefresh.stop();// stop refresh cloud panel in the
										// background
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	private boolean installMipavJist() throws Exception {
		Set<Instance> tmpPPP = new HashSet<Instance>();
		// get All instance
		tmpPPP = jistAwsEC2.getCurrentInstances();
		// TODO Auto-generated method stub
		for (Instance a : tmpPPP) {
			if (a.getState().getName().equals("running")) {
				if (!jistAwsEC2.getInstanceStatus(a.getInstanceId()).contains(
						"ok")) {
					JOptionPane
							.showMessageDialog(null,
									"Please wait, there is a running instance's status is not \"ok\".");
					awsEC2AutoRefresh.start();
					return false;

				}
				// JistAwsInitConfig jistAwsInitConfig = new JistAwsInitConfig(
				// jistAwsEC2, a, jistAwsEC2.getKeyPairAbsolutePath(),
				// EC2_USER);
				// jistAwsInitConfig.start();
			} else {
				return false;
			}
		}

		for (Instance a : tmpPPP) {

			JistAwsInitConfig jistAwsInitConfig = new JistAwsInitConfig(
					jistAwsEC2, a, jistAwsEC2.getKeyPairAbsolutePath(),
					EC2_USER);
			jistAwsInitConfig.start();

		}
		return true;
	}
	
	private boolean reInstallMipavJist() throws Exception {
		Set<Instance> tmpPPP = new HashSet<Instance>();
		// get All instance
		tmpPPP = jistAwsEC2.getCurrentInstances();
		// TODO Auto-generated method stub
		for (Instance a : tmpPPP) {
			if (a.getState().getName().equals("running")) {
				if (!jistAwsEC2.getInstanceStatus(a.getInstanceId()).contains(
						"ok")) {
					JOptionPane
							.showMessageDialog(null,
									"Please wait, there is a running instance's status is not \"ok\".");
					awsEC2AutoRefresh.start();
					return false;

				}
				// JistAwsInitConfig jistAwsInitConfig = new JistAwsInitConfig(
				// jistAwsEC2, a, jistAwsEC2.getKeyPairAbsolutePath(),
				// EC2_USER);
				// jistAwsInitConfig.start();
			} else {
				return false;
			}
		}

		for (Instance a : tmpPPP) {

			JistAwsReInitConfig jistAwsReInitConfig = new JistAwsReInitConfig(
					jistAwsEC2, a, jistAwsEC2.getKeyPairAbsolutePath(),
					EC2_USER,jistAwsS3.getS3Bucket());
			jistAwsReInitConfig.start();

		}
		return true;
	}

	/**
	 * Mapping from selected Region area to aws ec2 location
	 * 
	 * @param regionName
	 *            Name of Region
	 * @return EndPoint location, if successful
	 */
	private String ec2Endpoint(String regionName) {
		if (regionName.equals(REGION_OREGON)) {
			return ENDPOINT_OREGON;
		} else if (regionName.equals(REGION_NCALIFORNIA)) {
			return ENDPOINT_NCALIFORNIA;
		} else if (regionName.equals(REGION_NVIRGINIA)) {
			return ENDPOINT_NVIRGINIA;
		} else if (regionName.equals(REGION_IRELAND)) {
			return ENDPOINT_IRELAND;
		} else if (regionName.equals(REGION_FRANKFURT)) {
			return ENDPOINT_FRANKFURT;
		} else if (regionName.equals(REGION_SINGAPORE)) {
			return ENDPOINT_SINGAPORE;
		} else if (regionName.equals(REGION_SYDNEY)) {
			return ENDPOINT_SYDNEY;
		} else if (regionName.equals(REGION_TOKYO)) {
			return ENDPOINT_TOKYO;
		} else if (regionName.equals(REGION_SAOPAULO)) {
			return ENDPOINT_SAOPAULO;
		}
		return "NOTFOUND";
	}

	private String s3Endpoint(String regionName) {
		if (regionName.equals(REGION_OREGON)) {
			return ENDPOINT_OREGON_S3;
		} else if (regionName.equals(REGION_NCALIFORNIA)) {
			return ENDPOINT_NCALIFORNIA_S3;
		} else if (regionName.equals(REGION_NVIRGINIA)) {
			return ENDPOINT_NVIRGINIA_S3;
		} else if (regionName.equals(REGION_IRELAND)) {
			return ENDPOINT_IRELAND_S3;
		} else if (regionName.equals(REGION_FRANKFURT)) {
			return ENDPOINT_FRANKFURT_S3;
		} else if (regionName.equals(REGION_SINGAPORE)) {
			return ENDPOINT_SINGAPORE_S3;
		} else if (regionName.equals(REGION_SYDNEY)) {
			return ENDPOINT_SYDNEY_S3;
		} else if (regionName.equals(REGION_TOKYO)) {
			return ENDPOINT_TOKYO_S3;
		} else if (regionName.equals(REGION_SAOPAULO)) {
			return ENDPOINT_SAOPAULO_S3;
		}
		return "NOTFOUND";
	}

	/**
	 * Check account credential info & selected region.
	 */
	private void checkAccountValidation() {
		String selectedEC2EndPoint = ec2Endpoint(cb_Region.getSelectedItem()
				.toString());
		jistAwsEC2 = new JistAwsEC2(tf_accessKeyID.getText(),
				pwf_secretAccessKey.getText(), selectedEC2EndPoint);

		jistAwsEC2.setRegion(selectedEC2EndPoint);

		String selectedS3EndPoint = s3Endpoint(cb_Region.getSelectedItem()
				.toString());
		jistAwsS3 = new JistAwsS3(tf_accessKeyID.getText(),
				pwf_secretAccessKey.getText(), selectedS3EndPoint);

		jistAwsS3.setS3Region(selectedS3EndPoint);

		DescribeAccountAttributesResult account = jistAwsEC2
				.getAmazonEc2Client().describeAccountAttributes();
		List<AccountAttribute> accountAttr = account.getAccountAttributes();
		if (accountAttr.size() != 0) {
			JOptionPane.showMessageDialog(null, "Valid AWS Account!");
			setEnabledTrue();
		} else {
			JOptionPane.showMessageDialog(null,
					"Please check your credential info.");
		}

	}

	/**
	 * File chooser to locate secret keypair
	 * 
	 * @param oldKey
	 *            Exist private key name
	 * @return Key pair location, if successful
	 */
	private static String selectKey(String oldKey) {
		JFileChooser loadDialog = new JFileChooser("Specify AWS private key");
		File oldFile = new File(oldKey);

		if ((!oldKey.isEmpty()) && oldFile.exists()) {
			loadDialog.setCurrentDirectory(oldFile.getParentFile());
		} else {
			loadDialog.setCurrentDirectory(MipavController
					.getDefaultWorkingDirectory());
		}

		loadDialog.setDialogType(JFileChooser.OPEN_DIALOG);
		loadDialog.setFileSelectionMode(JFileChooser.FILES_ONLY);
		loadDialog
				.setFileFilter(new FileNameExtensionFilter("PEM file", "pem"));
		loadDialog.removeChoosableFileFilter(loadDialog
				.getAcceptAllFileFilter());

		int returnVal = loadDialog.showOpenDialog(null);
		if ((returnVal == JFileChooser.APPROVE_OPTION)
				&& loadDialog.getSelectedFile().getName().toLowerCase()
						.endsWith(".pem")) {
			return loadDialog.getSelectedFile().getAbsolutePath();
		} else {
			return null;
		}
	}

	/**
	 * Import existence key pair
	 * 
	 */
	private void importOldKeyPair() {
		tf_oldKeyPairPath.setText(selectKey(tf_oldKeyPairPath.getText()));

		File file = new File(tf_oldKeyPairPath.getText());
		jistAwsEC2.setKeyPairAbsolutePath(file.getAbsolutePath());

		// remove file extension
		String fileAbsoluteName = file.getName();
		int dot = fileAbsoluteName.lastIndexOf('.');

		if ((dot > -1) && (dot < (fileAbsoluteName.length()))) {
			jistAwsEC2.setKeyPairName(fileAbsoluteName.substring(0, dot));
		}

		System.out.println(jistAwsEC2.getKeyPairAbsolutePath());
		System.out.println(jistAwsEC2.getKeyPairName());
	}

	/**
	 * Create folder to save key pair created by jist
	 * 
	 * @param destDirName
	 *            Jist key pair default folder home/JistAwsEc2
	 * @return true, if successful
	 */

	private static boolean createDir(String destDirName) {
		File dir = new File(destDirName);
		if (dir.exists()) {
			System.out.println(destDirName + " has existed");
		}
		if (!destDirName.endsWith(File.separator)) {
			destDirName = destDirName + File.separator;
		}
		// create dir
		if (dir.mkdirs()) {
			System.out.println("Create dir " + destDirName + " success");

			// create DoNotDelete
			File doNotDelete = new File(destDirName + File.separator
					+ "DoNotDelete" + File.separator);
			if (doNotDelete.exists()) {
				System.out.println(destDirName + File.separator + "DoNotDelete"
						+ File.separator + " has existed");
			} else {
				doNotDelete.mkdirs();
				System.out.println("Create dir " + destDirName + File.separator
						+ "DoNotDelete" + File.separator + " success");
			}

			File tmp = new File(destDirName + File.separator + "tmp"
					+ File.separator);
			if (tmp.exists()) {
				System.out.println(destDirName + File.separator + "tmp"
						+ File.separator + " has existed");
			} else {
				tmp.mkdirs();
				System.out.println("Create dir " + destDirName + File.separator
						+ "tmp" + File.separator + " success");
			}

			return true;
		} else {
			System.out.println(destDirName + " has existed");
			return false;
		}
	}

	private boolean necessaryPackageChecking() {
		File fDoNotDelete = new File(System.getProperties().getProperty(
				"user.home")
				+ "/JistAwsEc2/DoNotDelete");
		if (fDoNotDelete.exists() && fDoNotDelete.isDirectory()) {
			System.out.println("Folder JistAwsEc2/DoNotDelete exists");
		} else {
			JOptionPane
					.showMessageDialog(null,
							"Folder JistAwsEc2/DoNotDelete does not exists, please create one.");
			return false;
		}

		File fTmp = new File(System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2/tmp");
		if (fTmp.exists() && fTmp.isDirectory()) {
			System.out.println("Folder JistAwsEc2/tmp exists");
		} else {
			JOptionPane
					.showMessageDialog(null,
							"Folder JistAwsEc2/tmp does not exists, please create one.");
			return false;
		}

		File fMIPAVinstallFile = new File(System.getProperties().getProperty(
				"user.home")
				+ "/JistAwsEc2/DoNotDelete/installMIPAV.bin");
		if (fMIPAVinstallFile.exists() && !fMIPAVinstallFile.isDirectory()) {
			System.out
					.println("JistAwsEc2/DoNotDelete/installMIPAV.bin exists");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please Download installMIPAV.bin version 7.0.1 for linux and save it to JistAwsEc2/DoNotDelete directory.");
			return false;
		}

		File fPlugins = new File(System.getProperties()
				.getProperty("user.home")
				+ "/JistAwsEc2/DoNotDelete/plugins.zip");
		if (fPlugins.exists() && !fPlugins.isDirectory()) {
			System.out.println("JistAwsEc2/DoNotDelete/plugins.zip exists");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please compress \"plugins\" folder as plugins.zip in mipav source folder, and move it to JistAwsEc2/DoNotDelete directory.");
			return false;
		}

		File fJistLib = new File(System.getProperties()
				.getProperty("user.home")
				+ "/JistAwsEc2/DoNotDelete/jist-lib.zip");
		if (fJistLib.exists() && !fJistLib.isDirectory()) {
			System.out.println("JistAwsEc2/DoNotDelete/jist-lib.zip exists");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please compress JIST library folder as jist-lib.zip, and move it to JistAwsEc2/DoNotDelete directory.");
			return false;
		}

		File fMipavPreference = new File(System.getProperties().getProperty(
				"user.home")
				+ "/JistAwsEc2/DoNotDelete/mipav.preferences");
		if (fMipavPreference.exists() && !fMipavPreference.isDirectory()) {
			System.out
					.println("JistAwsEc2/DoNotDelete/mipav.preferences exists");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please find mipav.preferences from your mipav source folder, and move it to JistAwsEc2/DoNotDelete directory.");
			return false;
		}

		File fJistPreference = new File(System.getProperties().getProperty(
				"user.home")
				+ "/JistAwsEc2/DoNotDelete/JistUserPreferences.xml");
		if (fJistPreference.exists() && !fJistPreference.isDirectory()) {
			System.out
					.println("JistAwsEc2/DoNotDelete/JistUserPreferences.xml exists");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please find JistUserPreferences.xml from your JIST Library, and move it to JistAwsEc2/DoNotDelete directory.");
			return false;
		}

		try {
			JistAwsUtil.createSciptsForCloud(System.getProperties()
					.getProperty("user.home") + "/JistAwsEc2/DoNotDelete");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return true;
	}

	/**
	 * Import all bucket from Aws S3
	 */

	private void importAllBucket() {
		List<Bucket> s3Bucket = new ArrayList<Bucket>();
		ListBucketsRequest listBucketsRequest = new ListBucketsRequest();
		s3Bucket = jistAwsS3.getAmazonS3Client()
				.listBuckets(listBucketsRequest);

		cb_S3Bucket.removeAllItems();
		for (Bucket tmpS3Bucket : s3Bucket) {
			cb_S3Bucket.addItem(tmpS3Bucket.getName());
		}
	}

	/**
	 * Create a new bucket
	 */
	private void createNewBucket(String bucketName) {
		if (jistAwsS3.getAmazonS3Client().doesBucketExist(bucketName)) {
			JOptionPane.showMessageDialog(null,
					"Please choose another Bucket name.");
		} else {
			jistAwsS3.getAmazonS3Client().createBucket(bucketName);
			jistAwsS3.setS3Bucket(bucketName);
			JOptionPane.showMessageDialog(null, "Bucket " + bucketName
					+ " is successfully created!");
		}
	}

	/**
	 * Check if new key pair existed in cloud
	 * 
	 * @return true, if successful
	 */
	private boolean checkNewKeyPair() {
		jistAwsEC2.setKeyPairAbsolutePath(str_keyPairFolder);
		jistAwsEC2.setKeyPairName(tf_newKeyPairName.getText());
		return jistAwsEC2.checkNewKeyPair(tf_newKeyPairName.getText());
	}

	/**
	 * Create new key pair by jist
	 * 
	 * @throws IOException
	 */
	private void createNewKeyPair() throws IOException {
		if (checkNewKeyPair()) {
			jistAwsEC2.createKeyPair(jistAwsEC2.getAmazonEc2Client(),
					str_keyPairFolder, jistAwsEC2.getKeyPairName());
			JOptionPane.showMessageDialog(
					null,
					"Your new Key Pair is successfully saved in "
							+ jistAwsEC2.getKeyPairAbsolutePath()
							+ " , please keep it carefully!");
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please type another Key Pair name, it has existed in AWS EC2. Or import the keypair from your workstation.");
		}
	}

	/**
	 * Import all security group from Aws EC2
	 * 
	 */
	private void importAllSeurityGroup() {
		DescribeSecurityGroupsResult describesecurityGroup = jistAwsEC2
				.getAmazonEc2Client().describeSecurityGroups();
		List<SecurityGroup> securityGroup = describesecurityGroup
				.getSecurityGroups();
		cb_SecurityGroup.removeAllItems();
		for (SecurityGroup tmpSecurityGroup : securityGroup) {
			cb_SecurityGroup.addItem(tmpSecurityGroup.getGroupName());
		}
	}

	/**
	 * Check if security name or description is empty
	 * 
	 * @return true, if success
	 */
	private boolean checkNewSecurityGroup() {
		// AmazonEC2 ec2Client = jistAwsEC2.getAmazonEc2Client();
		// // set Security Group
		jistAwsEC2.setSecurityGroupName(tf_newSecurityGroup.getText());
		jistAwsEC2.setSecurityGroupDescription(tf_SecurityGDescription
				.getText());
		if ((tf_SecurityGDescription.getText().isEmpty())
				|| (tf_newSecurityGroup.getText().isEmpty()))
			return false;

		return jistAwsEC2.checkNewSecurityGroup(
				jistAwsEC2.getAmazonEc2Client(),
				jistAwsEC2.getSecurityGroupName());
	}

	/**
	 * Create new Security group
	 * 
	 */
	private void createNewSecurityGroup() throws IOException {
		if (checkNewSecurityGroup()) {
			AmazonEC2 ec2Client = jistAwsEC2.getAmazonEc2Client();
			jistAwsEC2.createSecurityGroup(ec2Client,
					jistAwsEC2.getSecurityGroupName(),
					tf_SecurityGDescription.getText());
			JOptionPane.showMessageDialog(null,
					"You successfully create a new security group "
							+ jistAwsEC2.getSecurityGroupName());
		} else {
			JOptionPane
					.showMessageDialog(
							null,
							"Please type another Securtiy group name, it is empty or it has existed in AWS EC2. Or select existent security group.");
		}
	}

	/**
	 * Init cloud instances
	 * 
	 * @throws IOException
	 * @throws JSchException
	 * @throws InterruptedException
	 * 
	 */
	private void initCloud() throws JSchException, IOException,
			InterruptedException {
		
			jistAwsEC2.setImageId(cb_AMI.getSelectedItem().toString());
			jistAwsEC2.setInstanceType(cb_AMIType.getSelectedItem().toString());
			jistAwsEC2.setMaxInstanceNum(sp_numberOfInstances.getValue());
			totalNumOfMachine = (Integer) sp_numberOfInstances.getValue();
			if (rb_ifCreateSecurityGroup[1].isSelected()) {
				jistAwsEC2.setSecurityGroupName(cb_SecurityGroup
						.getSelectedItem().toString());
			}
			if (rb_ifCreateSecurityGroup[0].isSelected()) {
				jistAwsEC2.setSecurityGroupName(tf_newSecurityGroup.getText());
				jistAwsEC2.setSecurityGroupDescription(tf_SecurityGDescription
						.getText());
			}
			if (rb_ifCreateS3Bucket[1].isSelected()) {
				jistAwsS3.setS3Bucket(this.cb_S3Bucket.getSelectedItem()
						.toString());
			}

			if (rb_ifCreateS3Bucket[0].isSelected()) {
				jistAwsS3.setS3Bucket(this.tf_s3NewBucket.getText());
			}

			jistAwsEC2.runAndInitInstance(jistAwsEC2);
			System.out.println(new Date(System.currentTimeMillis()));
			boolean ifMIpavJistExistInCloud = jistAwsS3.ifMipavJistTranserDone(
					jistAwsS3.getAmazonS3Client(), jistAwsS3.getS3Bucket());
			if (ifMIpavJistExistInCloud == false) {
				JOptionPane
						.showMessageDialog(
								null,
								"Please be patient:) Approximately taking 5 min."
										+ "Please make sure all running instances' status are \"ok\" and then press done.");

				jistAwsS3.sendMipavJistToS3(jistAwsS3.getAmazonS3Client(),
						jistAwsS3.getS3Bucket());
			}

			refreshCloudListPanel();

	}

	/**
	 * Timer for refresh
	 * 
	 */
	final Timer awsEC2AutoRefresh = new Timer(2000, new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			try {
				refreshCloud();
			} catch (JSchException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
	});

	/**
	 * Call Aws Ec2 to refresh the instances status, and call func to repaint
	 * the list panel
	 * 
	 * @throws IOException
	 * @throws JSchException
	 * @throws InterruptedException
	 * 
	 */
	private void refreshCloud() throws JSchException, IOException,
			InterruptedException {
		// FIRST REFRESH ALL INSTANCE AND STATES
		jistAwsEC2.refreshStatus();
		// SECOND REFRESH THE PANEL
		refreshCloudListPanel();
		// if(jistAwsS3.ifMipavJistTranserDone(jistAwsS3.getAmazonS3Client(),
		// jistAwsS3.getS3Bucket()))
		// System.out.println(new Date(System.currentTimeMillis()));

	}

	/**
	 * Repaint the list panel
	 * 
	 * @throws IOException
	 * @throws JSchException
	 * @throws InterruptedException
	 * 
	 */
	private void refreshCloudListPanel() throws JSchException, IOException,
			InterruptedException {
		Set<Instance> tmpPPP = new HashSet<Instance>();
		// get All instance
		tmpPPP = jistAwsEC2.getCurrentInstances();

		DefaultListModel<AwsEC2CheckListItem> modelNew = new DefaultListModel<AwsEC2CheckListItem>();
		l_instanceStatus.setCellRenderer(new AwsEC2CheckListRenderer());
		l_instanceStatus.setModel(modelNew);

		for (Instance a : tmpPPP) {

			String cloudInfo = "Id:" + a.getInstanceId() + "-State:"
					+ a.getState().getName();
			if (a.getState().getName().equals("running")) {
				cloudInfo = cloudInfo + "-Status:"
						+ jistAwsEC2.getInstanceStatus(a.getInstanceId());
			}
			modelNew.addElement(new AwsEC2CheckListItem(cloudInfo));
			// IF STATE IS RUNNING, mount s3 to the ec2 machine, install mipav
			// and jist to ec2,

			// if(a.getState().getName().equals("running")){
			//
			// // System.out.println(a.getStateReason().toString());
			// // jistAwsEC2.sendS3FStoEC2(a,
			// jistAwsEC2.getKeyPairAbsolutePath(), EC2_USER);
			// //
			// // jistAwsEC2.mountS3initialMipavJist(a,
			// jistAwsEC2.getKeyPairAbsolutePath(),EC2_USER);
			// }
		}
	}

	/**
	 * Get selected instance from list panel
	 * 
	 * @return List<String> return the instances id.
	 */
	private List<String> getSelectedInstance() {
		List<String> selectInstance = new ArrayList<String>();
		int index = l_instanceStatus.getLastVisibleIndex();
		String tmpInstanceId = "";
		// System.out.println(l_instanceStatus.getLastVisibleIndex());
		// because index starts from 0, so we need to add 1 as index +1
		for (int i = 0; i < index + 1; ++i) {

			AwsEC2CheckListItem item = (AwsEC2CheckListItem) l_instanceStatus
					.getModel().getElementAt(i);
			if (item.isSelected()) {
				tmpInstanceId = item.toString();

				int dot = item.toString().indexOf("-State");

				// 3 means id:xxx-xxxxxx we start from the 4th index of string
				// to get the id
				if ((dot > -1) && (dot < (item.toString().length()))) {
					tmpInstanceId = (item.toString().substring(3, dot));
					selectInstance.add(tmpInstanceId);
				}

			}
		}
		return selectInstance;
	}

	@Override
	public void actionPerformed(ActionEvent evt) {
		// TODO Auto-generated method stub
		if (evt.getSource() == b_checkCredentialValid) {
			System.out.println(tf_accessKeyID.getText());
			checkAccountValidation();
			tf_oldKeyPairPath.setText("");
			cb_SecurityGroup.removeAllItems();
			cb_SecurityGroup.setEnabled(false);
			cb_SecurityGroup.addItem("PLEASE IMPORT");
			cb_S3Bucket.setEnabled(false);
			cb_S3Bucket.addItem("PLEASE IMPORT");
		} else if (evt.getSource() == awsEc2InitButton) {
			if (!necessaryPackageChecking()) {
				System.out.println("Some necessary Packages are missing");
			} else {
				try {
					initCloud();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				awsEC2AutoRefresh.start();
				b_install.setEnabled(true);
				awsEc2InitButton.setEnabled(false);
				awsEc2StopRefreshButton.setEnabled(true);
				awsEc2StopButton.setEnabled(true);
				awsEc2StartButton.setEnabled(true);
				awsEc2TerminateButton.setEnabled(true);
				awsEc2StartAllButton.setEnabled(true);
				awsEc2StopAllButton.setEnabled(true);
				awsEc2TerminateAllButton.setEnabled(true);
			}
			
		} else if (evt.getSource() == awsEc2StopButton) {
			selectedInstanceId.clear();
			selectedInstanceId = getSelectedInstance();
			boolean ifExecute = jistAwsEC2.stopInsance(
					jistAwsEC2.getAmazonEc2Client(), selectedInstanceId);
			if (ifExecute == true) {
				try {
					refreshCloud();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				awsEC2AutoRefresh.start();
				awsEc2RefreshButton.setEnabled(false);
				awsEc2StopRefreshButton.setEnabled(true);
			} else {
				JOptionPane.showMessageDialog(null,
						"Please make sure selected instances are running");
				awsEC2AutoRefresh.start();
			}

		} else if (evt.getSource() == awsEc2StartButton) {
			selectedInstanceId.clear();
			selectedInstanceId = getSelectedInstance();
			boolean ifExecute = jistAwsEC2.startInstance(
					jistAwsEC2.getAmazonEc2Client(), selectedInstanceId);
			if (ifExecute == true) {
				try {
					refreshCloud();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				awsEC2AutoRefresh.start();
				awsEc2RefreshButton.setEnabled(false);
				awsEc2StopRefreshButton.setEnabled(true);
			} else {
				JOptionPane.showMessageDialog(null,
						"Please make sure selected instances are stopped");
				awsEC2AutoRefresh.start();
			}

		} else if (evt.getSource() == awsEc2TerminateButton) {
			selectedInstanceId.clear();
			selectedInstanceId = getSelectedInstance();
			jistAwsEC2.terminateInstance(jistAwsEC2.getAmazonEc2Client(),
					selectedInstanceId);
			if (jistAwsEC2.getCurrentInstancesId().isEmpty()) {
				awsEC2AutoRefresh.stop();
				try {
					refreshCloud();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				initEnabledFalse();
				// jistAwsEC2.destructor();
			} else {
				try {
					refreshCloud();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				awsEC2AutoRefresh.start();
				awsEc2RefreshButton.setEnabled(false);
				awsEc2StopRefreshButton.setEnabled(true);
			}
		} else if (evt.getSource() == awsEc2StopAllButton) {
			List<String> listAllInstanceIds = new ArrayList<String>(
					jistAwsEC2.getCurrentInstancesId());
			boolean ifExecute = jistAwsEC2.stopInsance(
					jistAwsEC2.getAmazonEc2Client(), listAllInstanceIds);
			if (ifExecute == true) {
				awsEC2AutoRefresh.start();
			} else {
				JOptionPane.showMessageDialog(null,
						"Please make sure selected instances are running");
				awsEC2AutoRefresh.start();
			}

		} else if (evt.getSource() == awsEc2StartAllButton) {
			List<String> listAllInstanceIds = new ArrayList<String>(
					jistAwsEC2.getCurrentInstancesId());
			boolean ifExecute = jistAwsEC2.startInstance(
					jistAwsEC2.getAmazonEc2Client(), listAllInstanceIds);
			if (ifExecute == true) {
				awsEC2AutoRefresh.start();
			} else {
				JOptionPane.showMessageDialog(null,
						"Please make sure selected instances are stopped");
				awsEC2AutoRefresh.start();
			}
		} else if (evt.getSource() == awsEc2TerminateAllButton) {

			List<String> listAllInstanceIds = new ArrayList<String>(
					jistAwsEC2.getCurrentInstancesId());
			jistAwsEC2.terminateInstance(jistAwsEC2.getAmazonEc2Client(),
					listAllInstanceIds);
			// Set<String> clearAllInstance = new HashSet<String>();
			jistAwsEC2.removeAllInstances();
			jistAwsS3.removeBucket(jistAwsS3.getAmazonS3Client(),
					jistAwsS3.getS3Bucket());
			awsEc2InitButton.setEnabled(true);
			try {
				refreshCloud();
			} catch (JSchException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			awsEC2AutoRefresh.stop();
			initEnabledFalse();
			// jistAwsEC2.destructor();
		} else if (evt.getSource() == awsEc2RefreshButton) {
			awsEC2AutoRefresh.start();
			awsEc2RefreshButton.setEnabled(false);
			awsEc2StopRefreshButton.setEnabled(true);
		} else if (evt.getSource() == awsEc2StopRefreshButton) {
			awsEC2AutoRefresh.stop();
			awsEc2RefreshButton.setEnabled(true);
			awsEc2StopRefreshButton.setEnabled(false);
		} else if (evt.getSource() == rb_ifCreateS3Bucket[0]) {
			rb_ifCreateS3Bucket[1].setSelected(false);
			b_AllS3Bucket.setEnabled(false);
			tf_s3NewBucket.setEnabled(true);
			b_createS3Bucket.setEnabled(true);
		} else if (evt.getSource() == rb_ifCreateS3Bucket[1]) {
			rb_ifCreateS3Bucket[0].setSelected(false);
			b_AllS3Bucket.setEnabled(true);
			tf_s3NewBucket.setEnabled(false);
			b_createS3Bucket.setEnabled(false);
		} else if (evt.getSource() == b_AllS3Bucket) {
			cb_S3Bucket.setEnabled(true);
			importAllBucket();
		} else if (evt.getSource() == b_createS3Bucket) {
			createNewBucket(tf_s3NewBucket.getText());
		} else if (evt.getSource() == rb_ifCreateKeyPair[0]) {
			rb_ifCreateKeyPair[1].setSelected(false);
			b_selectKeyPair.setEnabled(false);
			tf_oldKeyPairPath.setEnabled(false);
			tf_oldKeyPairPath.setText("");
			b_createKeyPair.setEnabled(true);
			tf_newKeyPairName.setEnabled(true);
		} else if (evt.getSource() == rb_ifCreateKeyPair[1]) {
			rb_ifCreateKeyPair[0].setSelected(false);
			b_selectKeyPair.setEnabled(true);
			tf_oldKeyPairPath.setEnabled(true);
			b_createKeyPair.setEnabled(false);
			tf_newKeyPairName.setEnabled(false);
			tf_newKeyPairName.setText("");
		} else if (evt.getSource() == b_selectKeyPair) {
			importOldKeyPair();
		} else if (evt.getSource() == b_createKeyPair) {
			try {
				createNewKeyPair();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (evt.getSource() == rb_ifCreateSecurityGroup[0]) {
			rb_ifCreateSecurityGroup[1].setSelected(false);
			b_createSecurityGroup.setEnabled(true);
			cb_SecurityGroup.setEnabled(false);
			cb_SecurityGroup.removeAllItems();
			b_AllSecurityGroup.setEnabled(false);
			tf_newSecurityGroup.setEnabled(true);
			tf_SecurityGDescription.setEnabled(true);
			// JOptionPane.showMessageDialog(null, " yes");
		} else if (evt.getSource() == rb_ifCreateSecurityGroup[1]) {
			rb_ifCreateSecurityGroup[0].setSelected(false);
			b_createSecurityGroup.setEnabled(false);
			cb_SecurityGroup.setEnabled(true);
			b_AllSecurityGroup.setEnabled(true);
			tf_newSecurityGroup.setEnabled(false);
			tf_newSecurityGroup.setText("");
			tf_SecurityGDescription.setEnabled(false);
			tf_SecurityGDescription.setText("");

		} else if (evt.getSource() == b_AllSecurityGroup) {
			cb_SecurityGroup.setEnabled(true);
			importAllSeurityGroup();
		} else if (evt.getSource() == b_createSecurityGroup) {
			try {
				createNewSecurityGroup();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (evt.getSource() == b_install) {

			totalNumOfMachine = jistAwsEC2.getCurrentInstances().size();
			try {
				// CREATE USER-DEFIENED s3fs.bin file0000000
				File f = new File(System.getProperties().getProperty(
						"user.home")
						+ "/JistAwsEc2/DoNotDelete" + "/s3fs.bin");
				if (f.exists() && !f.isDirectory())
					Files.delete(Paths.get(f.getAbsolutePath()));
				String s3fsTemplate = new String(Files.readAllBytes(Paths
						.get(System.getProperties().getProperty("user.home")
								+ "/JistAwsEc2/DoNotDelete"
								+ "/s3fs_template.bin")));
				s3fsTemplate = s3fsTemplate.replace("$ACCESSKEY$",
						tf_accessKeyID.getText());
				s3fsTemplate = s3fsTemplate.replace("$SECRETKEY$",
						pwf_secretAccessKey.getText());
				s3fsTemplate = s3fsTemplate.replace("$BUCKET$",
						jistAwsS3.getS3Bucket());
				Files.write(
						Paths.get(System.getProperties().getProperty(
								"user.home")
								+ "/JistAwsEc2/DoNotDelete" + "/s3fs.bin"),
						s3fsTemplate.getBytes());
				// CREATE USER-DEFIENED s3fs.bin file0000000
				if (installMipavJist()) {
					AwsInstallProgressBarPanel.showDialog(this, layout,
							jistAwsEC2);
					b_install.setEnabled(false);
				} 
//				if (reInstallMipavJist()) {
//					b_install.setEnabled(false);
//				}

			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Create panel to display preferences.
	 * 
	 * @throws BadLocationException
	 * @throws IOException
	 */
	protected void createPane() throws BadLocationException {
		int TEXT_WIDTH = 50;
		int SMALL_TEXT_WIDTH = TEXT_WIDTH - 10;

		this.setLayout(new BorderLayout());
		JPanel small = new JPanel();
		BoxLayout layout = new BoxLayout(small, BoxLayout.PAGE_AXIS);
		small.setLayout(layout);
		this.add(small, BorderLayout.NORTH);
		this.setPreferredSize(new Dimension(770, 770));

		JPanel itemPane = new JPanel(new BorderLayout());

		// Access key ID
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Access key ID"), BorderLayout.WEST);
		itemPane.add(tf_accessKeyID = new JTextField(SMALL_TEXT_WIDTH),
				BorderLayout.EAST);
		small.add(itemPane);

		// Secret access key
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Secret Access Key"), BorderLayout.WEST);
		itemPane.add(
				pwf_secretAccessKey = new JPasswordField(SMALL_TEXT_WIDTH),
				BorderLayout.EAST);
		small.add(itemPane);

		// Region information
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Region"), BorderLayout.WEST);
		itemPane.add(cb_Region = new JComboBox<String>(), BorderLayout.EAST);

		cb_Region.addItem(REGION_OREGON);
		cb_Region.addItem(REGION_NCALIFORNIA);
		cb_Region.addItem(REGION_NVIRGINIA);
		cb_Region.addItem(REGION_IRELAND);
		cb_Region.addItem(REGION_FRANKFURT);
		cb_Region.addItem(REGION_SINGAPORE);
		cb_Region.addItem(REGION_SYDNEY);
		cb_Region.addItem(REGION_TOKYO);
		cb_Region.addItem(REGION_SAOPAULO);
		// Default select US West Oregon
		cb_Region.setSelectedItem("US West (Oregon)");
		small.add(itemPane);

		// Check if Credential is valid
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(b_checkCredentialValid = new JButton(
				"Check Account Validation"), BorderLayout.CENTER);
		small.add(itemPane);

		// s3 Bucket section
		// S3 BUCKETNAME

		itemPane = new JPanel(new GridBagLayout());
		GridBagConstraints bKey = new GridBagConstraints();
		bKey.gridx = 0;
		bKey.gridy = 0;
		Border line = BorderFactory.createLineBorder(Color.black);
		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Create a new bucket?"));

		rb_ifCreateS3Bucket = new JRadioButton[2];
		itemPane.add(rb_ifCreateS3Bucket[1] = new JRadioButton("No", true),
				bKey);

		bKey.gridx++;
		itemPane.add(new JLabel("S3 Bucket"), bKey);

		bKey.gridx++;
		itemPane.add(cb_S3Bucket = new JComboBox<String>(), bKey);

		bKey.gridx++;
		bKey.gridx++;

		itemPane.add(b_AllS3Bucket = new JButton("Import All Bucket"), bKey);
		small.add(itemPane);

		// Second line, if yes, we create a new security group with description
		bKey.gridx = 0;
		bKey.gridy++;
		itemPane.add(rb_ifCreateS3Bucket[0] = new JRadioButton("yes", true),
				bKey);

		bKey.gridx++;
		itemPane.add(new JLabel("Bucket Name"), bKey);

		tf_s3NewBucket = new JTextField(SMALL_TEXT_WIDTH - 25);
		bKey.gridx++;
		itemPane.add(tf_s3NewBucket, bKey);

		bKey.gridx++;
		itemPane.add(new JLabel("   "), bKey);

		b_createS3Bucket = new JButton("Create");
		bKey.gridx++;
		itemPane.add(b_createS3Bucket, bKey);
		small.add(itemPane);

		// PRIVATE KEY PAIR SECTION
		itemPane = new JPanel(new GridBagLayout());
		GridBagConstraints cKey = new GridBagConstraints();
		cKey.gridx = 0;
		cKey.gridy = 0;
		line = BorderFactory.createLineBorder(Color.black);
		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Create a new key pair?"));

		rb_ifCreateKeyPair = new JRadioButton[2];
		// first Line, if no, we import old key
		itemPane.add(rb_ifCreateKeyPair[1] = new JRadioButton("No", true), cKey);

		// Import a key pair
		cKey.gridx++;
		itemPane.add(new JLabel("Import Key Pair"), cKey);

		cKey.gridx++;
		itemPane.add(tf_oldKeyPairPath = new JTextField(SMALL_TEXT_WIDTH - 8),
				cKey);

		cKey.gridx++;
		itemPane.add(b_selectKeyPair = new JButton("Browse"), cKey);

		// second line, if yes, we create a key pair
		cKey.gridx = 0;
		cKey.gridy++;
		itemPane.add(rb_ifCreateKeyPair[0] = new JRadioButton("Yes", false),
				cKey);

		cKey.gridx++;
		itemPane.add(new JLabel("Create Key Pair"), cKey);

		cKey.gridx++;
		itemPane.add(tf_newKeyPairName = new JTextField(SMALL_TEXT_WIDTH - 8),
				cKey);
		tf_newKeyPairName.getDocument().addDocumentListener(
				new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						warn();
					}

					public void removeUpdate(DocumentEvent e) {
						warn();
					}

					public void insertUpdate(DocumentEvent e) {
						warn();
					}

					public void warn() {
						if (!tf_newKeyPairName.getText().isEmpty()) {
							b_createKeyPair.setEnabled(true);
						}
					}
				});

		cKey.gridx++;
		itemPane.add(b_createKeyPair = new JButton("Create"), cKey);
		small.add(itemPane);

		// SECURITY GROUP SECTION
		itemPane = new JPanel(new GridBagLayout());
		GridBagConstraints cSG = new GridBagConstraints();
		cSG.gridx = 0;
		cSG.gridy = 0;

		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Create a new security Group?"));
		// first line, if no, we import all security group
		rb_ifCreateSecurityGroup = new JRadioButton[2];
		itemPane.add(
				rb_ifCreateSecurityGroup[1] = new JRadioButton("No", true), cSG);
		// itemPane.setLayout(new FlowLayout(FlowLayout.CENTER));

		cSG.gridx++;
		itemPane.add(new JLabel("Security Group"), cSG);

		cSG.gridx++;
		itemPane.add(cb_SecurityGroup = new JComboBox<String>(), cSG);

		cSG.gridx++;
		cSG.gridx++;
		cSG.gridx++;
		itemPane.add(b_AllSecurityGroup = new JButton("Import All Groups"), cSG);
		small.add(itemPane);

		// Second line, if yes, we create a new security group with description
		cSG.gridx = 0;
		cSG.gridy++;
		itemPane.add(
				rb_ifCreateSecurityGroup[0] = new JRadioButton("yes", true),
				cSG);

		cSG.gridx++;
		itemPane.add(new JLabel("Group Name"), cSG);

		tf_newSecurityGroup = new JTextField(SMALL_TEXT_WIDTH - 25);
		cSG.gridx++;
		itemPane.add(tf_newSecurityGroup, cSG);

		cSG.gridx++;
		itemPane.add(new JLabel("   "), cSG);

		cSG.gridx++;
		itemPane.add(new JLabel("Description"), cSG);

		tf_SecurityGDescription = new JTextField(SMALL_TEXT_WIDTH - 25);
		cSG.gridx++;
		itemPane.add(tf_SecurityGDescription, cSG);

		b_createSecurityGroup = new JButton("Create");
		cSG.gridx++;
		itemPane.add(b_createSecurityGroup, cSG);
		small.add(itemPane);

		// Amazon Machine Image, Type, Max Number
		itemPane = new JPanel(new GridBagLayout());

		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Amazon machine instance info"));
		GridBagConstraints cAmi = new GridBagConstraints();

		cAmi.gridx = 0;
		cAmi.gridy = 0;
		itemPane.add(new JLabel("AMI"), cAmi);

		cAmi.gridx++;
		itemPane.add(new JLabel("     "), cAmi);

		cb_AMI = new JComboBox<String>();
		cAmi.gridx++;
		itemPane.add(cb_AMI, cAmi);
		cb_AMI.addItem("ami-ff527ecf");
		// cb_AMI.addItem("ami-e7527ed7");

		cAmi.gridx++;
		itemPane.add(new JLabel("               "), cAmi);

		cAmi.gridx++;
		itemPane.add(new JLabel("Type"), cAmi);

		cAmi.gridx++;
		itemPane.add(new JLabel("     "), cAmi);

		cb_AMIType = new JComboBox<String>();
		cAmi.gridx++;
		itemPane.add(cb_AMIType, cAmi);
		cb_AMIType.addItem("t1.micro");
		cb_AMIType.addItem("m3.medium");
		cb_AMIType.addItem("m3.large");
		cb_AMIType.addItem("m3.xlarge");
		cb_AMIType.addItem("m3.2xlarge");
		// cb_AMIType.addItem("r3.2xlarge");

		cAmi.gridx++;
		itemPane.add(new JLabel("               "), cAmi);

		cAmi.gridx++;
		itemPane.add(new JLabel("Num of instances"), cAmi);

		cAmi.gridx++;
		itemPane.add(new JLabel("     "), cAmi);

		sp_numberOfInstances = new JSpinner((new SpinnerNumberModel(3, 0, 100,
				1)));
		cAmi.gridx++;
		itemPane.add(sp_numberOfInstances, cAmi);
		small.add(itemPane);

		// Use to seperate Panel...T_T
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel(" "));
		small.add(itemPane);
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel(" "));
		small.add(itemPane);

		// CLOUD INITIALIZATION AND INSTALL SECTION
		itemPane = new JPanel(new GridBagLayout());
		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Cloud Initialization"));

		GridBagConstraints ci = new GridBagConstraints();
		ci.gridx = 0;
		ci.gridy = 0;

		awsEc2InitButton = new JButton("      INIT      ");
		ci.gridx++;
		itemPane.add(awsEc2InitButton, ci);

		ci.gridx++;
		itemPane.add(new JLabel(
				"                                                        "), ci);

		b_install = new JButton("   INSTALL  ");
		ci.gridx++;
		itemPane.add(b_install, ci);

		small.add(itemPane);

		// CLOUD GLOBAL CONTROL SECTION
		itemPane = new JPanel(new GridBagLayout());
		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Cloud Global Operation"));
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;

		awsEc2StartAllButton = new JButton("    START    ");
		c.gridx++;
		itemPane.add(awsEc2StartAllButton, c);

		c.gridx++;
		itemPane.add(new JLabel("               "), c);

		awsEc2StopAllButton = new JButton("     STOP    ");
		c.gridx++;
		itemPane.add(awsEc2StopAllButton, c);

		c.gridx++;
		itemPane.add(new JLabel("               "), c);

		awsEc2TerminateAllButton = new JButton("TERMINATE");
		c.gridx++;
		itemPane.add(awsEc2TerminateAllButton, c);
		small.add(itemPane);

		// JList panel to present all current instances status
		itemPane = new JPanel();

		// small.add(itemPane);

		itemPane = new JPanel(new GridBagLayout());
		itemPane.setBorder(BorderFactory.createTitledBorder(line,
				"Selected Instances"));
		GridBagConstraints cSel = new GridBagConstraints();

		cSel.gridx = 0;
		cSel.gridy = 0;

		itemPane.add(awsEc2StartButton = new JButton("     start     "), cSel);

		cSel.gridx++;
		itemPane.add(new JLabel("                "), cSel);

		cSel.gridx++;
		itemPane.add(awsEc2StopButton = new JButton("     stop    "), cSel);

		cSel.gridx++;
		itemPane.add(new JLabel("               "), cSel);

		cSel.gridx++;
		itemPane.add(awsEc2TerminateButton = new JButton(" terminate "), cSel);

		small.add(itemPane);

		// itemPane = new JPanel(new BorderLayout());
		// itemPane.add(new JLabel(" "));
		// small.add(itemPane);
		// itemPane = new JPanel(new BorderLayout());
		// itemPane.add(new JLabel(" "));
		// small.add(itemPane);

		// INSTANCES STATUS SECTION
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Instances Status"));
		small.add(itemPane);

		itemPane = new JPanel(new BorderLayout());
		l_instanceStatus = new JList<AwsEC2CheckListItem>(model);
		l_instanceStatus.setCellRenderer(new AwsEC2CheckListRenderer());

		JScrollPane list_pane = new JScrollPane(l_instanceStatus);
		l_instanceStatus.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent event) {
				JList list = (JList) event.getSource();
				// Get index of item clicked
				int index = list.locationToIndex(event.getPoint());
				AwsEC2CheckListItem item = (AwsEC2CheckListItem) list
						.getModel().getElementAt(index);
				// Toggle selected state
				item.setSelected(!item.isSelected());
				// Repaint cell
				list.repaint(list.getCellBounds(index, index));
				if (item.isSelected()) {
					System.out.println(item.toString());
				}
				awsEC2AutoRefresh.stop();
				awsEc2RefreshButton.setEnabled(true);
				awsEc2StopRefreshButton.setEnabled(false);
			}
		});
		itemPane.add(list_pane);
		small.add(itemPane);

		// AWS EC2 REFRESH SECTION
		itemPane = new JPanel();
		itemPane.add(new JLabel("Refresh  "));

		itemPane.add(awsEc2StopRefreshButton = new JButton("Stop"));
		itemPane.add(new JLabel("  "));

		itemPane.add(awsEc2RefreshButton = new JButton("Start"));
		small.add(itemPane);

		// // ADD POWER BY NITRC CE AND AWS EC2
		URL nitrcceUrl = PlaceHolder.class.getResource("nitrc_aws_update.png");
		ImageIcon image1 = new ImageIcon(nitrcceUrl);

		JLabel labelNitrc = new JLabel("", image1, JLabel.CENTER);
		//
		// URL awsEc2Url = PlaceHolder.class.getResource("awsec2.png");
		// ImageIcon image2 = new ImageIcon(awsEc2Url);
		//
		//
		// JLabel labelAws = new JLabel("", image2, JLabel.CENTER);
		//
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(labelNitrc, BorderLayout.CENTER);
		// itemPane.add(labelAws, BorderLayout.EAST);
		small.add(itemPane);

		// cb_Region.addActionListener(this);
		b_install.addActionListener(this);
		b_checkCredentialValid.addActionListener(this);
		awsEc2InitButton.addActionListener(this);
		awsEc2StopButton.addActionListener(this);
		awsEc2StartButton.addActionListener(this);
		awsEc2TerminateButton.addActionListener(this);
		awsEc2RefreshButton.addActionListener(this);
		awsEc2StopRefreshButton.addActionListener(this);
		awsEc2StartAllButton.addActionListener(this);
		awsEc2StopAllButton.addActionListener(this);
		awsEc2TerminateAllButton.addActionListener(this);
		b_selectKeyPair.addActionListener(this);
		b_createKeyPair.addActionListener(this);
		for (int i = 0; i < rb_ifCreateS3Bucket.length; i++) {
			rb_ifCreateS3Bucket[i].addActionListener(this);
		}
		for (int i = 0; i < rb_ifCreateKeyPair.length; i++) {
			rb_ifCreateKeyPair[i].addActionListener(this);
		}
		for (int i = 0; i < rb_ifCreateSecurityGroup.length; i++) {
			rb_ifCreateSecurityGroup[i].addActionListener(this);
		}
		b_AllSecurityGroup.addActionListener(this);
		b_createSecurityGroup.addActionListener(this);
		b_createS3Bucket.addActionListener(this);
		b_AllS3Bucket.addActionListener(this);
	}

	protected void initEnabledFalse() {
		awsEc2InitButton.setEnabled(false);
		awsEc2StopButton.setEnabled(false);
		awsEc2StartButton.setEnabled(false);
		awsEc2TerminateButton.setEnabled(false);
		awsEc2RefreshButton.setEnabled(false);
		awsEc2StopRefreshButton.setEnabled(false);
		awsEc2StartAllButton.setEnabled(false);
		awsEc2StopAllButton.setEnabled(false);
		awsEc2TerminateAllButton.setEnabled(false);
		b_selectKeyPair.setEnabled(false);
		b_createKeyPair.setEnabled(false);
		b_AllSecurityGroup.setEnabled(false);
		b_AllS3Bucket.setEnabled(false);
		b_install.setEnabled(false);

		for (int i = 0; i < rb_ifCreateS3Bucket.length; i++) {
			rb_ifCreateS3Bucket[i].setEnabled(false);
		}
		for (int i = 0; i < rb_ifCreateKeyPair.length; i++) {
			rb_ifCreateKeyPair[i].setEnabled(false);
		}
		for (int i = 0; i < rb_ifCreateSecurityGroup.length; i++) {
			rb_ifCreateSecurityGroup[i].setEnabled(false);
		}
		tf_s3NewBucket.setEnabled(false);
		b_createS3Bucket.setEnabled(false);
		tf_newKeyPairName.setEnabled(false);
		tf_newSecurityGroup.setEnabled(false);
		b_createSecurityGroup.setEnabled(false);
		tf_SecurityGDescription.setEnabled(false);
		cb_AMI.setEnabled(false);
		cb_AMIType.setEnabled(false);
		sp_numberOfInstances.setEnabled(false);

	}

	protected void setEnabledTrue() {
		awsEc2InitButton.setEnabled(true);
		awsEc2StopButton.setEnabled(false);
		awsEc2StartButton.setEnabled(false);
		awsEc2TerminateButton.setEnabled(false);
		awsEc2StartAllButton.setEnabled(false);
		awsEc2StopAllButton.setEnabled(false);
		awsEc2TerminateAllButton.setEnabled(false);

		b_selectKeyPair.setEnabled(true);

		b_AllSecurityGroup.setEnabled(true);
		b_AllS3Bucket.setEnabled(true);
		for (int i = 0; i < rb_ifCreateS3Bucket.length; i++) {
			rb_ifCreateS3Bucket[i].setEnabled(true);
		}
		rb_ifCreateS3Bucket[1].setSelected(true);
		rb_ifCreateS3Bucket[0].setSelected(false);

		for (int i = 0; i < rb_ifCreateKeyPair.length; i++) {
			rb_ifCreateKeyPair[i].setEnabled(true);
		}

		rb_ifCreateKeyPair[1].setSelected(true);
		rb_ifCreateKeyPair[0].setSelected(false);

		for (int i = 0; i < rb_ifCreateSecurityGroup.length; i++) {
			rb_ifCreateSecurityGroup[i].setEnabled(true);
		}

		rb_ifCreateSecurityGroup[1].setSelected(true);
		rb_ifCreateSecurityGroup[0].setSelected(false);

		cb_AMI.setEnabled(true);
		cb_AMIType.setEnabled(true);
		sp_numberOfInstances.setEnabled(true);
		// still remain false, wait radio button
		b_createKeyPair.setEnabled(false);
		tf_newKeyPairName.setEnabled(false);
		tf_newSecurityGroup.setEnabled(false);
		b_createSecurityGroup.setEnabled(false);
		tf_SecurityGDescription.setEnabled(false);
		awsEc2RefreshButton.setEnabled(false);
		awsEc2StopRefreshButton.setEnabled(false);
		tf_s3NewBucket.setEnabled(false);
		b_createS3Bucket.setEnabled(false);

	}

	protected void init(PipeLayout layout) {
		initEnabledFalse();
		params = layout.getRunParameters();

		// load experiment-specific configs
		InputStream inputStream = null;
		Properties prop = new Properties();
		// Step 1. Make sure if JistAwsEC2.preferences exits
		File inputFile = new File(System.getProperties().getProperty(
				"user.home")
				+ "/JistAwsEc2" + "/JISTAWSEC2.preferences");
		if (!inputFile.exists()) {
			return;
		} else {
			try {
				// String propertiesPath = MyUtils.getPropertiesPath(layout);
				// MyUtils.preparePropertiesFile(propertiesPath);
				// fis = new FileInputStream(propertiesPath);
				// prop.load(fis);

				inputStream = new FileInputStream(System.getProperties()
						.getProperty("user.home")
						+ "/JistAwsEc2"
						+ "/JISTAWSEC2.preferences");
				prop.load(inputStream);

				Properties props = System.getProperties();
				str_keyPairFolder = props.getProperty("user.home")
						+ "/JistAwsEc2";
				createDir(str_keyPairFolder);
				if (prop.getProperty("AllCurrentInstanceId") == null) {
					jistAwsEC2 = new JistAwsEC2(
							prop.getProperty("accessKeyId"),
							prop.getProperty("secretAccessKey"),
							prop.getProperty("region"));
					jistAwsEC2.setRegion(prop.getProperty("region"));
					tf_accessKeyID.setText(prop.getProperty("accessKeyId"));
					pwf_secretAccessKey.setText(prop
							.getProperty("secretAccessKey"));
					cb_Region.setSelectedItem(prop.getProperty("region"));
					// initEnabledFalse();
				} else {
					// RELOAD the JistAwsEC2 class instance
					jistAwsEC2 = new JistAwsEC2(
							prop.getProperty("accessKeyId"),
							prop.getProperty("secretAccessKey"),
							prop.getProperty("region"));
					jistAwsEC2.setRegion(prop.getProperty("region"));

					jistAwsS3 = new JistAwsS3(prop.getProperty("accessKeyId"),
							prop.getProperty("secretAccessKey"),
							prop.getProperty("regionS3"));
					jistAwsS3.setS3Region(prop.getProperty("regionS3"));
					jistAwsS3.setS3Bucket(prop.getProperty("bucket"));

					jistAwsEC2.setKeyPairName(prop.getProperty("keyPairName"));
					jistAwsEC2.setKeyPairAbsolutePath(prop
							.getProperty("keyPairPath"));
					jistAwsEC2.setSecurityGroupName(prop
							.getProperty("securityGroup"));
					jistAwsEC2.setImageId(prop.getProperty("AMI"));
					jistAwsEC2.setInstanceType(prop.getProperty("AMIType"));
					jistAwsEC2.setMaxInstanceNum(prop
							.getProperty("MachineNumber"));

					String[] curInstanceId = prop.getProperty(
							"AllCurrentInstanceId").split(":");
					Set<String> tmpCurId = new HashSet<String>();
					for (int i = 0; i < curInstanceId.length; ++i) {
						String woca = curInstanceId[i].replace(" ", "");
						tmpCurId.add(woca);
						// System.out.println(woca);
					}

					// RELOAD the Cloud panel information
					setEnabledTrue();
					tf_accessKeyID.setText(prop.getProperty("accessKeyId"));
					pwf_secretAccessKey.setText(prop
							.getProperty("secretAccessKey"));
					cb_Region.setSelectedItem(prop.getProperty("region"));

					if (prop.getProperty("ifCreateBucket").equals("no")) {
						rb_ifCreateS3Bucket[1].setSelected(true);
						rb_ifCreateS3Bucket[1].setEnabled(true);
						rb_ifCreateS3Bucket[0].setSelected(false);
						rb_ifCreateS3Bucket[0].setEnabled(false);
						this.importAllBucket();
						cb_SecurityGroup.setSelectedItem(prop
								.getProperty("bucket"));
					}
					if (prop.getProperty("ifCreateBucket").equals("yes")) {
						rb_ifCreateS3Bucket[0].setSelected(true);
						rb_ifCreateS3Bucket[0].setEnabled(true);
						rb_ifCreateS3Bucket[1].setSelected(false);
						rb_ifCreateS3Bucket[1].setEnabled(false);
						this.tf_s3NewBucket.setText(prop.getProperty("bucket"));
					}

					if (prop.getProperty("ifCreateKeyPair").equals("no")) {
						rb_ifCreateKeyPair[1].setSelected(true);
						rb_ifCreateKeyPair[1].setEnabled(true);
						rb_ifCreateKeyPair[0].setSelected(false);
						rb_ifCreateKeyPair[0].setEnabled(false);
						tf_oldKeyPairPath.setText(prop
								.getProperty("keyPairPath"));
					}
					if (prop.getProperty("ifCreateKeyPair").equals("yes")) {
						rb_ifCreateKeyPair[0].setSelected(true);
						rb_ifCreateKeyPair[0].setEnabled(true);
						rb_ifCreateKeyPair[1].setSelected(false);
						rb_ifCreateKeyPair[1].setEnabled(false);
						tf_newKeyPairName.setText(prop
								.getProperty("keyPairName"));
					}
					if (prop.getProperty("ifCreateSG").equals("no")) {
						rb_ifCreateSecurityGroup[1].setSelected(true);
						rb_ifCreateSecurityGroup[1].setEnabled(true);
						rb_ifCreateSecurityGroup[0].setSelected(false);
						rb_ifCreateSecurityGroup[0].setEnabled(false);
						importAllSeurityGroup();
						cb_SecurityGroup.setSelectedItem(prop
								.getProperty("securityGroup"));
					}
					if (prop.getProperty("ifCreateSG").equals("yes")) {
						rb_ifCreateSecurityGroup[0].setSelected(true);
						rb_ifCreateSecurityGroup[0].setEnabled(true);
						rb_ifCreateSecurityGroup[1].setSelected(false);
						rb_ifCreateSecurityGroup[1].setEnabled(false);
						tf_newSecurityGroup.setText(prop
								.getProperty("securityGroup"));
						tf_SecurityGDescription.setText(prop
								.getProperty("securityGroupDescription"));
					}
					cb_AMI.setSelectedItem(prop.getProperty("AMI"));
					cb_AMIType.setSelectedItem(prop.getProperty("AMIType"));
					// sp_numberOfInstances.setValue(Integer.parseInt(prop.getProperty("MachineNumer")));

					jistAwsEC2.setCurrentInstancesId(tmpCurId);
					if (!tmpCurId.isEmpty()) {
						// System.out.println(tmpCurId.size());
						// for(String s : tmpCurId){
						// System.out.println("woca"+s+"woca");
						// }
						refreshCloudListPanel();
						awsEC2AutoRefresh.start();
						awsEc2InitButton.setEnabled(false);
						awsEc2StopRefreshButton.setEnabled(true);
						awsEc2StopButton.setEnabled(true);
						awsEc2StartButton.setEnabled(true);
						awsEc2TerminateButton.setEnabled(true);
						awsEc2StartAllButton.setEnabled(true);
						awsEc2StopAllButton.setEnabled(true);
						awsEc2TerminateAllButton.setEnabled(true);
					} else {
						System.out.println("woca");
						initEnabledFalse();
						// awsEc2InitButton.setEnabled(true);
					}
				}

				numOfCompleteInstall = 0;

			} catch (Exception ex) {
				ex.printStackTrace();

			} finally {
				if (inputStream != null) {
					try {
						inputStream.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
	}

	// For Server status List
	static class AwsEC2CheckListRenderer extends JCheckBox implements
			ListCellRenderer {
		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean hasFocus) {
			setEnabled(list.isEnabled());
			setSelected(((AwsEC2CheckListItem) value).isSelected());
			setFont(list.getFont());
			setBackground(list.getBackground());
			setForeground(list.getForeground());
			setText(value.toString());
			return this;
		}
	}

	// For Server status List
	static class AwsEC2CheckListItem {
		private String label;
		private boolean isSelected = false;

		public AwsEC2CheckListItem(String label) {
			this.label = label;
		}

		public boolean isSelected() {
			return isSelected;
		}

		public void setSelected(boolean isSelected) {
			this.isSelected = isSelected;
		}

		public String toString() {
			return label;
		}
	}

}