package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ScrollPaneConstants;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.jcraft.jsch.JSchException;

import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout.RunParameters;
import edu.jhu.ece.iacl.jist.pipeline.gui.resources.PlaceHolder;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.jistcloud.JistAwsEC2;
import edu.vanderbilt.masi.jistcloud.JistAwsInitConfig;
import edu.vanderbilt.masi.jistcloud.JistAwsS3;
import edu.vanderbilt.masi.jistcloud.MyUtils;

/**
 * AWS EC2 control panel. It can initialize multiple instances Stop instances
 * Re-start instances Terminate instances
 * 
 * @author Shunxing Bao 2015 summer
 */
public class AwsInstallProgressBarPanel extends JPanel implements ActionListener {
	/**
     * 
     */
	private static final long serialVersionUID = 1L;
	
	

	/** The layout. */
	private PipeLayout layout;
	private JistAwsEC2 jistAwsEC2;

	private String EC2_USER = "ec2-user";
	/**
	 * GUI SECTION
	 */

	// CREDENTIAL

	private static JProgressBar progressBar;
	private JButton button;

	
	static AwsInstallProgressBarPanel _this;

	 public AwsInstallProgressBarPanel (){
	       _this = this;
	    }

	/**
	 * Constructor.
	 * 
	 * @param layout
	 *            layout
	 * @throws BadLocationException
	 */
	public AwsInstallProgressBarPanel(PipeLayout layout, JistAwsEC2 jistAwsEC2) throws BadLocationException {
		super();
		this.jistAwsEC2 = jistAwsEC2;
		createPane();
		this.layout = layout;
		
		
	}

	/**
	 * Show dialog.
	 * 
	 * @param runnable
	 *            the comp
	 * @param layout
	 *            the layout
	 * @return true, if successful
	 * @throws BadLocationException
	 */

	public static boolean showDialog(Component comp, PipeLayout layout, JistAwsEC2 jistAwsEC2)
			throws BadLocationException {
		AwsInstallProgressBarPanel panel = new AwsInstallProgressBarPanel(layout, jistAwsEC2);

		// while (true) {
		// Object[] options = { "Done", "Cancel" };
		Object[] options = { "Done" };
		int n = JOptionPane.showOptionDialog(comp, panel, "Cloud install progress ["
				+ layout.getTitle() + "]", JOptionPane.OK_CANCEL_OPTION,
				JOptionPane.PLAIN_MESSAGE, null, options, options[0]);
		System.out.println("");
		// save configs
		if (n == 0) {
			JistLogger.logOutput(JistLogger.INFO,
					"> To save experiment-specific configs...");
		} else {
			return true;
		}

		return true;
	}
	

	@Override
	public void actionPerformed(ActionEvent evt) {
		// TODO Auto-generated method stub
		new Thread(new thread1()).start(); 
		button.setEnabled(false);
}
	

	/**
	 * Create panel to display preferences.
	 * 
	 * @throws BadLocationException
	 * @throws IOException
	 */
	protected void createPane() throws BadLocationException {
		int TEXT_WIDTH = 50;
		int SMALL_TEXT_WIDTH = TEXT_WIDTH - 10;

		this.setLayout(new BorderLayout());
		JPanel small = new JPanel();
		BoxLayout layout = new BoxLayout(small, BoxLayout.PAGE_AXIS);
		small.setLayout(layout);
		this.add(small, BorderLayout.NORTH);
		this.setPreferredSize(new Dimension(100, 20));

		JPanel itemPane = new JPanel(new BorderLayout());

		// Access key ID
		itemPane = new JPanel(new BorderLayout());
		progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        itemPane.add(button = new JButton("install"), BorderLayout.WEST);
		itemPane.add(progressBar,
				BorderLayout.EAST);
		small.add(itemPane);
		
		button.addActionListener(this);
	}
	
	public static class thread1 implements Runnable{
		public void run(){
			progressBar.setValue(0);
			int originValue = 0;
			while(progressBar.getValue()<100){
				
				double percentage = (AwsEC2DashboardPanel.numOfCompleteInstall)/(AwsEC2DashboardPanel.totalNumOfMachine)*100;
				if((int)percentage > originValue)
				{
					for(int i = originValue; i<=(int)percentage;++i){
						progressBar.setValue((int)percentage);
						if(percentage>99.0){
							progressBar.setValue(100);
						}
						 //Set value
						progressBar.repaint(); //Refresh graphics
//						try{Thread.sleep(250);}
//						catch (InterruptedException err){}
					}
					originValue = (int)percentage;
				} else {
					try{Thread.sleep(1000);} //Sleep 50 milliseconds
					catch (InterruptedException err){}
				}

			}
		}
	}


}