package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;

import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.PipeLibrary;

public class GlobalPreferencePanel extends JPanel implements ActionListener {

	/** The browse input. */
	private JButton browseInput;

	/** The direct input. */
	private JTextField dirInput;	
	
	/** The browse output. */
	private JButton browseJreOutput;

	/** The browse output. */
	private JButton browseLibraryOutput;
	
	/** The browse output. */
	private JButton browseExternalLibraryOutput;
	
	/** The browse output for external modules. */
	private JButton browseExtOutput;
	
	/** The browse hypervisor template location. */
	private JButton browseHyperLoc;
	
	/** The use relative. */
	private JCheckBox useRelative;	

	/** The jre location. */
	private JTextField jreField;	
	
	/** The lib location. */
	private JTextField libField;
	
	/** The external lib location. */
	private JTextField extLibField;
	
	/** The external module location. */
	private JTextField extModDirField;
	
	/**The Hypervisor preferences location */
	private JTextField hyperField;
	
	/** The preferred extension */
	private JComboBox prefext;
	
	/** The preferred extension */
	private JComboBox prefcomp;
	
	private JSpinner debugLevelField;
	
	private JSpinner layoutPrefField;
	/**The Maps Preferences */
	private JistPreferences prefs;
	
	public GlobalPreferencePanel(JistPreferences maps) {
		super();
		createPane();
		init(maps);
	}

	/**
	 * Show dialog.
	 * 
	 * @param comp
	 *            the comp
	 * @return true, if successful
	 */
	public static boolean showDialog(Component comp, JistPreferences maps) {
		GlobalPreferencePanel panel = new GlobalPreferencePanel(maps);
		while (true) {
			int n = JOptionPane.showConfirmDialog(comp, panel, "Global Preferences",
					JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
			if (n == 0) {
				if (panel.update()) {
					return true;
				} else {
					JOptionPane.showMessageDialog(comp, "Invalid parameter.", "Run Parameter Error",
							JOptionPane.ERROR_MESSAGE);
				}
			} else {
				return false;
			}
		}
	}	

	/**
	 * Update.
	 * 
	 * @return true, if successful
	 */
	protected boolean update() {
		
		// flag to make sure we don't rebuild twice
		boolean need_rebuilding = false;
		
		//Save JRE
		String oldJre = JistPreferences.getPreferences().getJre();
		String newJre = jreField.getText();
		if(newJre!=null&&!newJre.equals(oldJre)){
			JistPreferences.getPreferences().setJre(newJre);			
		}
				
		//Save Preferred Extension
		JistPreferences.getPreferences().setPreferredExtension((String) prefext.getSelectedItem());
		JistPreferences.getPreferences().setPreferredCompression((String) prefcomp.getSelectedItem());

		//Save Library 
		File oldDir = PipeLibrary.getInstance().getLibraryPath();
		File newDir = new File(libField.getText());
		if (newDir!=null&&!newDir.equals(oldDir)){
			need_rebuilding = true;
			PipeLibrary.getInstance().setLibraryPath(newDir);
		}
		
		//Save External Library Library 
		File oldDirJSON = JistPreferences.getPreferences().getExternalJSONModuleDirectory();
		File newDirJSON = new File(extLibField.getText());
		if (newDirJSON!=null&&!newDirJSON.equals(oldDirJSON)){
			need_rebuilding = true;
			JistPreferences.getPreferences().setExternalModuleDirectoryJSON(newDirJSON);
		}
		
		//Save Hypervisor Template Location 
		oldDir = prefs.getGridEngineTemplate();
		newDir = new File(hyperField.getText());
		if (newDir!=null&&!newDir.equals(oldDir)){
			prefs.setGridEngineTemplate(newDir);
		}
		
		//Save Ext Module location
		File oldExtDir = JistPreferences.getPreferences().getExternalModuleDirectory();
		File newExtDir = new File(extModDirField.getText());
		if ((newExtDir!=null) && (!newExtDir.equals(oldExtDir))) {
			need_rebuilding = true;
			JistPreferences.getPreferences().setExternalModuleDirectory(newExtDir);
		}
		
		// set the debug level
		int selected = 0;
		for(String arg : JistPreferences.debugLevels) {
			if(arg.equals(debugLevelField.getValue().toString()))
				break;
			selected++;
		}
		
		JistPreferences.getPreferences().setDebugLevel(selected);
		JistPreferences.getPreferences().setDefaultLayoutExtension(layoutPrefField.getValue().toString());
		JistPreferences.savePreferences();
		
		// rebuild if necessary
		if (need_rebuilding)
			if (PipelineLayoutTool.isInitialized())
				PipelineLayoutTool.getInstance().getModulePanel().rebuild();
				
		return true;
	}
	
	
	/**
	 * Create panel to display preferences.
	 */
	protected void createPane() {
		this.setLayout(new BorderLayout());
		JPanel small = new JPanel();
		BoxLayout layout = new BoxLayout(small, BoxLayout.PAGE_AXIS);
		small.setLayout(layout);
		this.add(small, BorderLayout.NORTH);
		JPanel itemPane = new JPanel(new BorderLayout());

		JPanel relativePane = new JPanel(new BorderLayout());
		relativePane.add(dirInput = new JTextField(20), BorderLayout.CENTER);
		relativePane.add(browseInput = new JButton("Browse"), BorderLayout.EAST);
		relativePane.add(useRelative = new JCheckBox("Use Relative Path"), BorderLayout.SOUTH);
		useRelative.setEnabled(false);
		small.add(itemPane);

		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("JRE Location "), BorderLayout.WEST);
		itemPane.add(jreField = new JTextField(20), BorderLayout.CENTER);
		itemPane.add(browseJreOutput = new JButton("Browse"), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Library Location "), BorderLayout.WEST);
		itemPane.add(libField = new JTextField(20), BorderLayout.CENTER);
		itemPane.add(browseLibraryOutput = new JButton("Browse"), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("External JSON Library Location "), BorderLayout.WEST);
		itemPane.add(extLibField = new JTextField(20), BorderLayout.CENTER);
		itemPane.add(browseExternalLibraryOutput = new JButton("Browse"), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("External Module Location"), BorderLayout.WEST);
		itemPane.add(extModDirField = new JTextField(20), BorderLayout.CENTER);
		itemPane.add(browseExtOutput = new JButton("Browse"), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Grid Template Location "), BorderLayout.WEST);
		itemPane.add(hyperField = new JTextField(20), BorderLayout.CENTER);
		itemPane.add(browseHyperLoc = new JButton("Browse"), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Preferred Extension"), BorderLayout.WEST);
		Vector<String> extensions = ImageDataReaderWriter.getInstance().getExtensionFilter().getExtensions();
		itemPane.add(prefext = new JComboBox(extensions), BorderLayout.EAST);		
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Preferred Compression"), BorderLayout.WEST);
		itemPane.add(prefcomp = new JComboBox(ImageDataReaderWriter.getInstance().getCompressionOptions()), BorderLayout.EAST);
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Debug Level "), BorderLayout.WEST);
		
		SpinnerListModel debugModel = new SpinnerListModel(JistPreferences.debugLevels);
		itemPane.add(debugLevelField = new JSpinner(debugModel), BorderLayout.CENTER);		
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Layout Format"), BorderLayout.WEST);
		SpinnerListModel layoutPref = new SpinnerListModel(JistPreferences.layoutExtensions);
		itemPane.add(layoutPrefField = new JSpinner(layoutPref), BorderLayout.CENTER);		
		small.add(itemPane);

		browseInput.addActionListener(this);
		browseJreOutput.addActionListener(this);
		browseLibraryOutput.addActionListener(this);
		browseExternalLibraryOutput.addActionListener(this);
		browseExtOutput.addActionListener(this);
		browseHyperLoc.addActionListener(this);
		useRelative.addActionListener(this);
	}		
	
	public void actionPerformed(ActionEvent evt) {
		if (evt.getSource() == browseInput) {
			JistPreferences.getPreferences().addFileToHistory(new File(dirInput.getText()));
			JistPreferences.savePreferences();
		}
		
		if (evt.getSource() == browseJreOutput) {
			File oldJre = new File(JistPreferences.getPreferences().getJre());
			File newJre = JistPreferences.askForJavaExecutable(oldJre);
			if (newJre != null) {
				jreField.setText(newJre.getAbsolutePath());
			}
		}
		if (evt.getSource() == browseLibraryOutput) {
			File oldDir = PipeLibrary.getInstance().getLibraryPath();
			File newDir = PipeLibrary.askForLibraryDirectory(oldDir);
			if(newDir!=null){
				libField.setText(newDir.getAbsolutePath());
			}
		}
		if (evt.getSource() == browseExternalLibraryOutput) {
			File oldDir = JistPreferences.getPreferences().getExternalJSONModuleDirectory();
			File newDir = JistPreferences.askForExternalJSONLib(oldDir);
			if(newDir!=null){
				extLibField.setText(newDir.getAbsolutePath());
			}
		}
		if (evt.getSource() == browseExtOutput) {
			File oldDir = JistPreferences.getPreferences().getExternalModuleDirectory();
			File newDir = PipeLibrary.askForLibraryDirectory(oldDir);
			if(newDir!=null){
				extModDirField.setText(newDir.getAbsolutePath());
			}
		}
		
		if (evt.getSource() == browseHyperLoc) {
			File oldDir = JistPreferences.getPreferences().getGridEngineTemplate();
			File newDir = JistPreferences.askForHypervisorTemplate(oldDir);
			if(newDir!=null){
				hyperField.setText(newDir.getAbsolutePath());
			}
		}
	}
		
	/**
	 * Initialize preference panel for layout.
	 * 
	 */
	protected boolean init(JistPreferences pref) {
		prefs = pref;
		
		//Find index of default
		Vector<String> extensions = ImageDataReaderWriter.getInstance().getExtensionFilter().getExtensions();
		int i = 0;
		while((i < extensions.size()) && (extensions.get(i).compareTo(prefs.getPreferredExtension()) != 0))
		{
			i++;
		}
		prefext.setSelectedIndex(i);
		
		
		Vector<String> compressions = ImageDataReaderWriter.getInstance().getCompressionOptions();
		i = 0;
		while((i < compressions.size()) && (compressions.get(i).compareTo(prefs.getPreferredCompression()) != 0))
		{
			i++;
		}
		prefcomp.setSelectedIndex(i);
		libField.setText(PipeLibrary.getInstance().getLibraryPath().getAbsolutePath());
		
		//Check to make sure that the external json path isnt null since it is not required for run.
//		if (JistPreferences.getPreferences().getExternalJSONModuleDirectory().getAbsolutePath()==null){
//			extLibField.setText("");
//		}else{
//			extLibField.setText(JistPreferences.getPreferences().getExternalJSONModuleDirectory().getAbsolutePath());		
//		}
		
		if(JistPreferences.getPreferences().getExternalModuleDirectory()!=null){
			extModDirField.setText(JistPreferences.getPreferences().getExternalModuleDirectory().getAbsolutePath());
		}
		
		//Initialize JRE
		jreField.setText(prefs.getJre());
		File f = new File(prefs.getJre());
		
		File loc = prefs.getGridEngineTemplate();
		if(loc != null && loc.exists()){
			hyperField.setText(loc.getAbsolutePath());
		} else {
			hyperField.setText("");
		}
				
		debugLevelField.setValue(JistPreferences.debugLevels[prefs.getDebugLevel()]);
		try {
		layoutPrefField.setValue(JistPreferences.getPreferences().getDefaultLayoutExtension());
		} catch (IllegalArgumentException e){};
		
		return f.exists();
	}
}