/**

 */
package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;

import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.OutputViewerPreferences;

/**
 * Output Viewer Preference Panel
 * @author Muqun Li(muqun.li@vanderbilt.edu)
 *
 */
public class OutputViewerPreferencePanel extends JPanel implements
		ActionListener {

	
	/** The preferred viewer according to datatype */
	private JComboBox prefviewer;
	JButton setPreview;
	JButton setAdvancedViewer;
	JButton setCustomViewer;
	JButton updatePref;
	
	static String ParamType;
	/** The viewer location. */
	private JTextField customField;
	private JSpinner viewerQuaField;
	/**The Maps Preferences */
	private OutputViewerPreferences outviewerprefs;
	
	
	public OutputViewerPreferencePanel(String Param, OutputViewerPreferences maps) {
		super();
		ParamType = Param;
		createPane();
		init(maps);
	}
	
	/**
	 * Show dialog.
	 * 
	 * @param comp
	 *            the comp
	 * @param layout
	 *            the layout
	 * @return true, if successful
	 */
	public static boolean showDialog(Component comp, OutputViewerPreferences prefs) {
		OutputViewerPreferencePanel panel = new OutputViewerPreferencePanel(ParamType, prefs);
		while (true) {
			int n = JOptionPane.showConfirmDialog(comp, panel, "Output Viewer Preferences",
					JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
			if (n == 0) {
				if (panel.update()) {
					return true;
				} else {
					JOptionPane.showMessageDialog(comp, "Invalid parameter.", "Run Parameter Error",
							JOptionPane.ERROR_MESSAGE);
				}
			} else {
				return false;
			}
		}
	}
	
	/**
	 * Update.
	 * 
	 * @return true, if successful
	 */
	protected boolean update() {
		//Save JRE
		//String oldJre = OutputViewerPreferences.getPreferences().getJre();
		//String newJre = jreField.getText();
		//if(newJre!=null&&!newJre.equals(oldJre)){
		//	OutputViewerPreferences.getPreferences().setJre(newJre);			
		//}
		
		//Save Preferred Extension
		//OutputViewerPreferences.getPreferences().setPreferredViewer(DataType.VOLUME,(String) prefviewer.getSelectedItem());
		JistPreferences.getPreferences().setPreferredViewers(ParamType+" "+viewerQuaField.getValue().toString(),customField.getText());
		return true;
	}
	
	
	/**
	 * Create panel to display preferences.
	 */
	protected void createPane() {
		
		prefviewer = new JComboBox();
		this.setLayout(new BorderLayout());
		JPanel small = new JPanel();
		BoxLayout layout = new BoxLayout(small, BoxLayout.PAGE_AXIS);
		small.setLayout(layout);
		this.add(small, BorderLayout.NORTH);
		JPanel itemPane = new JPanel(new FlowLayout());
		JPanel itemPane2 = new JPanel(new BorderLayout());
		
		itemPane.add(new JLabel("User-Customized Viewer Location "));
		itemPane.add(customField = new JTextField(20));
		itemPane.add(setCustomViewer = new JButton("Browse"));
		small.add(itemPane);
		
		//useRelative.setEnabled(false);
		//small.add(relativePane);
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Preferred Viewer"), BorderLayout.WEST);
		//Vector<String> volViewer = ImageDataReaderWriter.getInstance().getExtensionFilter().getExtensions();
		//Vector<String> Viewers = new Vector<String>();; 
		//Viewers.add("Preset Viewer(preview quality)");
		//Viewers.add("Preset Viewer(advanced quality)");
		//Viewers.add("Select Viewer(user-customized)");
		//itemPane.add(prefviewer = new JComboBox(Viewers), BorderLayout.EAST);		
		//small.add(itemPane);
		String[] viewQua = new String[]{"Preview","Advanced","Custom"};
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(new JLabel("Preferred Viewer Quality"), BorderLayout.WEST);
		SpinnerListModel vqModel = new SpinnerListModel(viewQua);
		itemPane.add(viewerQuaField = new JSpinner(vqModel), BorderLayout.CENTER);		
		small.add(itemPane);
		
		itemPane = new JPanel(new BorderLayout());
		itemPane.add(updatePref = new JButton("update"), BorderLayout.CENTER);
		updatePref.setSize(30,10);
		small.add(itemPane);
		setCustomViewer.addActionListener(this);
		updatePref.addActionListener(this);
	}		
	

		
	/**
	 * Initialize preference panel for layout.
	 * 
	 */
	protected boolean init(OutputViewerPreferences outviewerpref) {
		outviewerprefs = outviewerpref;
		prefviewer.setSelectedIndex(-1);
		//prefviewer[1].setSelectedIndex(-1);
		customField.setText("");
		return true;
	
}
	/** The preferred extension */
	//private JComboBox prefcomp;
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent evt) {
		// TODO Auto-generated method stub
		if (evt.getSource() == setAdvancedViewer) {
			prefviewer.setSelectedIndex(1);
			//prefviewer[1].setSelectedIndex(1);
		}
		
		if (evt.getSource() == setCustomViewer) {
			//prefviewer[0].setSelectedIndex(2);
			//prefviewer[1].setSelectedIndex(2);
			//File oldViewer = new File(OutputViewerPreferences.getPreferences().askForCustomViewer());
			File newViewer = OutputViewerPreferences.askForCustomViewer();
			if (newViewer != null) {
				customField.setText(newViewer.getAbsolutePath());
			}
		}
		if (evt.getSource() == setPreview) {
			prefviewer.setSelectedIndex(0);
			//prefviewer[1].setSelectedIndex(0);
		}
		if (evt.getSource() == updatePref) {
			update();
			//prefviewer[1].setSelectedIndex(1);
		}
	}

}
