package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.LayoutManager;

import javax.swing.BoxLayout;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurfaceCollection;
import edu.jhu.ece.iacl.jist.pipeline.view.output.ParamOutputView;

/**
* Param Surface Collection Output View
* @author Muqun Li(muqun.li@vanderbilt.edu)
*/
public class ParamSurfaceCollectionOutputView extends ParamOutputView {
	public ParamSurfaceCollectionOutputView(ParamSurfaceCollection param) {
		this.param = param;
		for (ParamFile vol : param.getParameters()) {
			LayoutManager layout = new BoxLayout(this, BoxLayout.Y_AXIS);
			this.setLayout(layout);
			add(vol.getOutputView());
		}
	}

	/**
	 * Update volume parameters.
	 */
	public void update() {
		for (ParamFile p : ((ParamSurfaceCollection) param).getParameters()) {
			p.getOutputView().update();
		}
	}
}

