/**
 * 
 */
package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.WindowConstants;
/**
 * ProcessOutputInfo Frame
 * @author Muqun Li (muqun.li@vanderbilt.edu)
 *
 */
public class ProcessOutputInfoFrame extends JFrame implements ActionListener{
/**
* Worker to load stdout/stderr in a safe threaded way.
* 
* @author Blake Lucas (bclucas@jhu.edu)
*/
	protected class FileReaderWorker extends SwingWorker<Void, Void> {
		
		/** The text area. */
		JTextArea textArea;
		
		/** The file. */
		File file;
		
		/** The monitor. */
		ProgressMonitor monitor;

		/**
		 * Instantiates a new file reader worker.
		 * 
		 * @param parent
		 *            the parent
		 * @param textArea
		 *            the text area
		 * @param f
		 *            the f
		 */
		public FileReaderWorker(Component parent, JTextArea textArea, File f) {
			this.textArea = textArea;
			this.file = f;
			monitor = new ProgressMonitor(parent, "Reading file " + f.getAbsolutePath(), "Reading...", 0, 100);
		}

		/* (non-Javadoc)
		 * @see javax.swing.SwingWorker#doInBackground()
		 */
		protected Void doInBackground() throws Exception {
			BufferedReader in;
			textArea.setText("");
			try {
				// Create input stream from file
				in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
				StringBuffer buff = new StringBuffer();
				String str;
				// Read file as string
				int line = 0;
				monitor.setProgress(0);
				while ((str = in.readLine()) != null) {
					if (monitor.isCanceled()) {
						break;
					}
					monitor.setProgress(50);
					monitor.setNote("Reading Line " + (++line));
					textArea.append(str + "\n");
				}
				monitor.setProgress(100);
				in.close();
			} catch (Exception e) {
				System.err.println(getClass().getCanonicalName()+"Error occured while reading parameter file:\n" + e.getMessage());
				e.printStackTrace();
				return null;
			}
			textArea.setCaretPosition(textArea.getText().length());
			monitor.close();
			return null;
		}
	}

	/**
	 * Split plane to display stdout and stderr.
	 * 
	 * @author Blake Lucas (bclucas@jhu.edu)
	 */
	protected class FileText extends JSplitPane {
		
		/** The bottom text area. */
		public JTextArea topTextArea, bottomTextArea;
		
		/** The bottom file. */
		public File topFile, bottomFile;
		
		/** The tree*/
		//public JTree 

		/**
		 * Instantiates a new file text.
		 * 
		 * @param tf
		 *            the tf
		 * @param bf
		 *            the bf
		 */
		public FileText(JTree ancestorTree, JTree decendantTree) {
			super(JSplitPane.VERTICAL_SPLIT);
			JScrollPane topScroll, bottomScroll;
			setTopComponent(topScroll = new JScrollPane());
			setBottomComponent(bottomScroll = new JScrollPane());
			setDividerLocation(300);
			setOneTouchExpandable(true);
			setResizeWeight(0.5);
	
			topScroll.setViewportView(ancestorTree);
			ancestorTree.updateUI();	
			bottomScroll.setViewportView(decendantTree);
			decendantTree.updateUI();
			topScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("ANCESTOR"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			bottomScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("DECENDANT"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			refresh();
		}
		/**
		 * Instantiates a new file text.
		 * 
		 * @param tf
		 *            the tf
		 * @param bf
		 *            the bf
		 */
		public FileText(File outputFile) {
			super(JSplitPane.VERTICAL_SPLIT);
			JScrollPane topScroll, bottomScroll;
			setTopComponent(topScroll = new JScrollPane());
			setBottomComponent(bottomScroll = new JScrollPane());
			setDividerLocation(300);
			setOneTouchExpandable(true);
			setResizeWeight(0.5);
			this.topFile = outputFile;
			topTextArea = new JTextArea();
			topScroll.setViewportView(topTextArea);
			topTextArea.setEditable(false);

			topScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("STDOUT"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			bottomScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("STDERR"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			refresh();
		}


		/**
		 * Refresh.
		 */
		public void refresh() {
			FileReaderWorker topWorker = new FileReaderWorker(this, topTextArea, topFile);
			topWorker.execute();
//			FileReaderWorker bottomWorker = new FileReaderWorker(this, bottomTextArea, bottomFile);
//			bottomWorker.execute();
		}
	}

	/** The tab pane. */
	JTabbedPane tabPane;
	
	/** The bottom tab pane. */
	JTabbedPane bottomTabPane;
	
	/** The refresh button. */
	JButton refreshButton;
	/**
	 * @throws HeadlessException
	 */
	public ProcessOutputInfoFrame() throws HeadlessException {
		// TODO Auto-generated constructor stub
		super("Output Information");
		this.setLayout(new GridLayout(1, 0));
		this.setPreferredSize(new Dimension(600, 600));
		this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		this.setVisible(false);
		this.pack();
//		setIconImage(Toolkit.getDefaultToolkit().getImage(
//				PlaceHolder.class.getResource("zoom.gif"))); /**SET ICON HERE**/
	}
	/**
	 * @throws HeadlessException
	 */
	public void clear(){
		// TODO Auto-generated constructor stub
	
		this.setLayout(new GridLayout(1, 0));
		this.setPreferredSize(new Dimension(600, 600));
		this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		this.setVisible(false);
		this.pack();
//		setIconImage(Toolkit.getDefaultToolkit().getImage(
//				PlaceHolder.class.getResource("zoom.gif"))); /**SET ICON HERE**/
	}
	/**
	 * Load stdout and stderr from specified files.
	 * 
	 * @param name
	 *            name of frame
	 * @param tf
	 *            stdout file
	 * @param bf
	 *            stderr file
	 */
	public void load(String name, JTree ancestorTree, JTree decendantTree) {
		if (!this.isVisible()) {
			tabPane.removeAll();
		}
		this.setVisible(true);
	//	FileText text;
	//	tabPane.addTab(name, text = new FileText(ancestorTree, decendantTree));
	}
	
	public void load(String name, File outputFile) {
		if (!this.isVisible()) {
			tabPane.removeAll();
		}

		this.setVisible(true);
		FileText text;
		tabPane.addTab(name, text = new FileText(outputFile));
//		FileReaderWorker topWorker = new FileReaderWorker(this, topTextArea, outputFile);
//		topWorker.execute();
	}
	/**
	 * @param arg0
	 */
	public ProcessOutputInfoFrame(GraphicsConfiguration arg0) {
		super(arg0);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param arg0
	 * @throws HeadlessException
	 */
	public ProcessOutputInfoFrame(String arg0) throws HeadlessException {
		super(arg0);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param arg0
	 * @param arg1
	 */
	public ProcessOutputInfoFrame(String arg0, GraphicsConfiguration arg1) {
		super(arg0, arg1);
		// TODO Auto-generated constructor stub
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		
	}

}
