package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.WindowConstants;

import edu.jhu.ece.iacl.jist.pipeline.OutputViewerPreferences;

/**
 * Process Output Viewer Preference Frame
 * @author Muqun Li(muqun.li@vanderbilt.edu)
 */
public class ProcessOutputViewerPrefFrame extends JFrame implements
		ActionListener {

	protected class FileReaderWorker extends SwingWorker<Void, Void> {
		
		/** The text area. */
		JTextArea textArea;
		
		/** The file. */
		File file;
		
		/** The monitor. */
		ProgressMonitor monitor;

		/**
		 * Instantiates a new file reader worker.
		 * 
		 * @param parent
		 *            the parent
		 * @param textArea
		 *            the text area
		 * @param f
		 *            the f
		 */
		public FileReaderWorker(Component parent, JTextArea textArea, File f) {
			this.textArea = textArea;
			this.file = f;
			monitor = new ProgressMonitor(parent, "Reading file " + f.getAbsolutePath(), "Reading...", 0, 100);
		}

		/* (non-Javadoc)
		 * @see javax.swing.SwingWorker#doInBackground()
		 */
		protected Void doInBackground() throws Exception {
			BufferedReader in;
			textArea.setText("");
			try {
				// Create input stream from file
				in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
				StringBuffer buff = new StringBuffer();
				String str;
				// Read file as string
				int line = 0;
				monitor.setProgress(0);
				while ((str = in.readLine()) != null) {
					if (monitor.isCanceled()) {
						break;
					}
					monitor.setProgress(50);
					monitor.setNote("Reading Line " + (++line));
					textArea.append(str + "\n");
				}
				monitor.setProgress(100);
				in.close();
			} catch (Exception e) {
				System.err.println(getClass().getCanonicalName()+"Error occured while reading parameter file:\n" + e.getMessage());
				e.printStackTrace();
				return null;
			}
			textArea.setCaretPosition(textArea.getText().length());
			monitor.close();
			return null;
		}
	}

	/**
	 * Split plane to display stdout and stderr.
	 * 
	 * @author Blake Lucas (bclucas@jhu.edu)
	 */
	protected class FileText extends JSplitPane {
		
		/** The bottom text area. */
		public JTextArea topTextArea, bottomTextArea;
		
		/** The bottom file. */
		public File topFile, bottomFile;
		
		/** The tree*/
		//public JTree 

		/**
		 * Instantiates a new file text.
		 * 
		 * @param tf
		 *            the tf
		 * @param bf
		 *            the bf
		 */
		public FileText(JTree ancestorTree, JTree decendantTree) {
			super(JSplitPane.VERTICAL_SPLIT);
			JScrollPane topScroll, bottomScroll;
			setTopComponent(topScroll = new JScrollPane());
			setBottomComponent(bottomScroll = new JScrollPane());
			setDividerLocation(300);
			setOneTouchExpandable(true);
			setResizeWeight(0.5);
	
			topScroll.setViewportView(ancestorTree);
			ancestorTree.updateUI();	
			bottomScroll.setViewportView(decendantTree);
			decendantTree.updateUI();
			topScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("ANCESTOR"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			bottomScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("DECENDANT"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			refresh();
		}
		/**
		 * Instantiates a new file text.
		 * 
		 * @param tf
		 *            the tf
		 * @param bf
		 *            the bf
		 */
		public FileText(File outputFile) {
			super(JSplitPane.VERTICAL_SPLIT);
			JScrollPane topScroll, bottomScroll;
			setTopComponent(topScroll = new JScrollPane());
			setBottomComponent(bottomScroll = new JScrollPane());
			setDividerLocation(300);
			setOneTouchExpandable(true);
			setResizeWeight(0.5);
			this.topFile = outputFile;
			topTextArea = new JTextArea();
			topScroll.setViewportView(topTextArea);
			topTextArea.setEditable(false);

			topScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("STDOUT"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			bottomScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("STDERR"),
					BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			refresh();
		}


		/**
		 * Refresh.
		 */
		public void refresh() {
			FileReaderWorker topWorker = new FileReaderWorker(this, topTextArea, topFile);
			topWorker.execute();
//			FileReaderWorker bottomWorker = new FileReaderWorker(this, bottomTextArea, bottomFile);
//			bottomWorker.execute();
		}
	}

	/** The tab pane. */
	JTabbedPane tabPane;
	
	/** The bottom tab pane. */
	JTabbedPane bottomTabPane;
	
	/** The tab panes for custom. */
	JTabbedPane previewTabPane;
	JTabbedPane advTabPane;
	JTabbedPane customTabPane;
	
	/** The refresh button. */
	JButton refreshButton;
	/** The custom buttons. */
	JButton previewButton;
	JButton advButton;
	JButton customButton;
	
	/**
	 * @throws HeadlessException
	 */
	public ProcessOutputViewerPrefFrame() throws HeadlessException {
		// TODO Auto-generated constructor stub
		super("Output Viewer Custom");
		this.setLayout(new GridLayout(1, 0));
		this.setPreferredSize(new Dimension(600, 200));
		this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		this.setVisible(false);
		this.setResizable(false);
		createTabPane();
		this.pack();
//		setIconImage(Toolkit.getDefaultToolkit().getImage(
//				PlaceHolder.class.getResource("zoom.gif"))); /**SET ICON HERE**/
	}
	/**
	 * @throws HeadlessException
	 */
	public void clear(){
		// TODO Auto-generated constructor stub
	
		this.setLayout(new GridLayout(1, 0));
		this.setPreferredSize(new Dimension(600, 200));
		this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		this.setVisible(false);
		this.pack();
//		setIconImage(Toolkit.getDefaultToolkit().getImage(
//				PlaceHolder.class.getResource("zoom.gif"))); /**SET ICON HERE**/
	}
	/**
	 * Load stdout and stderr from specified files.
	 * 
	 * @param name
	 *            name of frame
	 * @param tf
	 *            stdout file
	 * @param bf
	 *            stderr file
	 */
	public void load(String name, JTree ancestorTree, JTree decendantTree) {
		if (!this.isVisible()) {
			tabPane.removeAll();
		}
		this.setVisible(true);
	//	FileText text;
	//	tabPane.addTab(name, text = new FileText(ancestorTree, decendantTree));
	}
	
	public void load(String name, File outputFile) {
		if (!this.isVisible()) {
			tabPane.removeAll();
		}

		this.setVisible(true);
		FileText text;
//		tabPane.addTab(name, text = new FileText(outputFile));
//		FileReaderWorker topWorker = new FileReaderWorker(this, topTextArea, outputFile);
//		topWorker.execute();
	}
	/**
	 * @param arg0
	 */
	public ProcessOutputViewerPrefFrame(GraphicsConfiguration arg0) {
		super(arg0);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param arg0
	 * @throws HeadlessException
	 */
	public ProcessOutputViewerPrefFrame(String arg0) throws HeadlessException {
		super(arg0);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param arg0
	 * @param arg1
	 */
	public ProcessOutputViewerPrefFrame(String arg0, GraphicsConfiguration arg1) {
		super(arg0, arg1);
		// TODO Auto-generated constructor stub
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		if (e.getSource() == previewButton) {
			preview();
		}
	}
	public void preview() {
		// TODO Auto-generated method stub
		
	}
	public void createTabPane()
	{
		 //super(new GridLayout(1, 1));
	        
	        tabPane = new JTabbedPane();
	        //ImageIcon icon = createImageIcon("images/middle.gif");
	        
	        JPanel panel1 = makeTextPanel("Volume");
	        tabPane.addTab("Volume Viewer",  panel1);
	        tabPane.setMnemonicAt(0, KeyEvent.VK_1);
	        
	        JPanel panel2 = makeTextPanel("Surface");
	        tabPane.addTab("Surface Viewer", panel2);
	        tabPane.setMnemonicAt(1, KeyEvent.VK_2);
	        
	        JPanel panel3 = new JPanel();//makeTextPanel("Panel #3");
	        tabPane.addTab("Tab3", panel3);
	        tabPane.setMnemonicAt(2, KeyEvent.VK_3);
	        
	        /*JPanel panel4 = makeTextPanel(
	                "Panel #4 (has a preferred size of 410 x 50).");
	        panel4.setPreferredSize(new Dimension(410, 50));
	        tabPane.addTab("Tab 4", panel4);
	        tabPane.setMnemonicAt(3, KeyEvent.VK_4);
	        */
	        //Add the tabbed pane to this panel.
	        add(tabPane);
	        
	        //The following line enables to use scrolling tabs.
	        tabPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);

	}
	private JPanel makeTextPanel(String text) {
		// TODO Auto-generated method stub
        //JPanel panel = new JPanel(false);
        OutputViewerPreferencePanel panel = new OutputViewerPreferencePanel(text, OutputViewerPreferences.getPreferences());
		JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(JLabel.CENTER);
        panel.setLayout(new GridLayout(0, 1));
        //panel.add(filler);
        return panel;

	}

}
