/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.parameter;
import edu.jhu.ece.iacl.jist.pipeline.factory.ParamStringAreaFactory;

/**
 * String parameter.
 * 
 * @author Blake Lucas
 */
public class ParamStringArea extends ParamString {

	/** The string. */
	protected String string;

	/**
	 * Constructor.
	 */
	public ParamStringArea() {
		this("", "");
	}

	/**
	 * Constructor.
	 * 
	 * @param name
	 *            parameter name
	 */
	public ParamStringArea(String name) {
		this(name, "");
	}

	/**
	 * Constructor.
	 * 
	 * @param name
	 *            parameter name
	 * @param str
	 *            string
	 */
	public ParamStringArea(String name, String str) {
		setName(name);
		this.string = str;
		this.factory = new ParamStringAreaFactory(this);
	}

	/**
	 * Clone object.
	 * 
	 * @return the param string
	 */
	public ParamStringArea clone() {
		ParamStringArea param = new ParamStringArea();
		if (string != null) {
			param.setValue(new String(string));
		}
		param.setName(this.getName());
		param.label=this.label;
		param.setHidden(this.isHidden());
		param.setMandatory(this.isMandatory());		
		param.shortLabel=shortLabel;
		param.cliTag=cliTag;
		return param;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel#compareTo(edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel)
	 */
	@SuppressWarnings("rawtypes")
	public int compareTo(ParamModel model) {
		return (model instanceof ParamStringArea) ? 0 : 1;
	}

	/**
	 * Initialize parameter.
	 */
	public void init() {
		this.setMaxIncoming(1);
		connectible = true;
		factory = new ParamStringAreaFactory(this);
	}
}
