package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurfaceCollection;

public class PipeSourceCollectionSetSurface extends PipeSourceCollectionSet {

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		outCollectionParam = (ParamSurfaceCollection)outputParams.getFirstChildByName("Surface Collection");
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Default constructor.
	 */
	public PipeSourceCollectionSetSurface() { 
		super();
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = super.createInputParams();
		group.setLabel("Surface Collection Set");
		group.setName("Surface_Collection_Set");
		group.setCategory("Surface");
		return group;
	}
	
	@Override
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Surface Collection List");
		group.add(outCollectionParam = new ParamSurfaceCollection("Surface Collection"));
		return group;
	}
}
