/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;

/**
 * Iterate through list of parameters.
 * 
 * @author Blake Lucas, Andrew Asman
 */
public class PipeSourceCollectionVolume extends PipeSourceCollection {

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		inFileCollection = (ParamVolumeCollection) inputParams.getFirstChildByName("Volumes");
		outParam =(ParamVolumeCollection) outputParams.getFirstChildByName("Volume Collection");
		getParentPort().setParameter(outParam);
		
	}
	
	/**
	 * Default constructor.
	 */
	public PipeSourceCollectionVolume() {
		super();
		getParentPort().setParameter(outParam);
	}

	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = super.createInputParams();
		group.setLabel("Volume Collection");
		group.setName("Volume_Collection");
		group.setCategory("Volume");
		return group;
	}
	
	/**
	 * Create output parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Volume Collection");
		group.add(outParam = new ParamVolumeCollection("Volume Collection"));
		return group;
	}
	
	protected ParamVolumeCollection getInputCollection() {
		return new ParamVolumeCollection("Volumes");
	}

}
