/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;

/**
 * Iterate through list of parameters.
 * 
 * @author Blake Lucas, Andrew Asman
 */
public class PipeSourceSetFile extends PipeSourceSet {
		
	/** the output file **/
	protected ParamFile outFileParam;

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		inFileCollection = (ParamFileCollection) inputParams.getFirstChildByName("Files");
		outFileParam =(ParamFile) outputParams.getFirstChildByName("File");
		getParentPort().setParameter(outFileParam);
		
	}
	
	/**
	 * Default constructor.
	 */
	public PipeSourceSetFile() {
		super();
		getParentPort().setParameter(outFileParam);
	}

	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = super.createInputParams();
		group.setLabel("File Set");
		group.setName("File_Set");
		group.setCategory("File");
		return group;
	}
	
	/**
	 * Create output parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("File");
		group.add(outFileParam = new ParamFile("File"));
		return group;
	}
	
	public ParamFile getOutputParam() {
		return outFileParam;
	}


	protected ParamFileCollection getInputCollection() {
		return new ParamFileCollection("Files");
	}

}
