/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.src;

import java.io.File;

import edu.jhu.ece.iacl.jist.io.ArrayObjectTxtReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamXnatFileCollection;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

/**
 * Iterate through list of parameters.
 * 
 * @author Blake Lucas, Andrew Asman
 */
public abstract class PipeXnatSourceCollection extends PipeXnatSourceSet {

	protected ParamFileCollection outParam;
	
	/**
	 * Returns true if iterator has more values.
	 * 
	 * @return true, if checks for next
	 */
	public boolean hasNext() { return(getSourceHasNext()); }

	/**
	 * Iterate.
	 * 
	 * @return true, if iterate
	 */
	public boolean iterate() {
		if (hasNext()) {
			if (!sourceIterate()) {
				reset();
				isReset = true;
				return false;
			}
			return true;
		} else {
			reset();
			isReset = true;
			return false;
		}
	}
	
	@SuppressWarnings("rawtypes")
	public ParamModel getOutputParam() { return(outParam); }

	/**
	 * Reset iterator.
	 */
	public void reset() {
		sourceReset();
		
		if (typeOption.getIndex() == 0)
			reset_manual();
		else if (typeOption.getIndex() == 1)
			reset_txt();
		else
			reset_dir();
		
		push();
	}
	private void reset_manual() {
		outParam.clear();
		for (File f : inFileCollection.getValue())
			outParam.add(f);
	}
	private void reset_txt() {
		
		data = ArrayObjectTxtReaderWriter.getInstance().read(txtFileParam.getValue());
		if(data == null) {
			JistLogger.logError(JistLogger.INFO, "Cannot Read: "+txtFileParam.getValue());
			data = new Object[0][0];
		} 
		index = 0;
		st = startEntry.getInt();
		end = endEntry.getInt();
		off = offset.getInt();
		index = st;
		
		end = (end == -1 || end > data.length) ? data.length : end;
		
		outParam.clear();
		for (int i = st; i < end; i++)
			outParam.add(getValue(i));
	}
	public void reset_dir() {

		findMatchingFiles();
		
		outParam.clear();
		for (File f : fileList)
			outParam.add(f);
	}

}
