package edu.jhu.ece.iacl.jist.processcontrol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import javax.swing.JOptionPane;

import org.ggf.drmaa.AlreadyActiveSessionException;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.SessionFactory;

import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;
import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

// TODO: Auto-generated Javadoc
/**
 * The Class DispatchController.
 */
public class DispatchController {

	public DispatchController() {
	}

	/**
	 * sets the output location for use by the execution context
	 * 
	 * @param loc
	 */
	public DispatchController(File loc, ExecutionContext con) {
		outputLoc = loc;
		context = con;
	}

	/** The session. */
	private static Session session;

	/** The output location */
	File outputLoc = null;

	/** the execution context that has called the controller **/
	ExecutionContext context = null;

	/** The job list. */
	private static ArrayList<ProcessController> jobList = new ArrayList<ProcessController>();

	/** The running instance. */
	// Returns DRMAA Session object
	/**
	 * Gets the dRMAA session.
	 * 
	 * @return the dRMAA session
	 */
	public static Session getDRMAASession() {
		return session;
	}

	/**
	 * Gets the output location If this has not been set, returns null
	 * 
	 * @return the output location
	 */
	public File getOutputLocation() {
		return outputLoc;
	}

	/**
	 * Sets the output location
	 * 
	 * @param loc
	 */
	public void setOutputLocation(File loc) {
		outputLoc = loc;
	}

	// Returns List of Jobs Created
	/**
	 * Gets the job list.
	 * 
	 * @return the job list
	 */
	public static ArrayList getJobList() {
		return jobList;
	}

	/**
	 * Tests the availability of cluster resources by determining if there is
	 * info on the qsub command.
	 * 
	 * @return true, if successful
	 */
	public boolean testClusterAvailability() {
		boolean success = false;
		try {
			Process p = Runtime.getRuntime().exec("man -k qsub");
			BufferedReader stdinfo = new BufferedReader(new InputStreamReader(
					p.getInputStream()));
			String line = stdinfo.readLine();
			if (line != null) {
				success = true;
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		File f = JistPreferences.getPreferences().getGridEngineTemplate();
		if (f == null || !f.isFile()) {
			if (JistPreferences.getPreferences().isUseGridEngine())
				JistLogger
						.logError(JistLogger.WARNING,
								"Warning: invalid cluster template -- not using cluster");
			success = false;
		}

		return success;
	}

	// Shunxing edit
	public boolean testAwsEC2Availability() {
		boolean success = false;
		Properties prop = new Properties();
		InputStream input = null;
		try {
			input = new FileInputStream(System.getProperties().getProperty(
					"user.home")
					+ "/JistAwsEc2" + "/JISTAWSEC2.preferences");
			//System.out.println(input.available() + "asdasdas");
			prop.load(input);
			if (!prop.containsKey("AllCurrentRunningInstanceId")) {
				success = false;
			} else {
				String runningId = prop
						.getProperty("AllCurrentRunningInstanceId");

				if (runningId.length() > 0 && runningId != null) {
					success = true;
					System.out.println("???");
					return success;
				}
			}

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// NEED EDIT
		return success;
	}

	// Shunxing edit

	// Initialize a DRMAA Session
	// Returns whether a session is successfully initialized
	/**
	 * Inits the drmaa session.
	 * 
	 * @return true, if successful
	 */
	public boolean initDRMAASession() {
		if (System.getenv("LD_LIBRARY_PATH") == null)
			return false;
		boolean success;
		try {
			SessionFactory factory = SessionFactory.getFactory();
			session = factory.getSession();
			session.init("");
			success = true;
			JistLogger.logOutput(JistLogger.INFO, getClass().getCanonicalName()
					+ "\t" + "Session has been initialized");
		} catch (AlreadyActiveSessionException e) {
			success = true;
		} catch (DrmaaException e) {
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName() + "\t" + "Exception" + e);
			success = false;
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName()
					+ "\t"
					+ "Session has not been initialized due to Exception:" + e);
		} catch (LinkageError e) {
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName() + "\t" + "UnsatisfiedLinkError" + e);
			success = false;
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName()
					+ "\t"
					+ "Session has not been initialized due to Exception:" + e);
		}
		return success;
	}

	/**
	 * Restore drmaa session.
	 * 
	 * @param SessionIDFile
	 *            the session id file
	 * 
	 * @return true, if successful
	 */
	public boolean restoreDRMAASession(File SessionIDFile) {
		boolean success;
		SessionFactory factory = SessionFactory.getFactory();
		this.session = factory.getSession();
		try {
			BufferedReader inputfile = new BufferedReader(new FileReader(
					SessionIDFile));
			session.init(inputfile.readLine());
			inputfile.close();
			success = true;
		} catch (Exception e) {
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName() + "\t" + "Exception" + e);
			success = false;
		}
		return success;
	}

	/**
	 * Save drmaa session.
	 * 
	 * @param SessionIDFile
	 *            the session id file
	 * 
	 * @return true, if successful
	 */
	public boolean saveDRMAASession(File SessionIDFile) {

		boolean success;
		try {
			FileWriter fstream = new FileWriter(SessionIDFile);
			BufferedWriter out = new BufferedWriter(fstream);
			if (session.getContact() == null) {
				JistLogger.logError(JistLogger.SEVERE, getClass()
						.getCanonicalName()
						+ "\t"
						+ "There is no active Session Running");
				success = false;
			} else {
				out.write(session.getContact());
				out.close();
				JistLogger.logError(JistLogger.SEVERE, getClass()
						.getCanonicalName()
						+ "\t"
						+ "Session is saved to: "
						+ SessionIDFile.toString());
				success = true;
			}
		} catch (Exception e) {
			JistLogger.logError(JistLogger.SEVERE, getClass()
					.getCanonicalName() + "\t" + "Exception" + e);
			success = false;
		}
		return success;
	}

	/**
	 * Creates the job.
	 * 
	 * @param SGE
	 *            the sGE
	 * @param Command
	 *            the command
	 * 
	 * @return the process controller
	 */
	public ProcessController createJob(boolean SGE, boolean SAwsEC2,
			List<String> Command) {
		// if there is a DRMAA session, return a ProcessControllerDRMAA
		// if there is no DRMAA session, return a ProcessControllerNative

		ProcessController p = null;
		if (SAwsEC2) {
			p = new ProcessControllerAWSUpdate(context, Command);
			while (!p.Setup(Command)) {
//				JOptionPane.showMessageDialog(null,
//						"AWS Setup Failed, no free machine, please wait.");
				// p = new ProcessControllerNative(Command);
				System.out.println("Please wait for a free machine");
				try {
					Thread.sleep(10000);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				// JistLogger.logError(JistLogger.SEVERE,
				// getClass().getCanonicalName()+"No ");
			}
			System.out.println("Here we go, free machine.");
			return p;
		}
		if (SGE) {
			try {
				p = new ProcessControllerQsub(outputLoc.getCanonicalPath(),
						context);
				if (!p.Setup(Command)) {
					JOptionPane.showMessageDialog(null, "Cluster Setup Failed");
					p = new ProcessControllerNative(Command);
					JistLogger
							.logError(
									JistLogger.SEVERE,
									getClass().getCanonicalName()
											+ "Error when creating cluster Job, Please check Envoirnment Variable settings, Switch to Native");
				} else {
					return p;
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			p = new ProcessControllerNative(Command);
		}
		jobList.add(p);
		return p;
	}

	/**
	 * List all jobs.
	 * 
	 * @return the array list< process controller>
	 */
	public ArrayList<ProcessController> listAllJobs() {
		jobList.size();
		for (int i = 0; i <= jobList.size() - 1; i++) {
			JistLogger.logOutput(JistLogger.INFO, getClass().getCanonicalName()
					+ "\t" + "Job ID: " + jobList.get(i).toString());
			JistLogger.logOutput(JistLogger.INFO, getClass().getCanonicalName()
					+ "\t" + "Status: " + jobList.get(i).getStatus());
		}
		return jobList;
	}

	/**
	 * Close session.
	 * 
	 * @param terminateAllActiveJobs
	 *            the terminate all active jobs
	 */
	public void closeSession(boolean terminateAllActiveJobs) {
		int JobCreated = jobList.size();
		if (terminateAllActiveJobs) {
			try {
				for (int i = 0; i <= JobCreated - 1; i++) {
					session.control(jobList.get(i).toString(),
							session.TERMINATE);
				}
				JistLogger.logOutput(JistLogger.INFO, getClass()
						.getCanonicalName() + "\t" + "All job are terminated");
				session.exit();
			} catch (DrmaaException e) {
				JistLogger.logError(JistLogger.WARNING, getClass()
						.getCanonicalName()
						+ "\t"
						+ "Jobs Cannot be Termianted because Exception:" + e);
			}
		} else
			try {
				session.synchronize(
						Collections.singletonList(Session.JOB_IDS_SESSION_ALL),
						Session.TIMEOUT_WAIT_FOREVER, true);
				JistLogger.logOutput(JistLogger.INFO, getClass()
						.getCanonicalName() + "\t" + "ALL jobs are finished");
				session.exit();

			} catch (DrmaaException e) {
				JistLogger.logError(JistLogger.SEVERE, getClass()
						.getCanonicalName() + "\t" + "Exception" + e);
			}
	}

}
