package edu.jhu.ece.iacl.jist.processcontrol;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipException;

import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;
import edu.jhu.ece.iacl.jist.pipeline.gui.ProcessManager;
import edu.vanderbilt.masi.jistcloud.JistAwsEC2;
import edu.vanderbilt.masi.jistcloud.JistAwsOutputMonitor;
import edu.vanderbilt.masi.jistcloud.JistAwsS3;
import edu.vanderbilt.masi.jistcloud.JistAwsUtil;
import edu.vanderbilt.masi.jistcloud.MyUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public class ProcessControllerAWS implements ProcessController {
	/** The Job submit time. */
	long JobSubmitTime;

	// private InputStream stdout, stderr;
	private InputStream stdout;
	private ProcessStatus JobStatus;
	private Integer exitCode = -2;

	private String localInputAbsolutelyPath;
	private ExecutionContext context = null;
	private List<String> command;

	private boolean ifHasFreeNode = false;
	private String freeRunningInstanceId = null;
	private Instance runningInstance;
	private String keyPath = ProcessManager.jistAwsEC2.getKeyPairAbsolutePath();
	private String user = "ec2-user";

	private String s3InputFilePath = "";
	private String s3OutputFolderPath = "";
	private String localTmpOutputFolderPath = "";

	private static Session session;

	public ProcessControllerAWS(ExecutionContext _pContext,
			List<String> _pCommand) {
		context = _pContext;
		command = _pCommand;
	}

	@Override
	public ProcessStatus getStatus() {
		// TODO Auto-generated method stub
		return JobStatus;
	}

	@Override
	public long getSubmissionTime() {
		// TODO Auto-generated method stub
		return JobSubmitTime;
	}

	@Override
	public Integer getExitCode() {
		// TODO Auto-generated method stub
		return exitCode;
	}

	@Override
	public boolean submit() {
		// TODO Auto-generated method stub
		JobSubmitTime = System.currentTimeMillis();
		JobStatus = ProcessStatus.RUNNING;

		System.out.println("sendInputFile!!!!!!!________________!+_!+!_+!_+!");
		File inputF = new File(command.get(command.size() - 1));
		System.out.println("sendInputFile!!!!!!!________________!+_!+!_+!_+!");
		return sendInputFileToAWS(inputF);

		// //String keyPath =
		// ProcessManager.jistAwsEC2.getKeyPairAbsolutePath();
		// //String user = "ec2-user";
		// DescribeInstancesRequest describeInstanceRequest = new
		// DescribeInstancesRequest()
		// .withInstanceIds(freeRunningInstanceId);
		// DescribeInstancesResult describeInstanceResult =
		// ProcessManager.jistAwsEC2
		// .getAmazonEc2Client()
		// .describeInstances(describeInstanceRequest);
		//
		// runningInstance = describeInstanceResult.getReservations()
		// .get(0).getInstances().get(0);
		// Session session;
		// try {
		// session = JistAwsUtil.createSession(keyPath, user,
		// runningInstance.getPublicDnsName(), 22);
		// session.setConfig("StrictHostKeyChecking", "no");
		// session.connect();
		//
		// try {
		// JistAwsUtil.exec(session, "cd && rm JobDone");
		// String cmdPipeRunner =
		// "xvfb-run --server-args=\"-screen 0 1600x1280x24 -ac -extension GLX\" /home/ec2-user/mipav/jre/bin/java -classpath /home/ec2-user/mipav/plugins/:/home/ec2-user/mipav/:`find /home/ec2-user/mipav/ -name *.jar | sed 's#/home/ec2-user/mipav/#:/home/ec2-user/mipav/#' | tr -d '\n' | sed 's/^://'` edu.jhu.ece.iacl.jist.pipeline.PipeRunner";
		//
		// File inputF = new File(command.get(command.size()-1));
		// String localInputPath = inputF.getAbsolutePath();
		// String s3InputPath =
		// localInputPath.replaceAll(ProcessManager.layoutLocalPth, "/mnt/s3");
		//
		// String finalCmd = cmdPipeRunner + " " + s3InputPath;
		// stdout = JistAwsUtil.exec(session, finalCmd);
		// System.out.println(stdout);
		// JistAwsUtil.exec(session, "cd && touch JobDone");
		//
		// return true;
		// } catch (Exception e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		//
		// session.disconnect();
		// } catch (JSchException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		//
		// return false;

	}

	@Override
	public boolean destroy() {
		// TODO Auto-generated method stub
		controlJob(ProcessControlAction.TERMINATE);
		// try {
		//
		// JistAwsUtil.exec(session, "sudo rm " +
		// context.getContextName()+".zip ");
		//
		// } catch (Exception e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		//
		// session.disconnect();
		//
		// try {
		// FileUtils.deleteDirectory(new File((System.getProperties()
		// .getProperty("user.home")
		// + "/JistAwsEc2"
		// + "/tmp/"+context.getContextName())));
		// } catch (IOException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		// try {
		// Files.delete(Paths.get((System.getProperties()
		// .getProperty("user.home")
		// + "/JistAwsEc2"
		// + "/tmp/"+context.getContextName()+".zip")));
		// } catch (IOException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }

		return true;
	}

	@Override
	public Process getProcess() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int waitFor() throws InterruptedException {
		// TODO Auto-generated method stub
		// GET RUNNING INSTANCE

		// SEND COMMAND
		System.out.println("sendCMD!!!!!!!________________!+_!+!_+!_+!");

		// String keyPath = ProcessManager.jistAwsEC2.getKeyPairAbsolutePath();
		// String user = "ec2-user";
		DescribeInstancesRequest describeInstanceRequest = new DescribeInstancesRequest()
				.withInstanceIds(freeRunningInstanceId);
		DescribeInstancesResult describeInstanceResult = ProcessManager.jistAwsEC2
				.getAmazonEc2Client()
				.describeInstances(describeInstanceRequest);

		runningInstance = describeInstanceResult.getReservations().get(0)
				.getInstances().get(0);
		// Session session;
		JistAwsOutputMonitor monitor = new JistAwsOutputMonitor(user,
				runningInstance, keyPath, context.getContextName(),
				context.getInputLocation());

		try {
			session = JistAwsUtil.createSession(keyPath, user,
					runningInstance.getPublicDnsName(), 22);

			session.setConfig("StrictHostKeyChecking", "no");
			session.connect();

			try {
				// JistAwsUtil.exec(session, "cd && rm JobDone");
				// String cmdPipeRunner =
				// "xvfb-run --server-args=\"-screen 0 1600x1280x24 -ac -extension GLX\" /home/ec2-user/mipav/jre/bin/java -classpath /home/ec2-user/mipav/plugins/:/home/ec2-user/mipav/:`find /home/ec2-user/mipav/ -name *.jar | sed 's#/home/ec2-user/mipav/#:/home/ec2-user/mipav/#' | tr -d '\n' | sed 's/^://'` edu.jhu.ece.iacl.jist.pipeline.PipeRunner";
				String cmdPipeRunner = "xvfb-run --server-args=\"-screen 0 1600x1280x24 -ac -extension GLX\" /home/ec2-user/mipav/jre/bin/java -Xmx16000m -classpath /home/ec2-user/mipav/plugins/:/home/ec2-user/mipav/:`find /home/ec2-user/mipav/ -name *.jar | sed 's#/home/ec2-user/mipav/#:/home/ec2-user/mipav/#' | tr -d '\n' | sed 's/^://'` edu.jhu.ece.iacl.jist.pipeline.PipeRunner";

				File inputF = new File(command.get(command.size() - 1));

				String localInputPath = inputF.getAbsolutePath();
				// System.out.println("--localInputPath" + localInputPath);
				s3InputFilePath = localInputPath.replaceAll(
						ProcessManager.layoutLocalPth, "/mnt/s3");
				// System.out.println("--s3InputFilePath" + s3InputFilePath);
				s3OutputFolderPath = s3InputFilePath.replaceAll(".input", "");
				// System.out.println("--s3OutputFolderPath" +
				// s3OutputFolderPath);
				localTmpOutputFolderPath = s3InputFilePath.replaceAll(
						"/mnt/s3", "");
				// System.out.println("--localTmpOutputFolderPath"
				// + localTmpOutputFolderPath);
				String finalCmd = cmdPipeRunner + " " + s3InputFilePath;
				System.out.println(finalCmd + "???");

				monitor.start();

				// JistAwsUtil jistAwsUtilForFinalCmd = new
				// JistAwsUtil(context);
				// JistAwsUtil.execFinalCmd(session, finalCmd,context);

				while (!session.isConnected()) {
					session = JistAwsUtil.createSession(keyPath, user,
							runningInstance.getPublicDnsName(), 22);
					session.setConfig("StrictHostKeyChecking", "no");
					session.connect();
				}

				ChannelExec channel = (ChannelExec) session.openChannel("exec");

				((ChannelExec) channel).setPty(true);
				channel.setCommand(finalCmd);

				channel.connect();

				InputStream input = channel.getInputStream();

				Reader reader = new InputStreamReader(input);

				BufferedReader buffered = new BufferedReader(reader);

				while (true) {

					final String line = buffered.readLine();

					if (line == null) {
						break;
					}

					context.setLineFromAWS(line);
					System.out.println(line);
				}

				channel.disconnect();
				session.disconnect();

				context.setExecCompleteFromAWS(true);

				// String createZipOutput = "sudo zip -r /home/ec2-user/"
				// + context.getContextName() + " " + s3OutputFolderPath;
				String createZipOutput = "sudo zip -r /home/ec2-user/"
						+ context.getContextName() + ".zip" + " "
						+ s3OutputFolderPath;
				System.out.println(createZipOutput);

				// JistAwsUtil.execFinalCmd(session, createZipOutput,context);

				while (!session.isConnected()) {
					session = JistAwsUtil.createSession(keyPath, user,
							runningInstance.getPublicDnsName(), 22);
					session.setConfig("StrictHostKeyChecking", "no");
					session.connect();
				}

				channel = (ChannelExec) session.openChannel("exec");

				((ChannelExec) channel).setPty(true);
				channel.setCommand(createZipOutput);

				channel.connect();

				input = channel.getInputStream();

				reader = new InputStreamReader(input);

				buffered = new BufferedReader(reader);

				while (true) {

					final String line = buffered.readLine();

					if (line == null) {
						break;
					}
					System.out.println(line);
				}

				channel.disconnect();
				session.disconnect();

				System.out.println("zip file complete");

				String cmd = "scp -o StrictHostKeyChecking=no -i " + keyPath
						+ " " + user + "@" + runningInstance.getPublicDnsName()
						+ ":/home/ec2-user/" + context.getContextName()
						+ ".zip "
						+ System.getProperties().getProperty("user.home")
						+ "/JistAwsEc2" + "/tmp/";
				try {
					JistAwsEC2.execSecureCopy(cmd);
					// System.out.println(cmd);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					// JistAwsUtil.execFinalCmd(session,
					// "sudo rm /home/ec2-user/"
					// + context.getContextName() + ".zip",context);

					while (!session.isConnected()) {
						session = JistAwsUtil.createSession(keyPath, user,
								runningInstance.getPublicDnsName(), 22);
						session.setConfig("StrictHostKeyChecking", "no");
						session.connect();
					}
					channel = (ChannelExec) session.openChannel("exec");
					((ChannelExec) channel).setPty(true);
					channel.setCommand("sudo rm /home/ec2-user/"
							+ context.getContextName() + ".zip");

					channel.connect();

					input = channel.getInputStream();

					reader = new InputStreamReader(input);

					buffered = new BufferedReader(reader);

					while (true) {

						final String line = buffered.readLine();

						if (line == null) {
							break;
						}

						System.out.println(line);
					}
					channel.disconnect();
					session.disconnect();

				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (JSchException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		// CHECK IF THE JOB IS DONE
		// Session session;
		// try {
		// session = JistAwsUtil.createSession(keyPath, user,
		// runningInstance.getPublicDnsName(), 22);
		// session.setConfig("StrictHostKeyChecking", "no");
		// session.connect();
		//
		// try {
		// JistAwsUtil.exec(session, "cd && chmod +x IfFileExists.bin");
		// while(!JistAwsUtil.execIfComplete(session,
		// "./IfFileExists.bin JobDone")){
		// try {
		// Thread.sleep(1000);
		// } catch (InterruptedException e) {
		// JobStatus = ProcessStatus.FAILED;
		// exitCode = -1;
		// return exitCode;
		// }
		// }
		//
		//
		// } catch (Exception e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		//
		// session.disconnect();
		// } catch (JSchException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }

		System.out.println("JOBDONE");
		monitor.stop();
		Thread.sleep(1000);

		// TransferManager tx = new TransferManager(ProcessManager.s3Client);
		// // File newFile = new File(System.getProperties()
		// // .getProperty("user.home")
		// // + "/JistAwsEc2/tmp"+localTmpOutputFolderPath);
		// File newFile = new File(System.getProperties()
		// .getProperty("user.home")
		// + "/JistAwsEc2/tmp"+"/wocaonimalegebia");
		// System.out.println(localTmpOutputFolderPath+"+!(@_!(+**!+*@+*@+!+)@@+");
		// System.out.println(s3OutputFolderPath);
		// System.out.println(ProcessManager.bucketName);
		// MultipleFileDownload myDownload =
		// tx.downloadDirectory(ProcessManager.bucketName, s3OutputFolderPath,
		// newFile);
		// System.out.println(3123);
		//
		// myDownload.addProgressListener(new MyProgressListener());
		// System.out.println(11);
		// myDownload.waitForCompletion();
		// tx.shutdownNow();
		// System.out.println(44);
		//
		// System.out.println("END???");

		// String cmd = "scp -o StrictHostKeyChecking=no -i "+ keyPath + " " +
		// user+ "@" + runningInstance.getPublicDnsName()+":/home/ec2-user/"+
		// context.getContextName()+".zip " + System.getProperties()
		// .getProperty("user.home")
		// + "/JistAwsEc2"
		// + "/tmp/";
		// try {
		// JistAwsEC2.execSecureCopy(cmd);
		//
		// } catch (IOException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		// try {
		// JistAwsUtil.exec(session, "sudo rm /home/ec2-user/"+
		// context.getContextName() + ".zip");
		// } catch (Exception e1) {
		// // TODO Auto-generated catch block
		// e1.printStackTrace();
		// }

		// //DELETE ZIP FILE IN CLOUD MACHINE
		// Session sessionDEL;
		// try {
		// sessionDEL = JistAwsUtil.createSession(keyPath, user,
		// runningInstance.getPublicDnsName(), 22);
		// sessionDEL.setConfig("StrictHostKeyChecking", "no");
		// sessionDEL.connect();
		//
		// try {
		//
		// JistAwsUtil.exec(sessionDEL, "sudo rm " +
		// context.getContextName()+".zip ");
		//
		// } catch (Exception e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		//
		// sessionDEL.disconnect();
		// } catch (JSchException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }

		// Extract the zip file
		String srcZipFile = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName() + ".zip";
		String targetFolder = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName();
		try {
			MyUtils.extractFolder(srcZipFile, targetFolder);
		} catch (ZipException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		JistAwsUtil.arraylistFile = new ArrayList<File>();

		System.out.println(targetFolder + "local targetFolder");
		File dirToDownload = new File(targetFolder);
		JistAwsUtil.arraylistFile = JistAwsUtil
				.updatePathAndSendToS3(dirToDownload);
		// String layoutLocalPth = dirToDownload.getParent();
		// String line = null;
		System.out.println(dirToDownload.getAbsolutePath());
		for (File tmpFile : JistAwsUtil.arraylistFile) {
			System.out.println(tmpFile.getAbsolutePath());
		}
		for (File tmpFile : JistAwsUtil.arraylistFile) {

			Path srcpath = Paths.get(tmpFile.getAbsolutePath());
			Charset charset = StandardCharsets.UTF_8;

			String content = null;
			try {
				content = new String(Files.readAllBytes(srcpath), charset);
				String tmpContent = content;
				// If Input File is from outside
				String expName = context.getInputLocation().getParentFile()
						.getName();
				// System.out.println(expName + "wwwwwwwwww");
				content = content.replaceAll("file:/mnt/s3/" + expName
						+ "/INPUT", "file:");
				content = content.replaceAll("/mnt/s3/" + expName + "/INPUT",
						"");
				content = content.replaceAll("file:/mnt/s3", "file:"
						+ ProcessManager.layoutLocalPth);
				content = content.replaceAll("/mnt/s3",
						ProcessManager.layoutLocalPth);

				if (!content.equals(tmpContent)) {
					Path dstpath = Paths.get(tmpFile.getAbsolutePath());
					try {
						Files.write(dstpath, content.getBytes(charset));
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		String srcOut = targetFolder + "/mnt/s3/"
				+ ProcessManager.layoutParentName + "/"
				+ context.getInputLocation().getName() + "/"
				+ context.getContextName();
		System.out.println(srcOut);
		try {

			FileUtils.deleteDirectory(new File(context.getInputLocation()
					.getAbsolutePath() + "/" + context.getContextName()));

			FileUtils.moveDirectoryToDirectory(new File(srcOut),
					context.getInputLocation(), true);

			// Files.delete(Paths.get((System.getProperties()
			// .getProperty("user.home")
			// + "/JistAwsEc2"
			// + "/tmp/"+context.getContextName())));

			/*
			 * FileUtils.deleteDirectory(new File((System.getProperties()
			 * .getProperty("user.home") + "/JistAwsEc2" +
			 * "/tmp/"+context.getContextName())));
			 * Files.delete(Paths.get((System.getProperties()
			 * .getProperty("user.home") + "/JistAwsEc2" +
			 * "/tmp/"+context.getContextName()+".zip")));
			 */
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// set node as free

		ProcessManager.jistAwsEC2
				.setRunningInstanceFromBusyToFree(freeRunningInstanceId);

		exitCode = 0;
		JobStatus = ProcessStatus.DONE;

		return exitCode;

	}

	@Override
	public InputStream getStdoutFile() {
		// TODO Auto-generated method stub
		return stdout;
	}

	@Override
	public InputStream getStderrFile() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void controlJob(ProcessControlAction Action) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean Setup(List<String> command) {
		// TODO Auto-generated method stub
		// Check if exists an instanceId free.
		freeRunningInstanceId = ProcessManager.jistAwsEC2
				.getRunningInstanceIdFromMap();
		if (freeRunningInstanceId != null) {
			this.ifHasFreeNode = true;
			System.out.println("you la");
			return this.ifHasFreeNode;
		}
		return this.ifHasFreeNode;
	}

	/**
	 * Send update .input file to cloud
	 * 
	 * @throws IOException
	 */
	public boolean sendInputFileToAWS(File pipeFile) {

		Path srcpath = Paths.get(pipeFile.getAbsolutePath());
		Charset charset = StandardCharsets.UTF_8;

		// pipeFile: exp/exp-0000/exp-xxxxx.input
		String expName = pipeFile.getParentFile().getParentFile().getName();
		String content;
		try {
			// NEWLY ADDED
			BufferedReader br = new BufferedReader(new FileReader(new File(
					pipeFile.getAbsolutePath())));
			String line;
			StringBuilder sb = new StringBuilder();

			while ((line = br.readLine()) != null) {
				sb.append(line);
			}

			content = sb.toString();
			// NEWLY ADDED
			// content = new String(Files.readAllBytes(srcpath), charset);
			String tmpContent = content;

			if (content.contains("<file>")) {

				String[] tagsFile = StringUtils.substringsBetween(content,
						"<file>", "</file>");

				// Set for eliminate same tags
				Set<String> mytagsFileSet = new HashSet<String>(
						Arrays.asList(tagsFile));
				for (String eachFile : mytagsFileSet) {

					if (eachFile.contains(ProcessManager.layoutLocalPth + "/"
							+ expName + "/exp-0000")) {

						// if Input file is generated by experiment, then we
						// don't have to upload it to cloud
						if (eachFile.contains(ProcessManager.layoutLocalPth)) {
							String tmpExp000Tag = eachFile.replace(
									ProcessManager.layoutLocalPth, "/mnt/s3");
							// content = content
							// .replaceAll(eachFile, tmpExp000Tag);

							content = StringUtils.replace(content, eachFile,
									tmpExp000Tag);

							System.out.println(eachFile);
							System.out.println(ProcessManager.layoutLocalPth);
							String[] tagsFile2 = StringUtils.substringsBetween(
									content, "<file>", "</file>");
							for (String a : tagsFile2) {
								System.out.println(a);
							}

						}

					} else {
						// if Input file is from outside: 1) We need to check if
						// this file is in cloud
						// 2) If not, copu
						String[] tmpInputFileAbsolutePath = eachFile.split("/");

						if (tmpInputFileAbsolutePath.length == 1) {
							String tmpInputFileTag = tmpInputFileAbsolutePath[0]
									.replace(
											tmpInputFileAbsolutePath[0],
											"/mnt/s3/"
													+ expName
													+ "/INPUT/"
													+ tmpInputFileAbsolutePath[0]);
							// content = content.replaceAll(eachFile,
							// tmpInputFileTag);

							content = StringUtils.replace(content, eachFile,
									tmpInputFileTag);
						} else {
							String tmpInputFileTag = eachFile.replace(eachFile,
									"/mnt/s3/" + expName + "/INPUT" + eachFile);
							// content = content.replaceAll(eachFile,
							// tmpInputFileTag);

							content = StringUtils.replace(content, eachFile,
									tmpInputFileTag);
						}

					}

				}
				content = content.replaceAll("file:/mnt/s3", "file:///mnt/s3");
				if (!content.equals(tmpContent)) {
					System.out.println("NIMA SO QI GUAI " + pipeFile.getName()
							+ pipeFile.getAbsolutePath());
					// Files.write(Paths.get(tmpFile.getAbsolutePath()),
					// content.getBytes(charset));
					Path dstpath = Paths.get(System.getProperties()
							.getProperty("user.home")
							+ "/JistAwsEc2/tmp/"
							+ pipeFile.getName());
					// Files.write(dstpath, content.getBytes(charset));
					FileWriter out = new FileWriter(System.getProperties()
							.getProperty("user.home")
							+ "/JistAwsEc2/tmp/"
							+ pipeFile.getName());
					out.write(content);
					out.close();

					String tmp = new String(Files.readAllBytes(dstpath));

					while (!tmp
							.contains("</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection>")) {
						System.out.println("tmooo");
						try {
							Thread.sleep(100);
						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}

					File needToSend = dstpath.toFile();

					// it is a kind of messy since the dst file is saved to
					// a
					// different path,
					// we need to find original path via tmpFile.
					String needToSendFileName = pipeFile.getName();
					String needToSendFileParent = pipeFile.getParent();
					String needToSendFileS3Dir = needToSendFileParent.replace(
							ProcessManager.layoutLocalPth, "");
					String s3Location = ProcessManager.jistAwsS3.getS3Bucket()
							+ needToSendFileS3Dir;
					System.out.println(s3Location
							+ " Zhen de shi ni de wen ti???");
					ProcessManager.s3Client.putObject(new PutObjectRequest(
							s3Location, needToSendFileName, needToSend));

					// System.out.println(needToSendFileName
					// + " needToSendFileName");
					// System.out.println(needToSend + "needToSend");
					// Files.delete(Paths.get((System.getProperties()
					// .getProperty("user.home")
					// + "/JistAwsEc2"
					// + "/tmp/"+pipeFile.getName())));
					return true;
				}

				// REMOVE BY SHUNXING
				// content =
				// content.replaceAll(ProcessManager.layoutLocalPth,"/mnt/s3");
				// content = content.replaceAll("file:/mnt/s3",
				// "file:///mnt/s3");
				// if(!content.equals(tmpContent)){
				// Path dstpath = Paths.get(System.getProperties()
				// .getProperty("user.home")
				// + "/JistAwsEc2/tmp/"
				// + pipeFile.getName());
				// Files.write(dstpath,content.getBytes(charset));
				// REMOVE BY SHUNXING

			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return false;
	}

	static BitSet flag = new BitSet(3);

	static class MyProgressListener implements ProgressListener {
		/**
		 * Start progress.
		 */
		public void progressStart(ProgressEvent evt) {
			System.out.println("start: received progressevent " + evt);
			if (flag.nextSetBit(0) == -1)
				flag.set(0);
		}

		/**
		 * Update progress.
		 */
		public void progressUpdate(ProgressEvent evt) {
			System.out.println("update: received progressevent " + evt);
			if (flag.nextSetBit(1) == -1)
				flag.set(1);
		}

		/**
		 * Finish progress.
		 */
		public void progressFinish(ProgressEvent evt) {
			System.out.println("finish: received progressevent " + evt);
			if (flag.nextSetBit(2) == -1)
				flag.set(2);
		}

		@Override
		public void progressChanged(ProgressEvent progressEvent) {
			// TODO Auto-generated method stub

		}
	}

}
