package edu.jhu.ece.iacl.jist.processcontrol;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipException;

import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;
import edu.jhu.ece.iacl.jist.pipeline.gui.ProcessManager;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.jistcloud.JistAwsEC2;
import edu.vanderbilt.masi.jistcloud.JistAwsOutputMonitor;
import edu.vanderbilt.masi.jistcloud.JistAwsS3;
import edu.vanderbilt.masi.jistcloud.JistAwsUtil;
import edu.vanderbilt.masi.jistcloud.JistCloudExtension;
import edu.vanderbilt.masi.jistcloud.MyUtils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public class ProcessControllerAWSUpdate implements ProcessController {
	/** The Job submit time. */
	long JobSubmitTime;

	private InputStream stdout, stderr;
	// private InputStream stdout;
	private ProcessStatus JobStatus;
	private Integer exitCode = -2;

	private String localInputAbsolutelyPath;
	private ExecutionContext context = null;
	private List<String> command;

	private boolean ifHasFreeNode = false;
	private String freeRunningInstanceId = null;
	private Instance runningInstance;
	private String keyPath = ProcessManager.jistAwsEC2.getKeyPairAbsolutePath();
	private String user = "ec2-user";

	private String s3InputFilePath = "";
	private String s3OutputFolderPath = "";
	private String localTmpOutputFolderPath = "";
	
	private String expMainFolder = "";
	private long totalTransferTime;

	Process proc = null;
	ProcessBuilder builder;

	private static Session session;
	private JistAwsOutputMonitor monitor = null;

	public ProcessControllerAWSUpdate(ExecutionContext _pContext,
			List<String> _pCommand) {
		context = _pContext;
		command = _pCommand;
	}

	@Override
	public ProcessStatus getStatus() {
		// TODO Auto-generated method stub
		return JobStatus;
	}

	@Override
	public long getSubmissionTime() {
		// TODO Auto-generated method stub
		return JobSubmitTime;
	}

	@Override
	public Integer getExitCode() {
		// TODO Auto-generated method stub
		return exitCode;
	}

	@Override
	public boolean submit() {
		// TODO Auto-generated method stub
		JobSubmitTime = System.currentTimeMillis();
		totalTransferTime = JobSubmitTime;
		JobStatus = ProcessStatus.RUNNING;

		DescribeInstancesRequest describeInstanceRequest = new DescribeInstancesRequest()
				.withInstanceIds(freeRunningInstanceId);
		DescribeInstancesResult describeInstanceResult = ProcessManager.jistAwsEC2
				.getAmazonEc2Client()
				.describeInstances(describeInstanceRequest);

		runningInstance = describeInstanceResult.getReservations().get(0)
				.getInstances().get(0);

		System.out.println("sendInputFile!!!!!!!________________!+_!+!_+!_+!");
		File inputF = new File(command.get(command.size() - 1));
		System.out.println("sendInputFile!!!!!!!________________!+_!+!_+!_+!");
		sendInputFileToAWS(inputF);

		//JobSubmitTime = JobSubmitTime- System.currentTimeMillis();

		//GET ALL RELATED PATH
		String localInputPath = inputF.getAbsolutePath();// e.g. /home/local/VANDERBILT/Desktop/3_0/exp-0000/exp-0000-A.input
		expMainFolder = inputF.getParentFile().getParentFile().getAbsolutePath(); // e.g. /home/local/VANDERBILT/Desktop/3_0

		totalTransferTime = System.currentTimeMillis()- totalTransferTime;
		//System.out.println(ProcessManager.layoutLocalPth);
		s3InputFilePath = localInputPath.replaceAll(
				ProcessManager.layoutLocalPth, "/mnt/s3"); // e.g. /mnt/s3/3_0/exp-0000/exp-0000-A.input find the input file
		s3OutputFolderPath = s3InputFilePath.replaceAll(".input", ""); // e.g. /mnt/s3/3_0/exp-0000/exp-0000-A find the directory
		localTmpOutputFolderPath = s3InputFilePath.replaceAll("/mnt/s3", "");
				
		//DELETE ALL DATA in CLOUD
		String delCmd = "sudo rm -rf "+ s3OutputFolderPath;
		ProcessBuilder pbDel = new ProcessBuilder("ssh", "-tt", "-o",
				"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
						+ runningInstance.getPublicIpAddress(), delCmd);
		pbDel.redirectErrorStream();
		Process processDel = null;
		try {
			processDel = pbDel.start();
			InputStream inputStream3 = processDel.getInputStream();
			BufferedReader reader3 = new BufferedReader(new InputStreamReader(
					inputStream3));
			String line3 = null;
			while ((line3 = reader3.readLine()) != null) {
				System.out.println(line3);
			}
			try {
				processDel.waitFor();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} finally {
			processDel.destroy();
		}
		
		try {

			// SEND COMMAND
			System.out.println("sendCMD!!!!!!!________________!+_!+!_+!_+!");
			System.out.println(command.get(1));
			// FINAL COMMAND
			String cmdPipeRunner = "xvfb-run --server-args=\"-screen 0 1600x1280x24 \" /home/ec2-user/mipav/jre/bin/java " + command.get(1) +" -classpath /home/ec2-user/mipav/plugins/:/home/ec2-user/mipav/:`find /home/ec2-user/mipav/ -name *.jar | sed 's#/home/ec2-user/mipav/#:/home/ec2-user/mipav/#' | tr -d '\n' | sed 's/^://'` edu.jhu.ece.iacl.jist.pipeline.PipeRunner";
			// File inputF = new File(command.get(command.size() - 1));

					
			String finalCmd = cmdPipeRunner + " " + s3InputFilePath;
			System.out.println(finalCmd);
			builder = new ProcessBuilder("ssh", "-tt", "-o",
					"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
							+ runningInstance.getPublicIpAddress(),
					cmdPipeRunner, s3InputFilePath);
			builder.redirectErrorStream();
			monitor = new JistAwsOutputMonitor(user, runningInstance, keyPath,
					context.getContextName(), context.getInputLocation());
			monitor.start();
			proc = builder.start();

			stdout = proc.getInputStream();
			stderr = proc.getErrorStream();

			// InputStreamReader insrout=new InputStreamReader(stdout);
			// InputStreamReader insrerr=new InputStreamReader(stderr);
			//
			// BufferedReader stdoutReader = new BufferedReader(insrout);
			//
			// BufferedReader stderrReader = new BufferedReader(insrerr);

			// while (true)
			// {
			// String line = stdoutReader.readLine();
			// if (line == null)
			// {
			// break;
			// }
			// JistLogger.logOutput(JistLogger.INFO, line);
			// }
			//
			// while (true)
			// {
			// String line = stderrReader.readLine();
			// if (line == null)
			// { break;}
			// JistLogger.logOutput(JistLogger.INFO, line);
			// }
			// try {
			// process.waitFor();
			// } catch (InterruptedException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
			// }
			//System.out.println("wocaonimalegebi");
		} catch (IOException e) {
			e.printStackTrace(System.err);
			e.getMessage();
			System.exit(2);
		}
		return false;
	}

	@Override
	public boolean destroy() {
		// TODO Auto-generated method stub
		proc.destroy();
		if(monitor!=null){
			monitor.stopMonitoring();
			
		}
		ProcessManager.jistAwsEC2
		.setRunningInstanceFromBusyToFree(freeRunningInstanceId);
		
	
		totalTransferTime = System.currentTimeMillis() - totalTransferTime;
		String strLong = Long.toString(totalTransferTime);
		
//		try(PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(expMainFolder + File.separator+"transferTime.txt", true)))) {
//		    out.println(strLong);
//		}catch (IOException e) {
//		    //exception handling left as an exercise for the reader
//		}
		return true;
	}

	@Override
	public Process getProcess() {
		// TODO Auto-generated method stub
		return proc;
	}

	@Override
	public int waitFor() throws InterruptedException {
		// TODO Auto-generated method stub
		// GET RUNNING INSTANCE
		proc.waitFor();
		context.setExecCompleteFromAWS(true);

		totalTransferTime = totalTransferTime + System.currentTimeMillis();
		
		String createZipOutput = "sudo zip -r /home/ec2-user/"
				+ context.getContextName() + ".zip" + " " + s3OutputFolderPath;
		System.out.println(createZipOutput);

		ProcessBuilder pb = new ProcessBuilder("ssh", "-tt", "-o",
				"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
						+ runningInstance.getPublicIpAddress(), createZipOutput);
		pb.redirectErrorStream();
		Process process = null;
		try {
			process = pb.start();
			InputStream inputStream = process.getInputStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					inputStream));
			String line = null;
			while ((line = reader.readLine()) != null) {
				System.out.println(line);
			}
			process.waitFor();
		} catch (IOException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} finally{
			process.destroy();
		}

		System.out.println("zip file complete");

		String cmd = "scp -o StrictHostKeyChecking=no -i " + keyPath + " "
				+ user + "@" + runningInstance.getPublicDnsName()
				+ ":/home/ec2-user/" + context.getContextName() + ".zip "
				+ System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/";
		try {
			JistAwsEC2.execSecureCopy(cmd);
			// System.out.println(cmd);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 

		String removeCmd = "sudo rm /home/ec2-user/" + context.getContextName()
				+ ".zip";
		System.out.println(removeCmd);
		ProcessBuilder pb3 = new ProcessBuilder("ssh", "-tt", "-o",
				"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
						+ runningInstance.getPublicIpAddress(), removeCmd);
		pb3.redirectErrorStream();
		Process process3 = null;
		try {
			process3 = pb3.start();
			InputStream inputStream3 = process3.getInputStream();
			BufferedReader reader3 = new BufferedReader(new InputStreamReader(
					inputStream3));
			String line3 = null;
			while ((line3 = reader3.readLine()) != null) {
				System.out.println(line3);
			}
			process3.waitFor();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} finally {
			process3.destroy();
		}

		System.out.println("JOBDONE");
		if(monitor!=null){
			monitor.stopMonitoring();
		}
			
		Thread.sleep(800);

		// Extract the zip file
		String srcZipFile = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName() + ".zip";
		String targetFolder = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName();
		try {
			MyUtils.extractFolder(srcZipFile, targetFolder);
		} catch (ZipException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		JistAwsUtil.arraylistFile = new ArrayList<File>();

		System.out.println(targetFolder + "local targetFolder");
		File dirToDownload = new File(targetFolder);
		JistAwsUtil.arraylistFile = JistAwsUtil
				.updatePathAndSendToS3(dirToDownload);
		// String layoutLocalPth = dirToDownload.getParent();
		// String line = null;
		System.out.println(dirToDownload.getAbsolutePath());
		for (File tmpFile : JistAwsUtil.arraylistFile) {
			System.out.println(tmpFile.getAbsolutePath());
		}
		for (File tmpFile : JistAwsUtil.arraylistFile) {

			Path srcpath = Paths.get(tmpFile.getAbsolutePath());
			Charset charset = StandardCharsets.UTF_8;

			String content = null;
			try {
				content = new String(Files.readAllBytes(srcpath), charset);
				String tmpContent = content;
				// If Input File is from outside
				String expName = context.getInputLocation().getParentFile()
						.getName();
				// System.out.println(expName + "wwwwwwwwww");
				content = content.replaceAll("file:/mnt/s3/" + expName
						+ "/INPUT", "file:");
				content = content.replaceAll("/mnt/s3/" + expName + "/INPUT",
						"");
				content = content.replaceAll("file:/mnt/s3", "file:"
						+ ProcessManager.layoutLocalPth);
				content = content.replaceAll("/mnt/s3",
						ProcessManager.layoutLocalPth);

				if (!content.equals(tmpContent)) {
					Path dstpath = Paths.get(tmpFile.getAbsolutePath());
					try {
						Files.write(dstpath, content.getBytes(charset));
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		String srcOut = targetFolder + "/mnt/s3/"
				+ ProcessManager.layoutParentName + "/"
				+ context.getInputLocation().getName() + "/"
				+ context.getContextName();
		System.out.println(srcOut + "srcOut");
		try {
			String origindir = context.getInputLocation()
					.getAbsolutePath() + "/" + context.getContextName();	
//			String[] dirCheck = origindir.split("/");
//			if(dirCheck[dirCheck.length-1].contains(".")){
//				dirCheck[dirCheck.length-1] = dirCheck[dirCheck.length-1].replace(".", "");
//				origindir = "";
//				for(int i = 1; i<dirCheck.length;++i){
//					origindir = origindir +  File.separator + dirCheck[i];
//				}
//			}
//			FileUtils.deleteDirectory(new File(origindir));

//			File delTargetFolder =new File(origindir);
//			JistAwsUtil.deleteDir(delTargetFolder);
			
//			while(delTargetFolder.exists()){
//				delTargetFolder =new File(origindir);
//			}

			String dstOut = context.getInputLocation().getAbsolutePath()+File.separator+context.getContextName();
			FileUtils.copyDirectory(new File(srcOut),
					new File(dstOut),true);
//			FileUtils.moveDirectoryToDirectory(new File(srcOut),
//					context.getInputLocation(), true);
			
			Files.delete(Paths.get(srcZipFile));
			
//			File delTargetFolder = new File(targetFolder);
			//JistAwsUtil.deleteDir(delTargetFolder);
//			FileUtils.deleteDirectory(new File(targetFolder));
//			FileUtils.deleteDirectory(new File(targetFolder+".zip"));

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if(monitor!=null){
				monitor.stopMonitoring();
				monitor.stop();
			}
		}
		// set node as free


		

		exitCode = 0;
		JobStatus = ProcessStatus.DONE;

		return exitCode;

	}

	@Override
	public InputStream getStdoutFile() {
		// TODO Auto-generated method stub
		return stdout;
	}

	@Override
	public InputStream getStderrFile() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void controlJob(ProcessControlAction Action) {
		// TODO Auto-generated method stub
		switch (Action) {
		case HOLD:
		case RELEASE:
		case RESUME:

			// not supported
			break;
		case TERMINATE:
			IFDONE();
			destroy();
			break;
		}
	}
	
	private void IFDONE(){
		
		context.setExecCompleteFromAWS(true);

		String createZipOutput = "sudo zip -r /home/ec2-user/"
				+ context.getContextName() + ".zip" + " " + s3OutputFolderPath;
		System.out.println(createZipOutput);

		ProcessBuilder pb = new ProcessBuilder("ssh", "-tt", "-o",
				"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
						+ runningInstance.getPublicIpAddress(), createZipOutput);
		pb.redirectErrorStream();
		Process process;
		try {
			process = pb.start();
			InputStream inputStream = process.getInputStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					inputStream));
			String line = null;
			while ((line = reader.readLine()) != null) {
				System.out.println(line);
			}
			try {
				process.waitFor();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (IOException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}

		System.out.println("zip file complete");

		String cmd = "scp -o StrictHostKeyChecking=no -i " + keyPath + " "
				+ user + "@" + runningInstance.getPublicDnsName()
				+ ":/home/ec2-user/" + context.getContextName() + ".zip "
				+ System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/";
		try {
			try {
				JistAwsEC2.execSecureCopy(cmd);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			// System.out.println(cmd);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		String removeCmd = "sudo rm /home/ec2-user/" + context.getContextName()
				+ ".zip";
		System.out.println(removeCmd);
		ProcessBuilder pb3 = new ProcessBuilder("ssh", "-tt", "-o",
				"StrictHostKeyChecking=no", "-i", keyPath, "ec2-user@"
						+ runningInstance.getPublicIpAddress(), removeCmd);
		pb3.redirectErrorStream();
		Process process3;
		try {
			process3 = pb3.start();
			InputStream inputStream3 = process3.getInputStream();
			BufferedReader reader3 = new BufferedReader(new InputStreamReader(
					inputStream3));
			String line3 = null;
			while ((line3 = reader3.readLine()) != null) {
				System.out.println(line3);
			}
			try {
				process3.waitFor();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		System.out.println("JOBDONE");
		if(monitor!=null)
			monitor.stopMonitoring();
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		// Extract the zip file
		String srcZipFile = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName() + ".zip";
		String targetFolder = System.getProperties().getProperty("user.home")
				+ "/JistAwsEc2" + "/tmp/" + context.getContextName();
		try {
			MyUtils.extractFolder(srcZipFile, targetFolder);
		} catch (ZipException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		JistAwsUtil.arraylistFile = new ArrayList<File>();

		System.out.println(targetFolder + "local targetFolder");
		File dirToDownload = new File(targetFolder);
		JistAwsUtil.arraylistFile = JistAwsUtil
				.updatePathAndSendToS3(dirToDownload);
		// String layoutLocalPth = dirToDownload.getParent();
		// String line = null;
		System.out.println(dirToDownload.getAbsolutePath());
		for (File tmpFile : JistAwsUtil.arraylistFile) {
			System.out.println(tmpFile.getAbsolutePath());
		}
		for (File tmpFile : JistAwsUtil.arraylistFile) {

			Path srcpath = Paths.get(tmpFile.getAbsolutePath());
			Charset charset = StandardCharsets.UTF_8;

			String content = null;
			try {
				content = new String(Files.readAllBytes(srcpath), charset);
				String tmpContent = content;
				// If Input File is from outside
				String expName = context.getInputLocation().getParentFile()
						.getName();
				// System.out.println(expName + "wwwwwwwwww");
				content = content.replaceAll("file:/mnt/s3/" + expName
						+ "/INPUT", "file:");
				content = content.replaceAll("/mnt/s3/" + expName + "/INPUT",
						"");
				content = content.replaceAll("file:/mnt/s3", "file:"
						+ ProcessManager.layoutLocalPth);
				content = content.replaceAll("/mnt/s3",
						ProcessManager.layoutLocalPth);

				if (!content.equals(tmpContent)) {
					Path dstpath = Paths.get(tmpFile.getAbsolutePath());
					try {
						Files.write(dstpath, content.getBytes(charset));
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		String srcOut = targetFolder + "/mnt/s3/"
				+ ProcessManager.layoutParentName + "/"
				+ context.getInputLocation().getName() + "/"
				+ context.getContextName();
		System.out.println(srcOut + "srcOut");
		try {

//			String origindir = context.getInputLocation()
//					.getAbsolutePath() + "/" + context.getContextName();	
//			String[] dirCheck = origindir.split("/");
//			if(dirCheck[dirCheck.length-1].contains(".")){
//				dirCheck[dirCheck.length-1] = dirCheck[dirCheck.length-1].replace(".", "");
//				origindir = "";
//				for(int i = 1; i<dirCheck.length;++i){
//					origindir = origindir +  File.separator + dirCheck[i];
//				}
//			}
//			FileUtils.deleteDirectory(new File(origindir));

			String dstOut = context.getInputLocation().getAbsolutePath()+File.separator+context.getContextName();
			FileUtils.copyDirectory(new File(srcOut),
					new File(dstOut),true);
			
//			FileUtils.moveDirectoryToDirectory(new File(srcOut),
//					context.getInputLocation(), true);
			
//			FileUtils.deleteDirectory(new File(targetFolder));
			Files.delete(Paths.get(srcZipFile));
			File delTargetFolder = new File(targetFolder);
			//JistAwsUtil.deleteDir(delTargetFolder);

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		ProcessManager.jistAwsEC2
				.setRunningInstanceFromBusyToFree(freeRunningInstanceId);
	}

	@Override
	public boolean Setup(List<String> command) {
		// TODO Auto-generated method stub
		// Check if exists an instanceId free.
		freeRunningInstanceId = ProcessManager.jistAwsEC2
				.getRunningInstanceIdFromMap();
		if (freeRunningInstanceId != null) {
			this.ifHasFreeNode = true;
			System.out.println("you la");
			return this.ifHasFreeNode;
		}
		return this.ifHasFreeNode;
	}

	/**
	 * Send update .input file to cloud
	 * 
	 * @throws IOException
	 */
	public boolean sendInputFileToAWS(File pipeFile) {

		Path srcpath = Paths.get(pipeFile.getAbsolutePath());
		Charset charset = StandardCharsets.UTF_8;

		// pipeFile: exp/exp-0000/exp-xxxxx.input
		String expName = pipeFile.getParentFile().getParentFile().getName();
		String content = null;
		try {
			// NEWLY ADDED
			// BufferedReader br = new BufferedReader(new FileReader(new File(
			// pipeFile.getAbsolutePath())));
			// String line;
			// StringBuilder sb = new StringBuilder();
			//
			// while ((line = br.readLine()) != null) {
			// sb.append(line);
			// }
			// //content = sb.toString();
			// NEWLY ADDED
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer;
			try {
				transformer = tf.newTransformer();
				transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,
						"yes");
				StringWriter writer = new StringWriter();

				DocumentBuilderFactory factory = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder builder = null;
				try {
					builder = factory.newDocumentBuilder();
				} catch (ParserConfigurationException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				Document doc = null;
				try {
					doc = builder.parse(pipeFile);
				} catch (SAXException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					transformer.transform(new DOMSource(doc), new StreamResult(
							writer));
				} catch (TransformerException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				content = writer.getBuffer().toString();
				//System.out.println(content);
			} catch (TransformerConfigurationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			// NEWLY ADDED
			// content = new String(Files.readAllBytes(srcpath), charset);
			String tmpContent = content;

			if (content.contains("<file>")) {

				String[] tagsFile = StringUtils.substringsBetween(content,
						"<file>", "</file>");

				// Set for eliminate same tags
				Set<String> mytagsFileSet = new HashSet<String>(
						Arrays.asList(tagsFile));
				for (String eachFile : mytagsFileSet) {

//					if (eachFile.contains(ProcessManager.layoutLocalPth + "/"
//							+ expName + "/exp-0000")) {
					//SHUNXING JULY 31
					if (eachFile.contains(ProcessManager.layoutLocalPth + "/"
								+ expName + "/exp-")) {

						// if Input file is generated by experiment, then we
						// don't have to upload it to cloud
						if (eachFile.contains(ProcessManager.layoutLocalPth)) {
							String tmpExp000Tag = eachFile.replace(
									ProcessManager.layoutLocalPth, "/mnt/s3");
							// content = content
							// .replaceAll(eachFile, tmpExp000Tag);

							content = StringUtils.replace(content, eachFile,
									tmpExp000Tag);

							System.out.println(eachFile);
							System.out.println(ProcessManager.layoutLocalPth);
							String[] tagsFile2 = StringUtils.substringsBetween(
									content, "<file>", "</file>");
							for (String a : tagsFile2) {
								System.out.println(a);
							}

						}

					} else {
						// if Input file is from outside: 1) We need to check if
						// this file is in cloud
						// 2) If not, copu
						String[] tmpInputFileAbsolutePath = eachFile.split("/");

						if (tmpInputFileAbsolutePath.length == 1) {
							String tmpInputFileTag = tmpInputFileAbsolutePath[0]
									.replace(
											tmpInputFileAbsolutePath[0],
											"/mnt/s3/"
													+ expName
													+ "/INPUT/"
													+ tmpInputFileAbsolutePath[0]);
							// content = content.replaceAll(eachFile,
							// tmpInputFileTag);

							content = StringUtils.replace(content, eachFile,
									tmpInputFileTag);
						} else {
							String tmpInputFileTag = eachFile.replace(eachFile,
									"/mnt/s3/" + expName + "/INPUT" + eachFile);
							// content = content.replaceAll(eachFile,
							// tmpInputFileTag);

							content = StringUtils.replace(content, eachFile,
									tmpInputFileTag);
						}

					}

				}
				content = content.replaceAll("file:/mnt/s3", "file:///mnt/s3");
				if (!content.equals(tmpContent)) {
					System.out.println("NIMA SO QI GUAI " + pipeFile.getName()
							+ pipeFile.getAbsolutePath());
					// Files.write(Paths.get(tmpFile.getAbsolutePath()),
					// content.getBytes(charset));
					Path dstpath = Paths.get(System.getProperties()
							.getProperty("user.home")
							+ "/JistAwsEc2/tmp/"
							+ pipeFile.getName());
					// Files.write(dstpath, content.getBytes(charset));
					FileWriter out = new FileWriter(System.getProperties()
							.getProperty("user.home")
							+ "/JistAwsEc2/tmp/"
							+ pipeFile.getName());
					out.write(content);
					out.close();

					// String tmp = new String(Files.readAllBytes(dstpath));
					//
					// while (!tmp
					// .contains("</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection>"))
					// {
					// System.out.println("tmooo");
					// try {
					// Thread.sleep(100);
					// } catch (InterruptedException e) {
					// // TODO Auto-generated catch block
					// e.printStackTrace();
					// }
					// }

					File needToSend = dstpath.toFile();

					// it is a kind of messy since the dst file is saved to
					// a
					// different path,
					// we need to find original path via tmpFile.
					String needToSendFileName = pipeFile.getName();
					String needToSendFileParent = pipeFile.getParent();
					String needToSendFileS3Dir = needToSendFileParent.replace(
							ProcessManager.layoutLocalPth, "");
					String s3Location = ProcessManager.jistAwsS3.getS3Bucket()
							+ needToSendFileS3Dir;
					System.out.println(s3Location
							+ " Zhen de shi ni de wen ti???");

					System.out.println(System.currentTimeMillis());
					ProcessManager.s3Client
							.deleteObject(new DeleteObjectRequest(s3Location,
									needToSendFileName));
					System.out.println(s3Location);
					System.out.println(needToSendFileName + ".zip");
					
					
					JistAwsUtil.zipFile(needToSend, needToSend.getAbsolutePath() + ".zip");

					File zipNeedToSendFile = new File(
							needToSend.getAbsolutePath() + ".zip");
					
					System.out.println(zipNeedToSendFile.getAbsolutePath());

					
					PutObjectResult result = ProcessManager.s3Client
							.putObject(new PutObjectRequest(s3Location,
									needToSendFileName + ".zip",
									zipNeedToSendFile));

					
					// unzip file
					String createZipInput = "sudo unzip -o /mnt/s3" + needToSendFileS3Dir + "/" + needToSendFileName + ".zip" + " -d /mnt/s3" + needToSendFileS3Dir + "/";
		
					System.out.println(createZipInput);

					ProcessBuilder pb = new ProcessBuilder("ssh", "-tt", "-o",
							"StrictHostKeyChecking=no", "-i", keyPath,
							"ec2-user@" + runningInstance.getPublicIpAddress(),
							createZipInput);
					pb.redirectErrorStream();
					Process process;
					try {
						process = pb.start();
						InputStream inputStream = process.getInputStream();
						BufferedReader reader = new BufferedReader(
								new InputStreamReader(inputStream));
						String line = null;
						while ((line = reader.readLine()) != null) {
							System.out.println(line);
						}
						process.waitFor();
					} catch (IOException e2) {
						// TODO Auto-generated catch block
						e2.printStackTrace();
					}

					//
					//
					// //CHECK IF SUBMISSION COMPLETE
					//
					// int timer = 100;
					// while(!checkIfPutObjectComplete(s3Location,needToSendFileName)){
					// ProcessManager.s3Client.putObject(new PutObjectRequest(
					// s3Location, needToSendFileName, needToSend));
					// Thread.sleep(timer);
					// timer = timer + 100;
					// System.out.println("ZAI lai yi ci");
					// }
					//

					Files.delete(Paths.get(needToSend.getAbsolutePath()
							+ ".zip"));
					System.out.println(System.currentTimeMillis());
					System.out.println(result.getContentMd5());

					System.out.println(System.currentTimeMillis());
					// System.out.println(needToSendFileName
					// + " needToSendFileName");
					// System.out.println(needToSend + "needToSend");
					 Files.delete(Paths.get((System.getProperties()
					 .getProperty("user.home")
					 + File.separator + "JistAwsEc2"
					 +  File.separator +"tmp" + File.separator +pipeFile.getName())));

					return true;
				}

				// REMOVE BY SHUNXING
				// content =
				// content.replaceAll(ProcessManager.layoutLocalPth,"/mnt/s3");
				// content = content.replaceAll("file:/mnt/s3",
				// "file:///mnt/s3");
				// if(!content.equals(tmpContent)){
				// Path dstpath = Paths.get(System.getProperties()
				// .getProperty("user.home")
				// + "/JistAwsEc2/tmp/"
				// + pipeFile.getName());
				// Files.write(dstpath,content.getBytes(charset));
				// REMOVE BY SHUNXING

			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return false;
	}

	private boolean checkIfPutObjectComplete(String bucket, String key)
			throws IOException {
		S3Object s3Object = ProcessManager.s3Client
				.getObject(new GetObjectRequest(bucket, key));

		S3ObjectInputStream input = s3Object.getObjectContent();
		BufferedReader reader = new BufferedReader(new InputStreamReader(input));
		while (true) {
			String line = reader.readLine();
			if (line == null)
				break;
			if (line.contains("</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection>")) {
				System.out
						.println("wocaowocaowocaowocaosheigandangwoaaaaaaaaa!!!!!!!");
				return true;
			}

		}
		return false;
	}

	static BitSet flag = new BitSet(3);

	static class MyProgressListener implements ProgressListener {
		/**
		 * Start progress.
		 */
		public void progressStart(ProgressEvent evt) {
			System.out.println("start: received progressevent " + evt);
			if (flag.nextSetBit(0) == -1)
				flag.set(0);
		}

		/**
		 * Update progress.
		 */
		public void progressUpdate(ProgressEvent evt) {
			System.out.println("update: received progressevent " + evt);
			if (flag.nextSetBit(1) == -1)
				flag.set(1);
		}

		/**
		 * Finish progress.
		 */
		public void progressFinish(ProgressEvent evt) {
			System.out.println("finish: received progressevent " + evt);
			if (flag.nextSetBit(2) == -1)
				flag.set(2);
		}

		@Override
		public void progressChanged(ProgressEvent progressEvent) {
			// TODO Auto-generated method stub

		}
	}

}
