/**
 * 
 */
package edu.jhu.ece.iacl.jist.structures.image;

import java.awt.Color;

import edu.jhu.ece.iacl.jist.utility.JistLogger;

/**
 * The Class ImageDataInt.
 * 
 * @author bennett
 */
public class ImageDataByte extends ImageData {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 8205138120433256897L;

	/** The vol2d. */
	protected byte vol2d[][] = null;

	/** The vol3d. */
	protected byte vol3d[][][] = null;

	/** The vol4d. */
	protected byte vol4d[][][][] = null;

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param vol the vol
	 */
	public ImageDataByte(ImageData vol) {
		JistLogger.logOutput(JistLogger.INFO,"New ImageData Copy from Existing: " + vol.getName());
		this.type = VoxelType.BYTE;
		this.rows = vol.getRows();
		this.cols = vol.getCols();
		this.slices = vol.getSlices();
		this.components = vol.getComponents();
		this.setName(vol.getName());
		this.setHeader(vol.getHeader());
		if (vol.slices < 2) {
			vol2d = new byte[rows][cols];
			vol3d = null;
			vol4d = null;
			for (int i = 0; i < rows; i++) {
				for (int j = 0; j < cols; j++) {
					vol2d[i][j] = vol.getByte(i, j);
				}
			}
		} else {
			if (vol.components < 2) {
				vol2d = null;
				vol3d = new byte[rows][cols][slices];
				vol4d = null;
				for (int i = 0; i < rows; i++) {
					for (int j = 0; j < cols; j++) {
						for (int k = 0; k < slices; k++) {
							vol3d[i][j][k] = vol.getByte(i, j, k);
						}
					}
				}
			} else {
				vol2d = null;
				vol3d = null;
				vol4d = new byte[rows][cols][slices][components];
				for (int i = 0; i < rows; i++) {
					for (int j = 0; j < cols; j++) {
						for (int k = 0; k < slices; k++) {
							for (int l = 0; l < components; l++) {
								vol4d[i][j][k][l] = vol.get(i, j, k, l).byteValue();
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param rows the rows
	 * @param cols the cols
	 */
	public ImageDataByte(int rows, int cols) {
		this(rows, cols, 1, 1);
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param rows the rows
	 * @param cols the cols
	 * @param slices the slices
	 */
	public ImageDataByte(int rows, int cols, int slices) {
		this(rows, cols, slices, 1);
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param name the name
	 * @param rows the rows
	 * @param cols the cols
	 */
	public ImageDataByte(String name, int rows, int cols) {
		this(rows, cols, 1, 1);
		setName(name);
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param name the name
	 * @param rows the rows
	 * @param cols the cols
	 * @param slices the slices
	 */
	public ImageDataByte(String name, int rows, int cols, int slices) {
		this(rows, cols, slices, 1);
		setName(name);
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param name the name
	 * @param rows the rows
	 * @param cols the cols
	 * @param slices the slices
	 * @param components the components
	 */
	public ImageDataByte(String name, int rows, int cols, int slices, int components) {
		this(rows, cols, slices, components);
		setName(name);
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param rows the rows
	 * @param cols the cols
	 * @param slices the slices
	 * @param components the components
	 */
	public ImageDataByte(int rows, int cols, int slices, int components) {
		this.rows = rows;
		this.cols = cols;
		this.slices = slices;
		this.components = components;
		this.type = VoxelType.BYTE;
		if (components < 2) {
			if(slices<2) {
				vol2d=new byte[rows][cols];
				vol3d = null;
				vol4d = null;
			}else{
				vol2d=null;
				vol3d = new byte[rows][cols][slices];
				vol4d = null;
			}
		} else {
			vol2d=null;
			vol3d=null;
			vol4d = new byte[rows][cols][slices][components];
		}
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param data the data
	 */
	public ImageDataByte(byte[][] data) {
		this.type = VoxelType.BYTE;
		this.rows = data.length;
		this.cols = data[0].length;
		this.slices = 0;
		this.components = 0;
		vol2d = data;
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param data the data
	 */
	public ImageDataByte(byte[][][] data) {
		this.type = VoxelType.BYTE;
		this.rows = data.length;
		this.cols = data[0].length;
		this.slices = data[0][0].length;
		this.components = 0;
		vol3d = data;
		setHeader(new ImageHeader());
	}

	/**
	 * Instantiates a new image data int.
	 * 
	 * @param data the data
	 */
	public ImageDataByte(byte[][][][] data) {
		this.type = VoxelType.BYTE;
		this.rows = data.length;
		this.cols = data[0].length;
		this.slices = data[0][0].length;
		this.components = data[0][0][0].length;
		vol4d = data;
		setHeader(new ImageHeader());
	}
	 
	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#clone()
	 */
	public ImageDataByte clone() {
		ImageDataByte v = this.mimic();		
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					for (int l = 0; l < components; l++) {
						v.set(i,j,k,l,getByte(i, j,k,l));
					}
				}
			}
		}

		return v;
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#get(int, int, int, int)
	 */
	public Number get(int i, int j, int k, int l) {
		if(vol4d!=null)
			return vol4d[i][j][k][l];
		if(vol3d!=null)
			return vol3d[i][j][k];
		if(vol2d!=null)
			return vol2d[i][j];
		return null;
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getBoolean(int, int, int, int)
	 */
	public boolean getBoolean(int i, int j, int k, int l) {
		if(vol4d!=null)
			return vol4d[i][j][k][l]!=0;
		if(vol3d!=null)
			return vol3d[i][j][k]!=0;
		if(vol2d!=null)
			return vol2d[i][j]!=0;
		return false;
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getColor(int, int, int, int)
	 */
	public Color getColor(int i, int j, int k, int l) {
		if(vol4d!=null)
			return new Color((int) vol4d[i][j][k][l]);
		if(vol3d!=null)
			return new Color((int) vol3d[i][j][k]);
		if(vol2d!=null)
			return new Color((int) vol2d[i][j]);
		return null;

	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getDouble(int, int, int, int)
	 */
	public double getDouble(int i, int j, int k, int l) {
		if(vol4d!=null)
			return vol4d[i][j][k][l];
		if(vol3d!=null)
			return vol3d[i][j][k];
		if(vol2d!=null)
			return vol2d[i][j];
		return Double.NaN;		
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getFloat(int, int, int, int)
	 */
	public float getFloat(int i, int j, int k, int l) {
		if(vol4d!=null)
			return (float)vol4d[i][j][k][l];
		if(vol3d!=null)
			return (float)vol3d[i][j][k];
		if(vol2d!=null)
			return (float)vol2d[i][j];
		return Float.NaN;
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getInt(int, int, int, int)
	 */
	public int getInt(int i, int j, int k, int l) {
		if(vol4d!=null)
			return (int)vol4d[i][j][k][l];
		if(vol3d!=null)
			return (int)vol3d[i][j][k];
		if(vol2d!=null)
			return (int)vol2d[i][j];
		return 0;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getShort(int, int, int, int)
	 */
	public short getShort(int i, int j, int k, int l) {
		if(vol4d!=null)
			return (short)vol4d[i][j][k][l];
		if(vol3d!=null)
			return (short)vol3d[i][j][k];
		if(vol2d!=null)
			return (short)vol2d[i][j];
		return 0;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#getUByte(int, int, int, int)
	 */
	public short getUByte(int i, int j, int k, int l) {
		short val = getShort(i, j,k,l);
		return (val<0?0:val>255?255:val);
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#mimic()
	 */
	public ImageDataByte mimic() {
		ImageDataByte vol = new ImageDataByte(rows, cols, slices, components);
		vol.setHeader(this.getHeader());
		return vol;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#mimic(int, int, int, int)
	 */
	public ImageDataByte mimic(int rows, int cols, int slices, int components) {
		ImageDataByte vol = new ImageDataByte(rows, cols, slices, components);
		vol.setHeader(this.getHeader());
		return vol;
	}



	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, boolean)
	 */
	public void set(int i, int j, int k, int l, boolean a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)(a ? 1 : 0);
		if(vol3d!=null)
			vol3d[i][j][k] = (byte)(a ? 1 : 0);
		if(vol2d!=null)
			vol2d[i][j] = (byte)(a ? 1 : 0);				
	}

	/**
	 * Sets the.
	 * 
	 * @param i the i
	 * @param j the j
	 * @param k the k
	 * @param l the l
	 * @param a the a
	 */
	public void set(int i, int j, int k, int l, byte a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = a;
		if(vol3d!=null)
			vol3d[i][j][k] = a;
		if(vol2d!=null)
			vol2d[i][j] = a;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, float)
	 */
	public void set(int i, int j, int k, int l, float a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)a;
		if(vol3d!=null)
			vol3d[i][j][k] =  (byte)a;
		if(vol2d!=null)
			vol2d[i][j] =  (byte)a;
	}
	
	public void set(int i, int j, int k, int l, Number a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = a.byteValue();
		if(vol3d!=null)
			vol3d[i][j][k] =  a.byteValue();
		if(vol2d!=null)
			vol2d[i][j] =  a.byteValue();
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, int)
	 */
	public void set(int i, int j, int k, int l, int a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)a;
		if(vol3d!=null)
			vol3d[i][j][k] = (byte)a;
		if(vol2d!=null)
			vol2d[i][j] = (byte)a;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, java.awt.Color)
	 */
	public void set(int i, int j, int k, int l, Color a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)a.getRed();
		if(vol3d!=null)
			vol3d[i][j][k] = (byte)a.getRed();
		if(vol2d!=null)
			vol2d[i][j] = (byte)a.getRed();
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, double)
	 */
	public void set(int i, int j, int k, int l, double a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)a;
		if(vol3d!=null)
			vol3d[i][j][k] = (byte)a;
		if(vol2d!=null)
			vol2d[i][j] = (byte)a;
	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(int, int, int, int, short)
	 */
	public void set(int i, int j, int k, int l, short a) {
		if(vol4d!=null)
			vol4d[i][j][k][l] = (byte)a;
		if(vol3d!=null)
			vol3d[i][j][k] = (byte)a;
		if(vol2d!=null)
			vol2d[i][j] = (byte)a;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#set(edu.jhu.ece.iacl.jist.structures.image.Voxel)
	 */
	public void set(Voxel a) {
		Object[] vals = toArray();
		double val = a.doubleValue();
		for (int i = 0; i < vals.length; i++) {
			vals[i] = val;
		}
	}



	/**
	 * To array.
	 * 
	 * @return the object[]
	 */
	public Object[] toArray() {
		if(vol2d!=null)return (Object[])vol2d;
		if(vol3d!=null)return (Object[])vol3d;
		if(vol4d!=null)return (Object[])vol4d;
		return null;
	}


	/**
	 * To array2d.
	 * 
	 * @return the int[][]
	 */
	public byte[][] toArray2d() {
		return vol2d;
	}

	/**
	 * To array3d.
	 * 
	 * @return the int[][][]
	 */
	public byte[][][] toArray3d() {
		return vol3d;
	}

	/**
	 * To array4d.
	 * 
	 * @return the int[][][][]
	 */
	public byte[][][][] toArray4d() {
		return vol4d;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.structures.image.ImageData#dispose()
	 */
	public void dispose() {
		vol2d=null;
		vol3d=null;
		vol4d=null;
	}
	
	public boolean isNotAvailable() {
		return (vol2d==null) && (vol3d==null) && (vol4d==null);
	}

	@Override
	public byte getByte(int i, int j, int k, int l) {
		if(vol4d!=null)
			return (byte)vol4d[i][j][k][l];
		if(vol3d!=null)
			return (byte)vol3d[i][j][k];
		if(vol2d!=null)
			return (byte)vol2d[i][j];
		return 0;
	}
}
