package edu.jhu.ece.iacl.jist.utility;


import java.net.URL;

import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JOptionPane;


/**
 * A collection of static methods and frequently used and useful constants are in this utility class.
 */
public class HelpUtil {

    // ~ Static fields/initializers
    // -------------------------------------------------------------------------------------

    /**
     * Displays the Java Help dialog indexed directly to the section identified by the ID passed in.
     * 
     * @param ID the index ID indicating what section the Java Help dialop should display.
     */
    static HelpSet hs;

    /** DOCUMENT ME! */
    static HelpBroker helpBroker;

    // ~ Methods
    // --------------------------------------------------------------------------------------------------------

   /**
     * Pops up a message dialog to display an error.
     * 
     * <p>
     * Use when an operation has failed, preventing some operation critical for MIPAV to continue running normally or an
     * operation can neither be completed nor its errors accomodated.
     * </p>
     * 
     * @param error the message text of the error
     * 
     * @see JOptionPane#showMessageDialog(java.awt.Component, java.lang.Object, java.lang.String, int, javax.swing.Icon)
     */
    public static void displayError(final String error) {
        
    	System.err.println("Error: " + error);
    }

   /**
     * Pops up the JIST help for a given help ID.
     * 
     * @param ID The ID of the help topic to open.
     */
    public static void showHelp(final String ID) {

        try {
            final ClassLoader cloader = jist.help.PlaceHolderHelp.class.getClassLoader();

            // the help.jar must be in the classpath !!!!!!!!!!
            final URL hsURL = HelpSet.findHelpSet(cloader, "JIST_dialogs.hs");

            if (hsURL != null) {

                if ( (HelpUtil.hs == null) || (HelpUtil.helpBroker == null)) {
                    HelpUtil.hs = new HelpSet(cloader, hsURL);
                    HelpUtil.helpBroker = HelpUtil.hs.createHelpBroker();
                }

                if (ID != null) {
                    HelpUtil.helpBroker.setCurrentID(ID);
                }

                HelpUtil.helpBroker.setSize(new java.awt.Dimension(1000, 600));
                HelpUtil.helpBroker.setLocation(new java.awt.Point(200, 300));

                // helpBroker.getFrame().setIconImage(HelpUtil.getIconImage(Preferences.getIconName()));
                HelpUtil.helpBroker.setDisplayed(true);
                // hs = null;
                // helpBroker = null;
            } else {
                HelpUtil.displayError("Unable to find helpset.");
            }
        } catch (final NullPointerException npe) {
            HelpUtil.displayError("MIPAV Help cannot be found.");
        } catch (final OutOfMemoryError error) {
            HelpUtil.displayError("Out of memory error opening help.");
        } catch (final HelpSetException error) {
            HelpUtil.displayError("HelpSet error = " + error);
        } catch (final BadIDException error) {
            HelpUtil.displayError("HelpSet ID error = " + error);
            if (ID != null) {
                // show default help dialogue
                HelpUtil.showHelp("10001");
            } else {
                HelpUtil.displayError("MIPAV cannot display help.  View help at:\nhttp://mipav.cit.nih.gov/documentation.php");
            }
        }
    }

}
