package edu.vanderbilt.masi.jistcloud;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.zip.ZipException;

import org.apache.commons.io.FileUtils;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

import edu.jhu.ece.iacl.jist.pipeline.gui.ProcessManager;

public class JistAwsOutputMonitor extends Thread {

	private String user;
	private String keyPath;
	private Instance runningInstance;
	private String contextName;
	private File contextInputFile;
	protected boolean running = false;

	public JistAwsOutputMonitor(String _p_user, Instance _p_runningInstance,
			String _p_keyPath, String _p_contextName, File _p_contextInputFile) {
		this.user = _p_user;
		this.runningInstance = _p_runningInstance;
		this.keyPath = _p_keyPath;
		this.contextName = _p_contextName;
		this.contextInputFile = _p_contextInputFile;
	}

	public void stopMonitoring() {
		running = false;
	}
	
	@Override
	public void run() {
		// TODO Auto-generated method stu
		running = true;
		while (running) {
			try {
				Thread.sleep(60000);
				//Thread.sleep(600);
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}


//			// CREATE ZIP FOLDER
//			Session session;
//			try {
//				session = JistAwsUtil.createSession(keyPath, user,
//						runningInstance.getPublicDnsName(), 22);
//				session.setConfig("StrictHostKeyChecking", "no");
//				session.connect();

				try {
					String localInputDebugErrPath = contextInputFile.getAbsolutePath()
							+ "/" + contextName + "/debug.err";
	
					String s3DebugErrPath = localInputDebugErrPath.replaceAll(
							ProcessManager.layoutLocalPth, "");

					ObjectListing listDebugErr = ProcessManager.s3Client.listObjects(ProcessManager.bucketName, s3DebugErrPath.substring(1));
					int objSumSizeDebugErr = listDebugErr.getObjectSummaries().size();
					
					String localInputDebugOutPath = contextInputFile.getAbsolutePath()
							+ "/" + contextName + "/debug.out";
					
					String s3DebugOutPath = localInputDebugOutPath.replaceAll(
							ProcessManager.layoutLocalPth, "");
					
					ObjectListing listDebugOut = ProcessManager.s3Client.listObjects(ProcessManager.bucketName, s3DebugOutPath.substring(1));
					int objSumSizeDebugOut = listDebugOut.getObjectSummaries().size();
					
					if(objSumSizeDebugOut * objSumSizeDebugErr > 0){
	
						//Download debug.err debug.out
						//First create dir in local repo
						File contextResultFolder = new File(contextInputFile.getAbsolutePath()
								+ "/" + contextName);
						if(contextResultFolder.exists() && contextResultFolder.isDirectory()){
							File localDebugErr = new File(contextInputFile.getAbsolutePath()
									+ "/" + contextName + "/debug.err");
							ProcessManager.s3Client.getObject(new GetObjectRequest(ProcessManager.bucketName, s3DebugErrPath.substring(1)), localDebugErr);
							
							File localDebugOut = new File(contextInputFile.getAbsolutePath()
									+ "/" + contextName + "/debug.out");
							ProcessManager.s3Client.getObject(new GetObjectRequest(ProcessManager.bucketName, s3DebugOutPath.substring(1)), localDebugOut);
							
						} else {
							if(!contextResultFolder.exists()||!contextResultFolder.isDirectory()){
								contextResultFolder.mkdirs();
							}
							
							
							File localDebugErr = new File(contextInputFile.getAbsolutePath()
									+ "/" + contextName + "/debug.err");
							ProcessManager.s3Client.getObject(new GetObjectRequest(ProcessManager.bucketName, s3DebugErrPath.substring(1)), localDebugErr);
							
							File localDebugOut = new File(contextInputFile.getAbsolutePath()
									+ "/" + contextName + "/debug.out");
							ProcessManager.s3Client.getObject(new GetObjectRequest(ProcessManager.bucketName, s3DebugOutPath.substring(1)), localDebugOut);
							
							
						}
					}
					
				} catch (Exception e) {
					// TODO Auto-generated catch block
					stopMonitoring();
					e.printStackTrace();
				}
//
//				session.disconnect();
//			} catch (JSchException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
			
			

					/*
					if (JistAwsUtil.execIfHasFile(session,
							"./IfFileExists.bin " + s3OutputFolderPath)) {
						//CREATE ZIP FOLDER
						String createZipOutput = "sudo nohup zip -r /home/ec2-user/"
								+ contextName + " " + s3OutputFolderPath;
						System.out.println(createZipOutput);
						JistAwsUtil.exec(session, createZipOutput);
						
						//DOWNLOAD ZIP FOLDER
						String cmd = "scp -o StrictHostKeyChecking=no -i " + keyPath + " "
								+ user + "@" + runningInstance.getPublicDnsName()
								+ ":/home/ec2-user/" + contextName + ".zip "
								+ System.getProperties().getProperty("user.home")
								+ "/JistAwsEc2" + "/tmp/";
						try {
							try {
								JistAwsEC2.execSecureCopy(cmd);
							} catch (InterruptedException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						
						// Extract the zip file
						String srcZipFile = System.getProperties().getProperty("user.home")
								+ "/JistAwsEc2" + "/tmp/" + contextName + ".zip";
						String targetFolder = System.getProperties().getProperty(
								"user.home")
								+ "/JistAwsEc2" + "/tmp/" + contextName;
						try {
							MyUtils.extractFolder(srcZipFile, targetFolder);
						} catch (ZipException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}

						JistAwsUtil.arraylistFile = new ArrayList<File>();

						System.out.println(targetFolder + "local targetFolder");
						File dirToDownload = new File(targetFolder);
						JistAwsUtil.arraylistFile = JistAwsUtil
								.updatePathAndSendToS3(dirToDownload);
						// String layoutLocalPth = dirToDownload.getParent();
						// String line = null;
						System.out.println(dirToDownload.getAbsolutePath());
						for (File tmpFile : JistAwsUtil.arraylistFile) {
							System.out.println(tmpFile.getAbsolutePath());
						}
						for (File tmpFile : JistAwsUtil.arraylistFile) {

							Path srcpath = Paths.get(tmpFile.getAbsolutePath());
							Charset charset = StandardCharsets.UTF_8;

							String content = null;
							try {
								content = new String(Files.readAllBytes(srcpath), charset);
								String tmpContent = content;

								content = content.replaceAll("file:///mnt/s3/INPUT",
										"file:");
								content = content.replaceAll("/mnt/s3/INPUT", "");
								content = content.replaceAll("file:///mnt/s3", "file:"
										+ ProcessManager.layoutLocalPth);
								content = content.replaceAll("/mnt/s3",
										ProcessManager.layoutLocalPth);

								if (!content.equals(tmpContent)) {
									Path dstpath = Paths.get(tmpFile.getAbsolutePath());
									try {
										Files.write(dstpath, content.getBytes(charset));
									} catch (IOException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
								}
							} catch (IOException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
						//
						String srcOut = targetFolder + "/mnt/s3/"
								+ ProcessManager.layoutParentName + "/"
								+ contextInputFile.getName() + "/" + contextName;
						System.out.println(srcOut);
						try {
							FileUtils.moveDirectoryToDirectory(new File(srcOut),
									contextInputFile, true);
							Files.delete(Paths.get((System.getProperties().getProperty(
									"user.home")
									+ "/JistAwsEc2" + "/tmp/" + contextName)));
							Files.delete(Paths.get((System.getProperties().getProperty(
									"user.home")
									+ "/JistAwsEc2" + "/tmp/" + contextName + ".zip")));

						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				session.disconnect();
			} catch (JSchException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			*/
			// CREATE ZIP FOLDER

//			String cmd = "scp -o StrictHostKeyChecking=no -i " + keyPath + " "
//					+ user + "@" + runningInstance.getPublicDnsName()
//					+ ":/home/ec2-user/" + contextName + ".zip "
//					+ System.getProperties().getProperty("user.home")
//					+ "/JistAwsEc2" + "/tmp/";
//			try {
//				try {
//					JistAwsEC2.execSecureCopy(cmd);
//				} catch (InterruptedException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			// Extract the zip file
//			String srcZipFile = System.getProperties().getProperty("user.home")
//					+ "/JistAwsEc2" + "/tmp/" + contextName + ".zip";
//			String targetFolder = System.getProperties().getProperty(
//					"user.home")
//					+ "/JistAwsEc2" + "/tmp/" + contextName;
//			try {
//				MyUtils.extractFolder(srcZipFile, targetFolder);
//			} catch (ZipException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//
//			JistAwsUtil.arraylistFile = new ArrayList<File>();
//
//			System.out.println(targetFolder + "local targetFolder");
//			File dirToDownload = new File(targetFolder);
//			JistAwsUtil.arraylistFile = JistAwsUtil
//					.updatePathAndSendToS3(dirToDownload);
//			// String layoutLocalPth = dirToDownload.getParent();
//			// String line = null;
//			System.out.println(dirToDownload.getAbsolutePath());
//			for (File tmpFile : JistAwsUtil.arraylistFile) {
//				System.out.println(tmpFile.getAbsolutePath());
//			}
//			for (File tmpFile : JistAwsUtil.arraylistFile) {
//
//				Path srcpath = Paths.get(tmpFile.getAbsolutePath());
//				Charset charset = StandardCharsets.UTF_8;
//
//				String content = null;
//				try {
//					content = new String(Files.readAllBytes(srcpath), charset);
//					String tmpContent = content;
//
//					content = content.replaceAll("file:///mnt/s3/INPUT",
//							"file:");
//					content = content.replaceAll("/mnt/s3/INPUT", "");
//					content = content.replaceAll("file:///mnt/s3", "file:"
//							+ ProcessManager.layoutLocalPth);
//					content = content.replaceAll("/mnt/s3",
//							ProcessManager.layoutLocalPth);
//
//					if (!content.equals(tmpContent)) {
//						Path dstpath = Paths.get(tmpFile.getAbsolutePath());
//						try {
//							Files.write(dstpath, content.getBytes(charset));
//						} catch (IOException e) {
//							// TODO Auto-generated catch block
//							e.printStackTrace();
//						}
//					}
//				} catch (IOException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//			}
//			//
//			String srcOut = targetFolder + "/mnt/s3/"
//					+ ProcessManager.layoutParentName + "/"
//					+ contextInputFile.getName() + "/" + contextName;
//			System.out.println(srcOut);
//			try {
//				FileUtils.moveDirectoryToDirectory(new File(srcOut),
//						contextInputFile, true);
//				Files.delete(Paths.get((System.getProperties().getProperty(
//						"user.home")
//						+ "/JistAwsEc2" + "/tmp/" + contextName)));
//				Files.delete(Paths.get((System.getProperties().getProperty(
//						"user.home")
//						+ "/JistAwsEc2" + "/tmp/" + contextName + ".zip")));
//
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
		}
	}
		
}
