package edu.vanderbilt.masi.jistcloud;

/**
 * @author Wei Xie <wei.xie (at) vanderbilt.edu>
 * @version 12/30/12
 * @description Compress and upload experiment to server
 *              Partially inspired by: http://www.java2s.com/Code/Java/File-Input-Output/UseJavacodetozipafolder.htm
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;

import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class JistCloudExtension {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            JistLogger.logError(JistLogger.SEVERE, "> Need to specify directory and destination zip name.");
            System.exit(1);
        }

        //compressFolder(args[0], args[1]);

        // directory, and remote server
        uploadToServer(args[0], args[1]);
    }

    /**
     * Compress directory
     * @param srcFolder
     * @param destZipFile
     * @return
     */
    public static boolean compressDirectory(String srcFolder, String destZipFile)
    {
        boolean result=false;

        try
        {
            zipFolder(srcFolder,destZipFile);
            result=true;
            JistLogger.logOutput(JistLogger.INFO, "Given files are successfully zipped");
        } catch(Exception e) {
            JistLogger.logError(JistLogger.SEVERE, "ERRORS occurred in compressing the directory.");
        } finally {
            return result;
        }
    }

    /*
     * zip the folders
     */
    private static void zipFolder(String srcFolder, String destZipFile) throws Exception
    {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
    /*
     * create the output stream to zip file result
     */
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
    /*
     * add the folder to the zip
     */
        addFolderToZip("", srcFolder, zip);
    /*
     * close the zip objects
     */
        zip.flush();
        zip.close();
    }

    /*
     * recursively add files to the zip files
     */
    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip,boolean flag)throws Exception
    {
     /*
      * create the file object for inputs
      */
        File folder = new File(srcFile);

    /*
     * if the folder is empty add empty folder to the Zip file
     */
        if (flag==true)
        {
            zip.putNextEntry(new ZipEntry(path + "/" +folder.getName() + "/"));
        }
        else
        {     /*
         * if the current name is directory, recursively traverse it to get the files
         */
            if (folder.isDirectory() )
            {
            /*
             * if folder is not empty
             */
                addFolderToZip(path, srcFile, zip);
            }
            else
            {
           /*
            * write the file to the output
           */
                byte[] buf = new byte[1024];
                int len;
                FileInputStream in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
                while ((len = in.read(buf)) > 0)
                {
              /*
               * Write the Result
              */
                    zip.write(buf, 0, len);
                }
            }
        }
    }

    /*
     * add folder to the zip file
     */
    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip)
            throws Exception
    {
        File folder = new File(srcFolder);

    /*
     * check the empty folder
     */
        if (folder.list().length == 0)
        {
            addFileToZip(path , srcFolder, zip,true);
        }
        else
        {
        /*
         * list the files in the folder
         */
            for (String fileName : folder.list())
            {
                if (path.equals(""))
                {
                    addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip,false);
                }
                else
                {
                    addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip,false);
                }
            }
        }
    }

    /**
     * Upload folder to remote server
     * @param path  path to layout file
     * @throws IOException
     */
    public static void uploadToServer(String path, String serverURL) {
        //TODO customize from outside
        String zipFile = "/tmp/jist_user_uploaded.zip";

        JistLogger.logOutput(JistLogger.INFO, "> To compress folder...");
        compressDirectory(new File(path).getParent(), zipFile);

        File file = new File(zipFile);
        HttpClient client = new HttpClient();
        MultipartPostMethod mPost = new MultipartPostMethod(serverURL);

        try {
            JistLogger.logOutput(JistLogger.INFO, "> To upload to server...");
            mPost.addParameter("myFile", file);
            mPost.addParameter("clientPath", path);

            try {
                client.executeMethod(mPost);
                JistLogger.logOutput(JistLogger.INFO, mPost.getResponseBodyAsString());
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                mPost.releaseConnection();
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

    }
    
    public static String terminateCluster(String remoteURL) {
    	String result = "";
        HttpClient client = new HttpClient();
        PostMethod get = new PostMethod(remoteURL);
        // We will do authentication later
        //method.addParameter("userKey", "");

        try{
			client.executeMethod(get);
			result = get.getResponseBodyAsString();
        } catch (Exception e) {
	        result = "ERROR: " + e.getMessage();
	        JistLogger.logError(JistLogger.SEVERE, result);
        } finally {
        	get.releaseConnection();
        }
        
        return result;
    }
}
