package edu.vanderbilt.masi.xnatJist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.apache.commons.codec.binary.Base64;

import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.gui.LayoutPanel;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamXnatFileCollectionInputView;

public class XnatMain {
	
	String host = null;
	String username = null;
	String password = null;
	String jsessionid = null;
	
	private static ArrayList<String> projects = new ArrayList<String>();
	private static ArrayList<String> subjects = new ArrayList<String>();
	private static ArrayList<String> experiments = new ArrayList<String>();
	private static ArrayList<String> scans = new ArrayList<String>();
	private static ArrayList<String> resources = new ArrayList<String>();
	
	public XnatMain(String h, String u, String p) {
		
		this.host = h;
		
		if (!this.host.endsWith("/"))
	    {
	        this.host += "/";
	    }
		
		this.username = u;
		this.password = p;
	}
	
	public void login() throws IOException {
		
		String authString = this.username + ":" + this.password;
        String encAuthString = new String(Base64.encodeBase64(authString.getBytes()));
        
        URL url = new URL(host + "data/JSESSION/");
        HttpURLConnection connLogin = (HttpURLConnection) url.openConnection();
        
        connLogin.setRequestMethod("POST");
        connLogin.setDoOutput(true);
        connLogin.setRequestProperty("Authorization", "Basic " + encAuthString);
        
        InputStream content = (InputStream) connLogin.getInputStream();
        BufferedReader br   = 
            new BufferedReader (new InputStreamReader (content));
        String line;
        
        while ((line = br.readLine()) != null) {
        	this.jsessionid = line;
        }
               
	}
	
	public void logout() throws IOException {
		URL url = new URL(host + "data/JSESSION");
		HttpURLConnection connLogout = (HttpURLConnection) url.openConnection();
		
		connLogout.setDoOutput(true);
        connLogout.setRequestProperty("Cookie", "JSESSIONID=" + jsessionid);
        connLogout.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connLogout.setRequestMethod("DELETE");
        
        InputStream contentLogout = (InputStream) connLogout.getInputStream();
        
        this.jsessionid = null;
        
	}
	
	public String getJSessionID() {
		return this.jsessionid;
	}
	
	public static void getProjects(String session, String h) throws IOException {
		URL url = new URL(h + "data/projects");
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
        connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
        connData.setRequestMethod("GET");
        
        projects.clear();
        
        InputStream contentData = (InputStream) connData.getInputStream();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")){
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[1].split("</td");
            	projects.add(parts2[0]);
        	}
        }
                		
	}
	
	public static void getSubjects(String session, String h, String proj) throws IOException {
		
		URL url = new URL(h + "data/projects/" + proj + "/subjects/");
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
		connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
		connData.setRequestMethod("GET");
		
		subjects.clear();
		
		InputStream contentData = (InputStream) connData.getInputStream();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")){
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[3].split("</td");
            	subjects.add(parts2[0]);
        	}
        }
				
	}
	
	public static void getExperiments(String session, String h, String proj, String subj) throws IOException {
		
		URL url = new URL(h + "data/projects/" + proj + "/subjects/" + subj + "/experiments");
		
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
		connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
		connData.setRequestMethod("GET");
		
		experiments.clear();
		
		InputStream contentData = (InputStream) connData.getInputStream();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")){
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[6].split("</td");
            	experiments.add(parts2[0]);
        	}
        }
        
	}
	
	public static void getScans(String session, String h, String proj, String subj, String exp) throws IOException {
		
		URL url = new URL(h + "data/projects/" + proj + "/subjects/" + subj + "/experiments/" + exp + "/scans/" );
		
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
		connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
		connData.setRequestMethod("GET");
		
		scans.clear();
		
		InputStream contentData = (InputStream) connData.getInputStream();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")){
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[2].split("</td");
            	scans.add(parts2[0]);
        	}
        }
		
	}
	
	public static void getResources(String session, String h, String proj, String subj, String exp, String scan) throws IOException {
		
		URL url = new URL(h + "data/projects/" + proj + "/subjects/" + subj + "/experiments/" + exp + "/scans/" + scan + "/resources/");
		
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
		connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
		connData.setRequestMethod("GET");
		
		resources.clear();
		
		InputStream contentData = (InputStream) connData.getInputStream();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")){
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[2].split("</td");
            	resources.add(parts2[0]);
        	}
        }
		
	}
	
		
	public static ArrayList<String> searchProjects (String s, String session, String h) throws IOException{
		
		getProjects(session, h);
						
		ArrayList <String> results = new ArrayList<String>();
		results.clear();
        
		results = searchArrayList(projects, s);
        
        return results;
		
	}
	
	public static ArrayList<ArrayList<String>> search (String subj, String exp, String scan, String res, String proj, String session, String h) throws IOException {
		
		ArrayList<ArrayList<String>> results = new ArrayList<ArrayList<String>>();
		results.clear();
		
		ArrayList<String> subjResults = new ArrayList<String>();
		subjResults.clear();
		getSubjects(session, h, proj);
		subjResults = searchArrayList(subjects, subj);
		
		for(String sub : subjResults) {
			ArrayList<String> expResults = new ArrayList<String>();
			expResults.clear();
			getExperiments(session, h, proj, sub);
			expResults = searchArrayList(experiments, exp);
			
			for(String ex : expResults) {
				ArrayList<String> scanResults = new ArrayList<String>();
				scanResults.clear();
				getScans(session, h, proj, sub, ex);
				scanResults = searchArrayList(scans, scan);
				
				for(String sc : scanResults) {
					ArrayList<String> resList = new ArrayList<String>();
					resList.clear();
					getResources(session, h, proj, sub, ex, sc);
					resList = searchArrayList(resources, res);
					
					for(String r : resList) {
						ArrayList<String> row = new ArrayList<String>();
						row.clear();
						row.add(sub);
						row.add(ex);
						row.add(sc);
						row.add(r);
						results.add(row);
					}
				}
			}
		}
		
		
		return results;
	}
	
	public static ArrayList<String> searchArrayList (ArrayList<String> arrayList, String searchString) {
		ArrayList<String> r = new ArrayList<String>();
		r.clear();
		for(String s : arrayList) {
			if((s.toLowerCase()).contains((searchString.toLowerCase()))) {
				r.add(s);
			}
		}
		return r;
	}

	public static ArrayList<String> download(String subj, String exp, String scan, String res, String proj, String session, String h) throws IOException {
		
		ArrayList<String> resFileName = new ArrayList<String>();
		resFileName.clear();
		
		resFileName = getFileName(subj, exp, scan, res, proj, session, h);
		
		
		for(String s: resFileName) {
			String str1 = "";
			str1 = str1 + s + ";" + subj + ";" + exp + ";" + scan + ";" + res + ";" + proj;
			System.out.println(str1);
			
			XnatSaveQuery.saveQuery(str1);
		}
		
		//PipeLayout layout = LayoutPanel.getInstance().getPipelineLayout();
		//File f = layout.getRunParameters().getOutputDirectory();
		File f = JistPreferences.getPreferences().getLastLayoutDirectory();
		String directory = null;
		try {
			directory = f.getAbsolutePath();
		} catch (NullPointerException n) {
			return null;
		}
		
		boolean exists = false;
		for(String str : resFileName) {
			exists = findFile(str, new File(directory));
			
		}
		
		if (!exists) {
			
			URL url = new URL(h + "data/projects/" + proj + "/subjects/" + subj + "/experiments/" + exp + "/scans/" + scan + "/resources/" + res + "/files?format=zip");
		
			HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
			connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
		
			String fileName = "";
			String disposition = connData.getHeaderField("Content-Disposition");
			int index = disposition.indexOf("filename=");
			if (index > 0) {
				fileName = disposition.substring(index + 10,
						disposition.length() - 2);
			}
			
			InputStream contentData = (InputStream) connData.getInputStream();
		
			//PipeLayout layout = LayoutPanel.getInstance().getPipelineLayout();
			//File f = layout.getRunParameters().getOutputDirectory();
			//File f = layout.getFileLocation();
			String saveFilePath = null;
			
			try {
				saveFilePath = directory + File.separator + fileName;
			} catch(NullPointerException n) {
			
				return null;
			}
		
		
			FileOutputStream outputStream = new FileOutputStream(saveFilePath);
			int bytesRead = -1;
			byte[] buffer = new byte[4096];
			while ((bytesRead = contentData.read(buffer)) != -1) {
				outputStream.write(buffer, 0, bytesRead);
			}
        
			extractFile(saveFilePath, directory);
			File file = new File(saveFilePath);
			file.delete();
        
			outputStream.close();
			contentData.close();
			connData.disconnect();
		}
		
		
		return resFileName;
		}

	private static boolean findFile(String str, File file) {
		// TODO Auto-generated method stub
		File[] list = file.listFiles();
		boolean exists = false;
		for (File fil : list) {
			
				if (fil.isDirectory()) {
					exists = findFile(str, fil);
					if(exists) {
						break;
					}
				} else {
					if(str.contains(fil.getName()) || fil.getName().contains(str)) {
						
						
						exists = true;
						break;
						
					}
				}
			
		}
		return exists;
	}

	private static void extractFile(String zipFile, String outputFolder) throws IOException {
		// TODO Auto-generated method stub
		byte[] buffer = new byte[1024];
		
		ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
		ZipEntry ze = zis.getNextEntry();
		
		while(ze!=null){
			 
	    	   String fileName = ze.getName();
	           File newFile = new File(outputFolder + File.separator + fileName);
	 
	           
	 
	            //create all non exists folders
	            //else you will hit FileNotFoundException for compressed folder
	            new File(newFile.getParent()).mkdirs();
	 
	            FileOutputStream fos = new FileOutputStream(newFile);             
	 
	            int len;
	            while ((len = zis.read(buffer)) > 0) {
	       		fos.write(buffer, 0, len);
	            }
	 
	            fos.close();   
	            ze = zis.getNextEntry();
	    	}
	 
	        zis.closeEntry();
	    	zis.close();
	    	
	    	//TODO delete the zip file
		
	}

	private static ArrayList<String> getFileName(String subj, String exp, String scan,
			String res, String proj, String session, String h) throws IOException{
		// TODO Auto-generated method stub
		ArrayList<String> fileName = new ArrayList<String>();
		fileName.clear();
		
		URL url = new URL(h + "data/projects/" + proj + "/subjects/" + subj + "/experiments/" + exp + "/scans/" + scan + "/resources/" + res + "/files/");
		
		HttpURLConnection connData = (HttpURLConnection) url.openConnection();
		
		connData.setDoOutput(true);
        connData.setRequestProperty("Cookie", "JSESSIONID=" + session);
        //connLogout.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connData.setRequestMethod("GET");
        
        InputStream contentData = (InputStream) connData.getInputStream();
        //StringBuilder sbData = new StringBuilder();
        BufferedReader brData   = new BufferedReader (new InputStreamReader (contentData));
        String lineData;
        
        while ((lineData = brData.readLine()) != null) {
        	if (lineData.contains("<td>")) {
        		String[] parts1 = lineData.split("<td>");
            	String[] parts2 = parts1[1].split("</td>");
            	
            	fileName.add(parts2[0]);
            	
        	}
        }
        connData.disconnect();
		return fileName;
	}
	
}
