/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A JUnit Testcase to run a bunch of commands through MIPAV's
 * 	CLI.
 *
 * IMPORTANT: the number of available threads is read from your 
 * 	build.properties file, and the default is 1. Make sure that this is set to
 * 	the appropriate value.
 */

package JIST_test;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.junit.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

import java.io.*;

public class CommandRunner extends TestCase {

	public CommandRunner (String name) {
		super(name);
	}

	@Test
	public void runCommands () {

		CommandRunnerSingleton 		crs = CommandRunnerSingleton.getInstance();

		int tf_num 	= crs.size();
		int tc 		= crs.get_tc();

		System.out.println("Starting a new FixedThreadPool with " + tc + " threads");

		ExecutorService 			es  = Executors.newFixedThreadPool(tc);
		CompletionService<Object> 	cs  = new ExecutorCompletionService<Object>(es);

		while (crs.size() > 0)
			cs.submit(crs.get_command());


		for (int i = 0; i < tf_num; ++i) {
			Object x;
			try {
				x = cs.take().get();
				System.out.println(x.toString() + " finished");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}


	}

}
