/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A singleton to hold all the commands for the CommandRunner 
 * 	class.
 */

package JIST_test;

import java.util.*;

public class CommandRunnerSingleton {

	private static CommandRunnerSingleton instance = null;

	private static LinkedList<MipavCommand> commands;
	private int thread_count;

	protected CommandRunnerSingleton () {
		// STAY OUT
	}

	public static CommandRunnerSingleton getInstance () {

		if (instance == null) {

			commands = new LinkedList<MipavCommand> ();
			instance = new CommandRunnerSingleton ();

		}
		
		return instance;
	}

	public void set_tc (int n) {
		thread_count = n;
	}

	public int get_tc () {
		return thread_count;
	}

	public void add_command (MipavCommand mc) {
		commands.offer(mc);
	}

	public MipavCommand get_command () {
		return commands.poll();
	}

	public int size () {
		return commands.size();
	}

}
