/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A test that ensures that a specified number of files are
 * 	created when a certain module is run.
 */
package JIST_test;

import java.io.*;
import java.util.*;

import org.junit.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class FileExistenceTest extends TestCase {
	
	private String directory;
	private Double val;

	public FileExistenceTest (String name) {
		super(name);
	}

	@Test 
	public void testFiles() {

		// All of our data is in this singleton.
		FileExistenceSingleton fes = FileExistenceSingleton.getInstance();

		directory 	= fes.get_directory();
		val 		= fes.get_val();

		System.out.println("Checking directory " + directory + 
							" for " + val + " files.");

		double file_count = 0;

		Vector<File> prod_files = 
			new Vector<File>(Arrays.asList((new File(directory)).listFiles()));

		for (File f : prod_files) {
			if (f.getName().endsWith(".xml")) ++file_count;
		}

		assertEquals(file_count, val);
	}
}
