/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: This is actually kinda cool. This class executes MIPAV on the
 * 	command line, but because it extends Callable, we can have a whole bunch
 * 	of them and do interesting things like concurrency.
 */

package JIST_test;

import java.io.*;
import java.util.*;

import java.util.concurrent.Callable;
import java.lang.Runtime;

public class MipavCommand implements Callable {

	private String cmd, test_name, userdir;

	Boolean grid_run;

	public MipavCommand(String cmd_, String test_name_, Boolean gr, String ud) {
		cmd 		= cmd_;
		test_name 	= test_name_;
		grid_run 	= gr;
		userdir 	= ud;
	}

	public Object call() {

		if (!grid_run) { // run locally
			try {
				Process p = Runtime.getRuntime().exec(cmd.split("\\s+"));
				p.waitFor();
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else { // run on the grid

			// read file
			// change shit
			// write file
			// exec
			// wait for <*.completed> file

			StringBuffer sb	= new StringBuffer();

			String 	qs_string = new String(),
					temp_str  = new String(),
				
					out_loc   = "/share/jtest/" + 
							    test_name.replace(".jtest","_dir/"),
					pbs_file  = out_loc	+ 
							    test_name.replace(".jtest",".pbs"),
					qst_loc   = userdir 	+ "/qsub_template",
					comp_file = out_loc 	+ test_name + ".completed",
					comp_cmd  = "touch " 	+ comp_file,
					qsub_cmd  = "qsub " 	+ pbs_file;

			try { // read the qsub template into a string
				BufferedReader in = new BufferedReader(
									new FileReader(qst_loc));
				while ((temp_str = in.readLine()) != null)
					sb.append(temp_str + "\n");
				in.close();
			} catch (IOException e) {
			}

			qs_string = sb.toString();

			// replace parts
			qs_string = qs_string.replace("%%OUTPUTLOC%%", 		out_loc);
			qs_string = qs_string.replace("%%COMMAND%%", 		cmd);
			qs_string = qs_string.replace("%%COMPLETEDFILE%%", 	comp_file);

			// make test-specific output directory
			new File(out_loc).mkdir();

			try { // write modified qsub file
				BufferedWriter out =
					new BufferedWriter(
					new FileWriter(pbs_file));
				out.write(qs_string);
				out.close();
			} catch (Exception e) {
				System.out.println("Exception ");		
			}

			try {
				// this... seems really hacky.
				File f = new File(comp_file);
				if (f.exists()) f.delete();

				Process p = Runtime.getRuntime().exec(qsub_cmd.split("\\s+"));
				p.waitFor();

				while (!f.exists()) {
					Thread.currentThread().sleep(1000);
					f = new File(comp_file);
				}

			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		return test_name;
	}

	@Override
		public String toString() {
			return test_name + ": " + cmd;
		}
}
