/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: This singleton stores all the relevant data for a bunch of 
 *	Surface Comparisons.	
 */

package JIST_test;

import java.util.LinkedList;

public class SurfaceCompareSingleton {

	private static SurfaceCompareSingleton instance = null;
	
	private static LinkedList<TestcaseStrings> 	tcs;
	private static LinkedList<String> 			directory;
	private static LinkedList<String> 			datadir;
	private static LinkedList<String> 			userdir;
	private static LinkedList<String> 			jredir;
	private static LinkedList<String> 			classpath;
	private static LinkedList<String> 			extdirs;

	protected SurfaceCompareSingleton () {
		// we wouldn't want anyone touching this now would we
	}

	public static SurfaceCompareSingleton getInstance () {
		if (instance == null) {
			// initialize vectors here
			tcs 		= new LinkedList<TestcaseStrings>();
			directory   = new LinkedList<String>();
			datadir     = new LinkedList<String>();
			userdir     = new LinkedList<String>();
			jredir      = new LinkedList<String>();
			classpath 	= new LinkedList<String>();
			extdirs 	= new LinkedList<String>();
			instance 	= new SurfaceCompareSingleton();
		}

		return instance;
	}

	public void set_data (	TestcaseStrings t, 
							String dir, String ddir, String udir,
							String jdir, String cp, String ed) {
		tcs.offer 		(t);
		directory.offer (dir);
		datadir.offer 	(ddir);
		userdir.offer 	(udir);
		jredir.offer 	(jdir);
		classpath.offer (cp);
		extdirs.offer   (ed);
	}

	// get methods	
	public TestcaseStrings get_tcs () {
		return tcs.poll();
	}

	public String get_directory () {
		return directory.poll();
	}

	public String get_datadir () {
		return datadir.poll();
	}
	
	public String get_userdir () {
		return userdir.poll();
	}
	public String get_jredir () {
		return jredir.poll();
	}
	public String get_classpath () {
		return classpath.poll();
	}
	public String get_extdirs () {
		return extdirs.poll();
	}

}
