/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: These classes are used for specific point tests when comparing 
 * 	Volumes. Right now the available tests are none, strict, difference,
 * 	and average. 
 */

package JIST_test;

import java.io.*;
import java.util.*;
import java.lang.Math;
import java.lang.Double;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;

class TestOperatorBase {
		
	double tv;
	String name;

	public TestOperatorBase (String name_) {
		name = name_;
	}

	public void set_tv (double tv) {
		this.tv = tv;
	}

	public String get_name () {
		return name;
	}

	public Boolean run (ImageData actual, ImageData expected) {
		System.out.println("RUNNING BASE CLASS");
		return false;
	}

}

class TestStrict extends TestOperatorBase {

	public TestStrict (String n) {
		super(n);
	}

	@Override
	public Boolean run (ImageData actual, ImageData expected) {

		int rows = actual.getRows(),	r = 0, 
			cols = actual.getCols(),	c = 0, 
			slcs = actual.getSlices(), 	s = 0;
		
		String to_file = new String();

		while (r < rows) {
			c = 0;
			while (c < cols) {
				s = 0;
				while (s < slcs) {

					double a = actual.getDouble(r, c, s);
					double e = expected.getDouble(r, c, s);
					if (a != e) return false;

				++s;
				}
			++c;
			}
		++r;
		}

		return true;
	}
}

class TestNone extends TestOperatorBase {


	public TestNone (String n) {
		super(n);
	}
	@Override
	public Boolean run (ImageData actual, ImageData expected) {
		return true;
	}
}
	
class TestDiff extends TestOperatorBase {


	public TestDiff (String n) {
		super(n);
	}
	@Override
	public Boolean run (ImageData actual, ImageData expected) {
		
		int rows = actual.getRows(),	r = 0, 
			cols = actual.getCols(),	c = 0, 
			slcs = actual.getSlices(), 	s = 0;

		while (r < rows) {
			c = 0;
			while (c < cols) {
				s = 0;
				while (s < slcs) {

					System.out.println("(" + r + " " + c + " " + s + ")");

					double a = actual.getDouble(r, c, s);
					double e = expected.getDouble(r, c, s);
					if (Math.abs(a - e) > tv) return false;

				++s;
				}
			++c;
			}
		++r;
		}
		return true;
	}
}

class TestAvg extends TestOperatorBase {


	public TestAvg (String n) {
		super(n);
	}
	@Override
	public Boolean run (ImageData actual, ImageData expected) {
		
		float ravg = 0;
		int  count = 1;
		int   rows = actual.getRows(),	r = 0, 
			  cols = actual.getCols(),	c = 0, 
			  slcs = actual.getSlices(), 	s = 0;

		while (r < rows) {
			c = 0;
			while (c < cols) {
				s = 0;
				while (s < slcs) {

					double a = actual.getDouble(r, c, s);
					double e = expected.getDouble(r, c, s);

					ravg += (Math.abs(a-e))/count;
					++count;

				++s;
				}
			++c;
			}
		++r;
		}
		return ravg > tv;
	}
}
	
class TestHolder {

	public Map<String, TestOperatorBase> tests;

	public TestHolder () {
		tests = new HashMap<String, TestOperatorBase>();
		tests.put("strict", 	new TestStrict("strict"));
		tests.put("none", 		new TestNone("none"));
		tests.put("difference", new TestDiff("difference"));
		tests.put("average", 	new TestAvg("average"));
	}

	public TestOperatorBase get_test(String name) {
		return tests.get(name);
	}
}
