/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: This singleton stores all the relevant data for a bunch of 
 *	Surface Comparisons.	
 */
package JIST_test;

import java.util.LinkedList;

public class VolumeCompareSingleton {

	private static VolumeCompareSingleton instance = null;
	
	// add private static Vectors here
	
	private static LinkedList<TestcaseStrings> tcs;
	private static LinkedList<String> directory;
	private static LinkedList<String> datadir;
	private static LinkedList<String> userdir;

	protected VolumeCompareSingleton () {
		// we wouldn't want anyone touching this now would we
	}

	public static VolumeCompareSingleton getInstance () {
		if (instance == null) {
			// initialize vectors here
			tcs 		= new LinkedList<TestcaseStrings>();
			directory   = new LinkedList<String>();
			datadir     = new LinkedList<String>();
			userdir     = new LinkedList<String>();
			instance = new VolumeCompareSingleton();
		}

		return instance;
	}

	public void set_data (	TestcaseStrings t, 
							String dir, String ddir, String udir) {
		tcs.offer 		(t);
		directory.offer (dir);
		datadir.offer 	(ddir);
		userdir.offer 	(udir);
	}

	// get methods	
	public TestcaseStrings get_tcs () {
		return tcs.poll();
	}

	public String get_directory () {
		return directory.poll();
	}

	public String get_datadir () {
		return datadir.poll();
	}
	
	public String get_userdir () {
		return userdir.poll();
	}

}
