/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A class for comparing Volumes.
 */

package JIST_test;

import java.io.*;
import java.util.*;
import java.lang.Math;
import java.lang.Double;

import org.junit.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;

public class VolumeCompareTest extends TestCase {

	private TestcaseStrings tcs;
	private String directory, datadir, userdir;

	public VolumeCompareTest(String name) {
		super(name);
	}

	// If you want a more specific test, ie "testThisModuleName", and it's a
	// 	Volume comparison, then all you need to do is add that test and call
	// 	this private method. It's all the same stuff under the hood, but this
	// 	makes it easier to differentiate specific tests.

	private Boolean test_volume() {

		VolumeCompareSingleton vcs = VolumeCompareSingleton.getInstance();

		tcs 		= vcs.get_tcs();
		directory 	= vcs.get_directory();
		datadir 	= vcs.get_datadir();
		userdir 	= vcs.get_userdir();

		File fexp = null, fact = null;

		if (tcs.ed_file.contains("{datadir}"))
			tcs.ed_file = tcs.ed_file.replace("{datadir}", datadir);
		if (tcs.ed_file.contains("{userdir}"))
			tcs.ed_file = tcs.ed_file.replace("{userdir}", userdir);
		
		fexp = new File(tcs.ed_file);

		Vector<File> factual = 
			new Vector<File> (Arrays.asList((new File(directory)).listFiles()));

		for (File f : factual) {
			if (f.getName().endsWith(".xml")) {
				fact = f;
				break;
			}
		}

		if (fexp == null)
			System.out.println("Expected data image is null.");
		
		if (fact == null)
			System.out.println("Actual data image is null.");

		if (fact == null || fexp == null) assert(false);

		System.out.println("Expected data location: " + 
							fexp.getAbsolutePath());
		System.out.println("Resulting data location: " + 
							fact.getAbsolutePath());

		ImageData act_data = 
			ImageDataReaderWriter.getInstance().read(fact);							
		ImageData exp_data = 
			ImageDataReaderWriter.getInstance().read(fexp);

		try {

			System.out.println("Actual_data dimensions:");
			System.out.println("\tRows: " + act_data.getRows());
			System.out.println("\tCols: " + act_data.getCols());
			System.out.println("\tSlices: " + act_data.getSlices());

			System.out.println("Expected_data dimensions:");
			System.out.println("\tRows: " + exp_data.getRows());
			System.out.println("\tCols: " + exp_data.getCols());
			System.out.println("\tSlices: " + exp_data.getSlices());
		
		} catch (Error err) {
			System.out.println("Error message: " + err.getMessage());
		} catch (Exception err) {
			System.out.println("Exception message: " + err.getMessage());
		}

		if (act_data.getRows() 		!= exp_data.getRows() ||
			act_data.getCols() 		!= exp_data.getCols() ||
			act_data.getSlices() 	!= exp_data.getSlices()) 
		{
			System.err.println("Error - dimensions do not match");
			assert(false);
		}

		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test(tcs.test_criteria_type.trim());
		
		tob.set_tv(tcs.test_value);

		System.out.println("COMPARISON CRITERIA: " + tob.get_name());

		Boolean test_result = tob.run(act_data, exp_data);

		return test_result;

	}

	@Test 
	public void testVolume() {
		Boolean res = test_volume();
		assertTrue("The result of this generic Volume test.", res);
	}

	@Test
	public void testStaple() {
		Boolean res = test_volume();
		assertTrue("The result of this STAPLE test.", res);
	}
}

