% Set the parameters below and run the script to make plots from the
% CSV files generated by the EM Fiber Clustering Module in Slicer3.
% Mahnaz Maddah, Sept. 2010.

clear all
close all
clc
%%%%% parameters                

% location where CSV files are stored:
params.fileDir = '/fs/corpus1/mahnaz/temp/';

% cluster Ids for which plots need to be generated
params.clusterIds = 1;  %examples: [2,3]   1:5                                                   

% if it's a population study set the following parameter to 1, otherwise to
% 0
params.population = 1;

% set the directory if params.population is 1
params.subjectsDirectory = '/fs/corpus1/asset24_cluster_pilot/slicer_tracts/36/';
params.subjects = dir([params.subjectsDirectory, '*.vt*']);

% add your feature data, below is an example for subjects' age
age = [67.75, 83.02 31.31 77.88 81.24 79.58 33.90 78.88 25.31 80.74 28.46 85.03 75.90 82.15 70.17 20.38 24.16 26.58 28.10 21.16 78.51 28.75 19.98 23.79];

% define the group criteria
group = (age>35);

age = num2cell(age');
[params.subjects.age] = deal(age{:});
cgroup = num2cell(group');
[params.subjects.group] = deal(cgroup{:});

%params.minNumberOfTrajectories = 37;

%%%%% main function
subjects = processCSVfiles(params); 
%%%%%
