package edu.jhmi.rad.medic.visualization.models;

import edu.jhmi.rad.medic.visualization.primitives.BoundingBox;
import edu.jhmi.rad.medic.visualization.DrawParam;

import javax.media.opengl.GLAutoDrawable;

public interface Drawable {
	/*
	 * Called by a master draw routine. Should only draw things only for itself.
	 *	@param	glAutoDrawable	GL drawing object
	 */
	public void drawGL(GLAutoDrawable glAutoDrawable);
	
	/*
	 * Called for setting up an OpenGL Display list
	 *	@param	glAutoDrawable	GL drawing object
	 *	@return					If the object succesfuly setup the list
	 */		
	public boolean setupGLList(GLAutoDrawable glAutoDrawable);
	
	/*
	 * Used to determine if the object should be drawn using the drawGL routine
	 * or using the openGL display list.
	 *	@return					True if using openGL display lists or false.
	 */
	public boolean useGLList();
	
	/*
	 * Requests the drawable to free any resources it is using.
	 */
	 public void dispose();
	
	/*
	 * Sets the drawing paramaters for this object. DrawParams are open eneded with 
	 * no pre-set limitations.
	 *	@param	drawParams		Drawing parameters for this object
	 */
	public void setDrawParam(DrawParam drawParams);
	
	/*
	 * Called for setting up the bounding box for this object.
	 */
	public void computeBoundingBox();
	
	/*
	 * Used for retrieving the boundingbox for this object.
	 *	@return					Bounding box for this object
	 */
	public BoundingBox getBoundingBox();
	
	/*
	 * Called after ctor and before any other routine. Allows object to compute
	 * things essential for it. Ex. Per vertex normals for surfaces
	 */
	public void preCompute();
	
	/*
	 * Gets the name of the drawable
	 */
	public String getName();
}