package edu.jhu.ece.iacl.algorithms.graphics.intersector;

import java.util.ArrayList;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTree;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTriangle;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

/**
 * A surface intersection data structure that is intended for interpolating data
 * that is embedded in surface vertices.
 * 
 * @author Blake Lucas
 * 
 */
public class EmbeddedSurfaceIntersector extends SurfaceIntersector {
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.1 $");
	}

	/**
	 * Initialize surface intersector
	 */
	public void init(EmbeddedSurface mesh, int depth) {
		this.mesh = mesh;
		setLabel("Surface Intersector");
		buildTriangles();
		tree = new KdTree(this, triangles, depth);
		markCompleted();
	}

	/**
	 * Constructor
	 * 
	 * @param parent
	 *            parent calcualtion
	 * @param depth
	 *            maximum depth
	 * @param mesh
	 *            surface mesh
	 */
	public EmbeddedSurfaceIntersector(AbstractCalculation parent, int depth,
			EmbeddedSurface mesh) {
		super(parent);
		init(mesh, depth);
	}

	/**
	 * Build triangle collection for mesh. These triangles are designed for
	 * embedded vertex data interpolation.
	 */
	protected void buildTriangles() {
		int indexCount = mesh.getIndexCount();
		int id1, id2, id3;
		KdTriangle t;
		triangles = new ArrayList<KdTriangle>();
		for (int i = 0; i < indexCount; i += 3) {
			id1 = mesh.getCoordinateIndex(i);
			id2 = mesh.getCoordinateIndex(i + 1);
			id3 = mesh.getCoordinateIndex(i + 2);
			t = new EmbeddedTriangle(i / 3, id1, id2, id3, mesh);
			triangles.add(t);
		}
	}

	/**
	 * Get last intersection triangle which will always be and Embedded Triangle
	 */
	public EmbeddedTriangle getLastIntersectionTriangle() {
		return (EmbeddedTriangle) lastTriangle;
	}
}
