package edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree;

import javax.vecmath.Point3f;

/**
 * Created by IntelliJ IDEA. User: bennett Date: Nov 20, 2005 Time: 9:21:15 AM
 * To change this template use Options | File Templates.
 * ************************************ Magnetic Resonance in Medicine Final
 * Project Released: December 1, 2005
 * 
 * class PT Represent a 3-tuple. For use as a point, vector, etc.
 * 
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public class KdPoint3 extends Point3f {
	// create a new PT
	public KdPoint3(float x0, float y0, float z0) {
		super(x0, y0, z0);
	}

	public KdPoint3(Point3f p) {
		super(p);
	}

	public KdPoint3() {
		super();
	}

	/**
	 * create a new PT
	 */
	public KdPoint3(double x0, double y0, double z0) {
		super((float) x0, (float) y0, (float) z0);
	}

	/**
	 * convert position to an Matlab coordinate index
	 */
	int cor2ind(int sx, int sy) {
		return Math.round(x) + sx * (Math.round(y) + Math.round(z) * sy);
	}

	/**
	 * convert coordinate to a string for debugging
	 */
	public String toString() {
		return "(" + (x) + "," + (y) + "," + (z) + ")";
	}

	/**
	 * perform coordinate-wise equality test
	 */
	public boolean equals(KdPoint3 pt) {
		return (pt.x == x) && (pt.y == y) && (pt.z == z);
	}

	/**
	 * perform coordinate-wise subtraction
	 */
	public KdPoint3 minus(KdPoint3 b) {
		return new KdPoint3(x - b.x, y - b.y, z - b.z);
	}

	/**
	 * perform coordinate-wise addition
	 */
	public KdPoint3 plus(KdPoint3 b) {
		return new KdPoint3(x + b.x, y + b.y, z + b.z);
	}

	/**
	 * perform the vector cross-product
	 */
	public KdPoint3 cross(KdPoint3 b) {
		return new KdPoint3(y * b.z - z * b.y, z * b.x - x * b.z, x * b.y - y
				* b.x);
	}

	/**
	 * multiply by a scalar
	 */
	public KdPoint3 times(float t) {
		return new KdPoint3(x * t, y * t, z * t);
	}

	/**
	 * perform the vector dot product
	 */
	public float dot(KdPoint3 b) {
		return x * b.x + y * b.y + z * b.z;
	}

	/**
	 * compute the L-2 norm of the vector
	 */
	public double length() {
		return Math.sqrt(x * x + y * y + z * z);
	}

}
