package edu.jhu.ece.iacl.algorithms.graphics.map;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.algorithms.manual_label.FastMarchingLabelExtension;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * Map volumetric labels to surface using a nearest-neighbor mapping.
 * 
 * @author Blake Lucas
 *
 */
public class MapLabelsToSurface extends AbstractCalculation {
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.1 $");
	}



	public static final int max_nbhd_sz = 20;

	public MapLabelsToSurface() {
		setLabel("Map Labels to Surface");
	}

	public MapLabelsToSurface(AbstractCalculation parent) {
		super(parent);
		setLabel("Map Labels to Surface");
	}

	public void solve(EmbeddedSurface mesh, ImageData labels) {
		solve(mesh, labels, 0, 10);
	}

	public ImageData solve(EmbeddedSurface mesh, ImageData labels,int minVal,float maxextdist) {
		int vertCount = mesh.getVertexCount();
		Point3f p = new Point3f();
		int lx, ly, lz, hx, hy, hz;
		double val1, val2;
		double mind, minval;
		double d;
		int rows = labels.getRows();
		int cols = labels.getCols();
		int slices = labels.getSlices();
		double[][] vertLabels = new double[vertCount][1];
		setTotalUnits(vertCount);
		FastMarchingLabelExtension fmle=new FastMarchingLabelExtension(this);
		ImageData extLevelSet=fmle.solve(labels, minVal, maxextdist);
		
		for (int n = 0; n < vertCount; n++) {
			p = mesh.getVertex(n);
			lx = (int) Math.floor(p.x);
			ly = (int) Math.floor(p.y);
			lz = (int) Math.floor(p.z);
			hx = (int) Math.ceil(p.x);
			hy = (int) Math.ceil(p.y);
			hz = (int) Math.ceil(p.z);
			val1 = labels.getDouble(lx, ly, lz);
			val2 = labels.getDouble(hx, hy, hz);
			if (val1 > minVal && val2 > minVal) {
				if (p.distance(new Point3f(lx, ly, lz)) < p.distance(new Point3f(hx, hy, hz))) {
					vertLabels[n][0] = val1;
				} else {
					vertLabels[n][0] = val2;
				}
			} else if (val1 > minVal) {
				vertLabels[n][0] = val1;
			} else if (val2 > minVal) {
				vertLabels[n][0] = val2;
			} else {
				mind = 1E30;
				minval = minVal;
				lx = (int) Math.floor(p.x);
				ly = (int) Math.floor(p.y);
				lz = (int) Math.floor(p.z);
				hx = (int) Math.ceil(p.x);
				hy = (int) Math.ceil(p.y);
				hz = (int) Math.ceil(p.z);
				for (int i = lx - max_nbhd_sz; i < hx + max_nbhd_sz; i++) {
					for (int j = ly - max_nbhd_sz; j < hy + max_nbhd_sz; j++) {
						for (int k = lz - max_nbhd_sz; k < hz + max_nbhd_sz; k++) {
							if (i < 0 || j < 0 || k < 0 || i >= rows
									|| j >= cols || k >= slices)
								continue;
							if ((val1 = labels.getDouble(i, j, k)) > minVal) {
								if ((d = p.distance(new Point3f(i, j, k))) < mind) {
									mind = d;
									minval = val1;
								}
							}
						}
					}
				}
				if (minval == minVal) {
					System.out.println("CANNOT FIND " + n+" LABEL "+minval);
				}
				vertLabels[n][0] = minval;
			}
			incrementCompletedUnits();
		}
		
		mesh.setName(mesh.getName()+"_label");
		mesh.setVertexData(vertLabels);
		markCompleted();
		return  extLevelSet;
	}
}
