package edu.jhu.ece.iacl.algorithms.graphics.utilities.quickhull;

/**
 * Represents vertices of the hull, as well as the points from
 * which it is formed.
 *
 * @author John E. Lloyd, Fall 2004
 */
class QVertex
{
	/**
	 * Spatial point associated with this vertex.
	 */
	QPoint3 pnt;

	/**
	 * Back index into an array.
	 */
	int index;

	/**
	 * List forward link.
	 */
 	QVertex prev;

	/**
	 * List backward link.
	 */
 	QVertex next;

	/**
	 * Current face that this vertex is outside of.
	 */
 	QFace face;

	/**
	 * Constructs a vertex and sets its coordinates to 0.
	 */
	public QVertex()
	 { pnt = new QPoint3();
	 }

	/**
	 * Constructs a vertex with the specified coordinates
	 * and index.
	 */
	public QVertex (double x, double y, double z, int idx)
	 {
	   pnt = new QPoint3(x, y, z);
	   index = idx;
	 }

}
