package edu.jhu.ece.iacl.algorithms.thickness;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * Compute thickness by casting a ray orthogonal to one surface until it hits the other surface.
 * There is not gaurantee that the ray will intersect the other surface, so this thickness is not always defined.
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class OrthoProjectionThickness extends ThicknessSolver{
	public OrthoProjectionThickness(double lambda,double isoVal,double lagrangeDeltaT){
		this.isoVal=isoVal;
		this.lambda=lambda;
		this.lagrangeDeltaT=lagrangeDeltaT;
		setLabel("Orthogonal Projection Thickness");
	}
	public void solve(ImageData innerVol,ImageData outerVol){
		this.innerVol=innerVol;
		this.outerVol=outerVol;
		rows=innerVol.getRows();
		cols=innerVol.getCols();
		slices=innerVol.getSlices();
		IsoSurfaceOnGrid surfGen=new IsoSurfaceOnGrid();		
		innerMesh=(ADJUST_BOUNDARY)?surfGen.solveNoMove(innerVol, ConnectivityRule.CONNECT_18_6, (float)isoVal, false):surfGen.solveOriginal(innerVol, ConnectivityRule.CONNECT_18_6, (float)isoVal, false);
		outerMesh=(ADJUST_BOUNDARY)?surfGen.solveNoMove(outerVol, ConnectivityRule.CONNECT_18_6, (float)isoVal, false):surfGen.solveOriginal(outerVol, ConnectivityRule.CONNECT_18_6, (float)isoVal, false);
		computeThickness();
		markCompleted();
	}
	protected void computeThickness() {
		SurfaceIntersector intersect=new SurfaceIntersector(this,13,innerMesh);
		int vertCount=outerMesh.getVertexCount();
		Point3f pt;
		Vector3f v;
		double[][] dists=new double[vertCount][1];
		setTotalUnits(vertCount+innerMesh.getVertexCount());
		for(int id=0;id<vertCount;id++){
			pt=outerMesh.getVertex(id);
			v=outerMesh.getNormal(id);
			v.negate();
			dists[id][0]=intersect.intersectRayDistance(pt,v);
			incrementCompletedUnits();
		}
		
		outerMesh.setVertexData(dists);
		
		intersect=new SurfaceIntersector(this,13,outerMesh);
		vertCount=innerMesh.getVertexCount();
		dists=new double[vertCount][1];
		for(int id=0;id<vertCount;id++){
			pt=innerMesh.getVertex(id);
			v=innerMesh.getNormal(id);
			dists[id][0]=intersect.intersectRayDistance(pt,v);
			incrementCompletedUnits();
		}
		innerMesh.setVertexData(dists);
	}

}
