package edu.jhu.ece.iacl.algorithms.thickness.grid;
import java.util.ArrayList;

import javax.vecmath.Point3f;
/**
 * Outer boundary node that can have more than two neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class ExtendedOuterBoundaryNode extends SimpleOuterBoundaryNode implements ExtendedNode{
	protected ArrayList<EmbeddedNode> neighbors;
	public ExtendedOuterBoundaryNode(Point3f p,Point3f corr){
		super(p,corr);
		neighbors=new ArrayList<EmbeddedNode>();
	}
	public void connect(EmbeddedNode node){
		if(!neighbors.contains(node))neighbors.add(node);
		if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
	}
	public int getConnectivity(){
		return neighbors.size();
	}
	public ArrayList<EmbeddedNode> getNeighbors(){
		return neighbors;
	}
	/*
	public void connect(EmbeddedNode node,int pos){
		super.connect(node, pos);
	
		if(node==this){
			System.err.println("SHOULD NOT CONNECT TO OUTER 2!");
		}
		if(pos>=0&&nbhd[pos]!=null&&nbhd[pos]!=node){
			nbhd[pos].getNeighbors().remove(this);
			neighbors.remove(nbhd[pos]);
		}
		super.connect(node, pos);
		if(node!=null){
			if(!neighbors.contains(node))neighbors.add(node);
			if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
		}
	
	}
*/
	public void disconnect(){
		super.disconnect();
		for(EmbeddedNode node:neighbors){
			if(node instanceof ExtendedNode)((ExtendedNode)node).getNeighbors().remove(this);
		}
	}
	/*
	public ExtendedOuterBoundaryNode clone(){
		ExtendedOuterBoundaryNode dat=new ExtendedOuterBoundaryNode(location,outerPoint);
		dat.chain=chain;
		dat.index=index;
		dat.marchingLabel=marchingLabel;
		dat.regionLabel=regionLabel;
		dat.thickness=thickness;
		dat.innerPoint=new Point3f(innerPoint);
		dat.outerPoint=new Point3f(outerPoint);
		dat.location=(Point3f)location.clone();
		for(int i=0;i<neighbors.size();i++){
			dat.neighbors.add(neighbors.get(i));
		}
		dat.connect(nbhd[0], 0);
		dat.connect(nbhd[1], 1);
		dat.connect(nbhd[2], 2);
		dat.connect(nbhd[3], 3);
		dat.connect(nbhd[4], 4);
		dat.connect(nbhd[5], 5);
		dat.tanget=(Vector3f)tanget.clone();
		return dat;
	}
	 */
}
